/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.Telescope;
import alma.obsprep.bo.obsproject.CalibratedAbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.UnitDependencies;
import alma.obsprep.bo.obsproject.VisitConstraint;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.etc.SourceClusterDetector;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.SchedBlockGenerator;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.MinTuningsCalculator;
import alma.obsprep.services.generator.refactored.OUSStructureBuilderFactory;
import alma.obsprep.services.generator.refactored.OUSStructureBuilderInterface;
import alma.obsprep.services.generator.refactored.SchedBlockPostProcessor;
import alma.obsprep.services.generator.refactored.ousgenerator.OUSGenerator;
import alma.obsprep.services.generator.refactored.ousgenerator.OUSGeneratorFactory;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorFactory;
import alma.obsprep.services.generator.refactored.spectralspec.SpectralSpecFactory;
import alma.obsprep.util.MiscUtils;
import alma.valuetypes.Angle;
import alma.valuetypes.Time;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.lang3.StringUtils;

public class ScienceGoalSchedBlockGenerator
implements SchedBlockGenerator {
    private static CacheAccess<Integer, Integer> tuningsCache = JCS.getInstance((String)"tuningsCache");
    private static final int NO_PREVIOUS_VISIT = 0;
    private final ScienceGoal userDefinedScienceGoal;
    private final OUSGenerator ousGenerator;
    private final ObsUnitSet rootOUS;
    private final SchedBlockPostProcessor schedBlockPostProcessor;

    private boolean canGenerate(@NonNull ScienceGoal scienceGoal) throws WizardSBGenerationException {
        boolean bl;
        int n2;
        Object object;
        int n3;
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (scienceGoal.getTargetParametersCount() == 0) {
            return false;
        }
        TargetParameters[] object3 = scienceGoal.getTargetParameters();
        int unknownEntityException = object3.length;
        for (n3 = 0; n3 < unknownEntityException; ++n3) {
            object = object3[n3];
            if (!object.isPointingPattern() || object.getPointingPattern().getPhaseCenterCoordinates().length >= 1) continue;
            Log.logger(SpectralSpecFactory.class).warning("At least one pointing should be defined: " + object.getSourceName());
            throw new WizardSBGenerationException("At least one pointing should be defined: " + object.getSourceName());
        }
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        try {
            if (performanceParameters.getDesiredLargestScale().isLessThan((AbstractDoubleWithUnit)Angle.createAngle((double)0.0, (String)Angle.UNIT_ARCMIN)) && !this.userDefinedScienceGoal.getObsProposal().isVLBIorPhasedArray()) {
                throw new WizardSBGenerationException("An invalid desired LAS has been specified");
            }
        }
        catch (UnknownEntityException spectralSetupParameters) {
            throw new WizardSBGenerationException("Cannot determine if project is a VLBI project");
        }
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        if (spectralSetupParameters.isSpectralLine()) {
            if (spectralSetupParameters.getScienceSpectralWindowCount() == 0) {
                throw new WizardSBGenerationException("Spectral Setup has no lines and no scans specified");
            }
            if (spectralSetupParameters.isFullPolarisation() && !Telescope.isOTConfiguredAs(Telescope.CSVALMA)) {
                n3 = 0;
                object = spectralSetupParameters.getReceiverBand();
                Set<ReceiverBand> n4 = ReceiverBand.getFullPolarizationReceiverBands();
                String n22 = n4.stream().map(receiverBand -> receiverBand.getNumber()).sorted().map(n -> Integer.toString(n)).collect(Collectors.joining(",", "[", "]"));
                if (object == null) {
                    throw new WizardSBGenerationException("Full polarization only allowed for bands " + n22);
                }
                for (ReceiverBand receiverBand2 : ReceiverBand.getFullPolarizationReceiverBands()) {
                    if (!receiverBand2.equals(object)) continue;
                    n3 = 1;
                    break;
                }
                if (n3 == 0) {
                    throw new WizardSBGenerationException("Full polarization only allowed for bands " + n22);
                }
            }
        }
        object = (n3 = (int)(scienceGoal.isStandAloneACA() ? 1 : 0)) != 0 ? Array.ARRAY_7M : Array.ARRAY_12M;
        int n4 = Stream.of(scienceGoal.getTargetParameters()).mapToInt(arg_0 -> ScienceGoalSchedBlockGenerator.lambda$canGenerate$2((Array)((Object)object), arg_0)).sum();
        if (n4 > (n2 = AlmaPolicies.getInstance().getMaxNumberPointings())) {
            throw new WizardSBGenerationException("The maximum number of " + n2 + " pointings has been exceeded - " + n4 + " are scheduled");
        }
        if (n4 == 0) {
            throw new WizardSBGenerationException("There are no pointings in this science goal");
        }
        if (n3 != 0 && spectralSetupParameters.isFullPolarisation() && (bl = Stream.of(scienceGoal.getTargetParameters()).anyMatch(arg_0 -> ScienceGoalSchedBlockGenerator.lambda$canGenerate$3((Array)((Object)object), arg_0)))) {
            throw new WizardSBGenerationException("Standalone ACA cannot be used with full polarization when any source has more than a single pointing");
        }
        return true;
    }

    public ScienceGoalSchedBlockGenerator(@NonNull CalibratedAbstractScienceGoal calibratedAbstractScienceGoal, @NonNull ObsUnitSet obsUnitSet, boolean bl) {
        if (calibratedAbstractScienceGoal == null) {
            throw new NullPointerException("goal is marked non-null but is null");
        }
        if (obsUnitSet == null) {
            throw new NullPointerException("obsUnitSet is marked non-null but is null");
        }
        this.userDefinedScienceGoal = (ScienceGoal)calibratedAbstractScienceGoal;
        this.rootOUS = obsUnitSet;
        this.ousGenerator = OUSGeneratorFactory.getOUSGenerator(calibratedAbstractScienceGoal);
        SchedBlockPostProcessor.Builder builder = new SchedBlockPostProcessor.Builder();
        builder.isSBGenerationUserInitiated(bl).rootOUS(obsUnitSet).userDefinedScienceGoal(this.userDefinedScienceGoal);
        this.schedBlockPostProcessor = builder.build();
        assert (this.schedBlockPostProcessor != null);
    }

    @Override
    public void generate() throws WizardSBGenerationException {
        Collection<ScienceGoal> collection;
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (this.userDefinedScienceGoal == null) {
            throw new WizardSBGenerationException("Illegal argument. The argument cannot be null: goal");
        }
        SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(this.userDefinedScienceGoal);
        try {
            collection = sourceClusterDetector.splitScienceGoalIntoSourceClusters();
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new WizardSBGenerationException(invalidObsProgramParametersException);
        }
        for (ScienceGoal object2 : collection) {
            if (this.canGenerate(object2)) continue;
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.userDefinedScienceGoal.getName())) {
            this.userDefinedScienceGoal.setName(this.userDefinedScienceGoal.getSoleTargetParameters().getSourceName());
        }
        int n = 1;
        PerformanceParameters performanceParameters = this.userDefinedScienceGoal.getPerformanceParameters();
        boolean bl = false;
        if (performanceParameters.getIsTimeConstrained()) {
            switch (performanceParameters.getTypeOfTimingConstraint()) {
                case TIMINGCONSTRAINTSTYPE_MULTIPLEVISITS: {
                    n = performanceParameters.getVisitConstraintCount();
                    if (n == 0) {
                        throw new WizardSBGenerationException("Multiple visits are selected but no visits are defined");
                    }
                    bl = true;
                    break;
                }
                case TIMINGCONSTRAINT_UNDECIDED: {
                    n = 1;
                    break;
                }
                case TIMINGCONSTRAINTSTYPE_SPECIFICDATES: {
                    if (performanceParameters.getTemporalParametersCount() == 0) {
                        throw new WizardSBGenerationException("Specific dates have been requested but no dates are defined");
                    }
                    n = 1;
                }
            }
        }
        this.rootOUS.setName("SG OUS (" + this.userDefinedScienceGoal.getName() + ")");
        OUSStructureBuilderFactory.OUSStructureTypesEnum oUSStructureTypesEnum = null;
        oUSStructureTypesEnum = this.userDefinedScienceGoal.getPerformanceParameters().getIsSimultaneous12and7() ? OUSStructureBuilderFactory.OUSStructureTypesEnum.Simultaneous12mAndACAObserving : OUSStructureBuilderFactory.OUSStructureTypesEnum.StandardOUSStructure;
        assert (oUSStructureTypesEnum != null);
        OUSStructureBuilderInterface oUSStructureBuilderInterface = OUSStructureBuilderFactory.getOUSStructureBuilder(oUSStructureTypesEnum, this.ousGenerator, this.rootOUS, this.userDefinedScienceGoal);
        oUSStructureBuilderInterface.createOUSStructure(this.schedBlockPostProcessor, collection, n, false, bl);
        if (n > 0 && performanceParameters.getTypeOfTimingConstraint().equals((Object)PerformanceParameters.TimingConstraintType.TIMINGCONSTRAINTSTYPE_MULTIPLEVISITS)) {
            this.createSBTemporalDependencies(this.rootOUS, this.userDefinedScienceGoal, n);
        }
        stopwatch.stop();
        Log.logger(ScienceGoalSchedBlockGenerator.class).info("SB generation took " + String.valueOf(stopwatch));
    }

    public static boolean isMultiTuningOUSStructureRequired(ScienceGoal scienceGoal) {
        if (scienceGoal.isSpectralScan()) {
            ObservingTimeCalculator observingTimeCalculator = new ObservingTimeCalculator(scienceGoal);
            try {
                return observingTimeCalculator.getTotalOnSourceTime(Array.ARRAY_12M, true).isGreaterThan((AbstractDoubleWithUnit)SBGeneratorFactory.SPECTRAL_SCAN_MULTIPLE_SB_THRESHOLD_TIME);
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new WizardSBGenerationException("Unable to determine if a multi-tuning OUS structure is required " + invalidObsProgramParametersException.getMessage());
            }
        }
        return false;
    }

    private void createSBTemporalDependencies(@NonNull ObsUnitSet obsUnitSet, @NonNull ScienceGoal scienceGoal, int n) {
        Collection<ScienceGoal> collection;
        if (obsUnitSet == null) {
            throw new NullPointerException("rootOUS is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("userDefinedScienceGoal is marked non-null but is null");
        }
        if (n < 2) {
            return;
        }
        SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
        try {
            collection = sourceClusterDetector.splitScienceGoalIntoSourceClusters();
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new WizardSBGenerationException(invalidObsProgramParametersException);
        }
        int n2 = collection.size();
        for (int i = 0; i < n; ++i) {
            VisitConstraint visitConstraint = scienceGoal.getPerformanceParameters().getVisitConstraint(i);
            if (visitConstraint.getIsFixedStart()) continue;
            Time time = visitConstraint.getRequiredDelay();
            int n3 = visitConstraint.getPreviousVisitId();
            for (int j = 0; j < n2; ++j) {
                ObsUnitSet obsUnitSet2 = obsUnitSet.getObsUnitSet(i * n2 + j);
                ObsUnitSet obsUnitSet3 = null;
                if (n3 != 0) {
                    obsUnitSet3 = obsUnitSet.getObsUnitSet((n3 - 1) * n2 + j);
                }
                int n4 = obsUnitSet2.getObsUnitSetCount();
                for (int k = 0; k < n4; ++k) {
                    ObsUnitSet obsUnitSet4 = null;
                    if (obsUnitSet3 != null) {
                        obsUnitSet4 = obsUnitSet3.getObsUnitSet(k);
                    }
                    ObsUnitSet obsUnitSet5 = obsUnitSet2.getObsUnitSet(k);
                    for (int i2 = 0; i2 < obsUnitSet5.getSchedBlockCount(); ++i2) {
                        SchedBlock schedBlock = null;
                        SchedBlock schedBlock2 = null;
                        try {
                            if (obsUnitSet4 != null) {
                                schedBlock = obsUnitSet4.getSchedBlock(i2);
                            }
                            schedBlock2 = obsUnitSet5.getSchedBlock(i2);
                        }
                        catch (UnknownEntityException unknownEntityException) {
                            throw new WizardSBGenerationException("Unable to get SB " + unknownEntityException.getMessage());
                        }
                        UnitDependencies unitDependencies = schedBlock2.getUnitDependencies();
                        if (n3 != 0) {
                            unitDependencies.setDelay(time.deepCopy());
                            unitDependencies.addDependencyList(schedBlock.getEntityID());
                        }
                        unitDependencies.setExecutionCount(1);
                        unitDependencies.setExpression("");
                    }
                }
            }
        }
    }

    public static int getNumberOfTunings(@NonNull ScienceGoal scienceGoal) throws IndexOutOfBoundsException, MinTuningsCalculator.UnableToCalculateMinNumberOfTunings {
        if (scienceGoal == null) {
            throw new NullPointerException("originalSG is marked non-null but is null");
        }
        Integer n = MiscUtils.getCacheHashcode(false, new BusinessObject[]{scienceGoal});
        Integer n2 = (Integer)tuningsCache.get((Object)n);
        if (n2 != null) {
            return n2;
        }
        List<ScienceGoal> list = ScienceGoalSchedBlockGenerator.splitByTuning(scienceGoal);
        n2 = list.size();
        tuningsCache.put((Object)n, (Object)n2);
        return n2;
    }

    public static List<ScienceGoal> splitByTuning(@NonNull ScienceGoal scienceGoal) throws IndexOutOfBoundsException, MinTuningsCalculator.UnableToCalculateMinNumberOfTunings {
        if (scienceGoal == null) {
            throw new NullPointerException("originalSG is marked non-null but is null");
        }
        ArrayList<ScienceGoal> arrayList = new ArrayList<ScienceGoal>();
        HashSet<TargetParameters> hashSet = new HashSet<TargetParameters>();
        List<MinTuningsCalculator.TuningResult> list = MinTuningsCalculator.getLO1Tunings(scienceGoal);
        LinkedList<ScienceGoal> linkedList = new LinkedList<ScienceGoal>(list.parallelStream().map(tuningResult -> scienceGoal.deepCopy()).toList());
        for (MinTuningsCalculator.TuningResult tuningResult2 : list) {
            int n;
            TargetParameters targetParameters;
            ScienceGoal scienceGoal2 = linkedList.pop();
            scienceGoal2.getSpectralSetupParameters().setRepresentativeFrequency(scienceGoal.getRepresentativeFrequency());
            Set<TargetParameters> set = tuningResult2.getTargets();
            int n2 = 0;
            HashMap<TargetParameters, TargetParameters> hashMap = new HashMap<TargetParameters, TargetParameters>();
            set.removeAll(hashSet);
            TargetParameters[] targetParametersArray = new TargetParameters[set.size()];
            for (TargetParameters targetParameters2 : set) {
                targetParameters = targetParameters2.deepCopy();
                hashMap.put(targetParameters2, targetParameters);
                targetParametersArray[n2++] = targetParameters;
            }
            TargetParameters targetParameters3 = (TargetParameters)hashMap.get(tuningResult2.getKeyTarget());
            for (n = 0; n < targetParametersArray.length; ++n) {
                if (targetParametersArray[n] != targetParameters3) continue;
                if (n == 0) break;
                targetParameters = targetParametersArray[0];
                targetParametersArray[0] = targetParametersArray[n];
                targetParametersArray[n] = targetParameters;
                break;
            }
            scienceGoal2.setTargetParameters(targetParametersArray);
            for (n = 0; n < scienceGoal2.getTargetParametersCount(); ++n) {
                if (scienceGoal2.getTargetParameters(n) != targetParameters3) continue;
                scienceGoal2.setKeyTargetParameters(n);
                break;
            }
            scienceGoal2.setScienceGoalType(ScienceGoal.ScienceGoalType.TUNINGSPECIFIC);
            arrayList.add(scienceGoal2);
            hashSet.addAll(set);
        }
        return arrayList;
    }

    private static /* synthetic */ boolean lambda$canGenerate$3(Array array, TargetParameters targetParameters) {
        return targetParameters.getNumberOfPointings(array) > 1;
    }

    private static /* synthetic */ int lambda$canGenerate$2(Array array, TargetParameters targetParameters) {
        return targetParameters.getNumberOfPointings(array);
    }

    public static class UnableToDetermineSensitivityException
    extends Exception {
        public UnableToDetermineSensitivityException(String string) {
            super(string);
        }
    }

    public static class UnableToLocateSBException
    extends Exception {
        public UnableToLocateSBException(String string) {
            super(string);
        }
    }
}

