/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.obsparams;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.obsparams.AbstractObservingParametersFactory;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.valuetypes.Frequency;
import alma.valuetypes.IntTimeSource;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.Time;

public class ObservatoryGoalObservingParametersFactory
extends AbstractObservingParametersFactory {
    public ObservatoryGoalObservingParametersFactory(SpectralSpec spectralSpec, TargetWithIntent targetWithIntent, RequestedArray requestedArray, SBGenerationContext sBGenerationContext) {
        super(spectralSpec, targetWithIntent, requestedArray, sBGenerationContext);
    }

    @Override
    public ScienceParameters getScienceParameters(SpectralSetupParameters spectralSetupParameters) {
        BusinessObject businessObject = spectralSetupParameters.getParent();
        if (!(businessObject instanceof ObservatoryGoal)) {
            throw new IllegalArgumentException("ObservatoryGoalCalibratorParametersFactory only processes Observatory Goals!");
        }
        ObservatoryGoal observatoryGoal = (ObservatoryGoal)businessObject;
        ScienceParameters scienceParameters = ScienceParameters.createScienceParameters();
        scienceParameters.setName("Cal Survey Params");
        SpectralSetupParameters spectralSetupParameters2 = observatoryGoal.getSpectralSetupParameters();
        ScienceSpectralWindow scienceSpectralWindow = spectralSetupParameters2.getRepresentativeSpectralWindow();
        Frequency frequency = scienceSpectralWindow.getCenterFrequency();
        scienceParameters.setRepresentativeFrequency(frequency.deepCopy());
        scienceParameters.setRepresentativeBandwidth(spectralSetupParameters2.getRepresentativeBandwidth());
        scienceParameters.setSensitivityGoal(Sensitivity.createSensitivity((double)10.0, (String)Sensitivity.UNIT_JY));
        double d = observatoryGoal.getIntegrationTime().getContentInUnits(Time.UNIT_S);
        scienceParameters.setIntegrationTime(IntTimeSource.createIntTimeSource((double)d, (String)IntTimeSource.UNIT_S));
        return scienceParameters;
    }
}

