/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.network;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.services.network.NetworkService;
import alma.obsprep.services.network.exceptions.NetworkServiceException;
import alma.obsprep.util.GUIUtilities;
import java.util.ArrayList;
import java.util.List;

public class NetworkServiceHandler {
    public static final DialogId dialogId = new DialogId("NetworkService.offline");
    private List<NetworkService> services = new ArrayList<NetworkService>();

    public void addService(NetworkService networkService) {
        if (!this.services.contains(networkService)) {
            this.services.add(networkService);
        }
    }

    public void removeService(NetworkService networkService) {
        this.services.remove(networkService);
    }

    public <T extends NetworkService> T getService(Class<T> clazz) {
        for (NetworkService networkService : this.services) {
            if (!clazz.isInstance(networkService)) continue;
            return (T)networkService;
        }
        return null;
    }

    public void goOnline() {
        for (NetworkService networkService : this.services) {
            this.goOnline(networkService);
        }
    }

    public void goOnline(NetworkService networkService) {
        try {
            networkService.goOnline();
        }
        catch (NetworkServiceException networkServiceException) {
            Log.logger((Object)this).info(networkServiceException.getMessage());
            String string = ".\n\nTo try again later, please visit the OT Connection preferences menu.";
            GUIUtilities.warning(dialogId, networkServiceException.getMessage() + string);
        }
    }
}

