/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.services.summaryfeedback.SpectralScanTuningInfo;
import alma.valuetypes.Frequency;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class SpectralScanTuningsTableModel
extends AbstractTableModel {
    protected SpectralScanTuningInfo scanTuningInfo;
    private final String[] longValues = new String[]{"  1  ", " 100.123456 ", " 100.123456 ", " 100.123456 ", " 100.123456 "};

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public int getRowCount() {
        int n = this.scanTuningInfo == null ? 0 : this.scanTuningInfo.getNumTunings();
        return n;
    }

    public SpectralScanTuningInfo getParameters() {
        return this.scanTuningInfo;
    }

    public void setDocument(SpectralScanTuningInfo spectralScanTuningInfo) {
        this.scanTuningInfo = spectralScanTuningInfo;
    }

    @Override
    public int getColumnCount() {
        return ScanTuningCols.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        ScanTuningCols scanTuningCols = ScanTuningCols.getColumnDescriptor(n);
        return scanTuningCols.getColumnName();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        List<Frequency> list;
        SpectralScan.SpectralScanTunings spectralScanTunings;
        if (this.scanTuningInfo == null) {
            return null;
        }
        try {
            spectralScanTunings = this.scanTuningInfo.getTunings();
        }
        catch (UnableToFindSolutionException unableToFindSolutionException) {
            return null;
        }
        try {
            list = spectralScanTunings.getTuning(n);
        }
        catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException spectralScanTuningException) {
            return null;
        }
        ScanTuningCols scanTuningCols = ScanTuningCols.getColumnDescriptor(n2);
        try {
            switch (scanTuningCols.ordinal()) {
                case 0: {
                    return n + 1;
                }
                case 1: {
                    return list.get(0);
                }
                case 2: {
                    return list.get(1);
                }
                case 3: {
                    return list.get(2);
                }
                case 4: {
                    return list.get(3);
                }
            }
            return null;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public String[] getLongValues() {
        return this.longValues;
    }

    public static enum ScanTuningCols {
        TUNING("Tuning", Integer.class),
        SPW1("Spw1(GHz)", Frequency.class),
        SPW2("Spw2(GHz)", Frequency.class),
        SPW3("Spw3(GHz)", Frequency.class),
        SPW4("Spw4(GHz)", Frequency.class);

        public final String columnName;
        public final Class<?> columnClass;

        protected static int getColumnCount() {
            return ScanTuningCols.values().length;
        }

        protected static ScanTuningCols getColumnDescriptor(int n) {
            return ScanTuningCols.values()[n];
        }

        private ScanTuningCols(String string2, Class<?> clazz) {
            this.columnName = string2;
            this.columnClass = clazz;
        }

        public Class<?> getColumnClass() {
            return this.columnClass;
        }

        public String getColumnName() {
            return this.columnName;
        }
    }
}

