/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util.debug;

import alma.hla.runtime.obsprep.util.Log;
import java.util.Formatter;
import java.util.NoSuchElementException;
import java.util.Vector;

public class TimeStampCollector {
    private static Log.Logger logger = Log.logger(TimeStampCollector.class);
    private static Vector<String> labels = new Vector();
    private static Vector<Long> times = new Vector();

    private TimeStampCollector() {
    }

    public static void add(String string, long l) {
        labels.add(string);
        times.add(l);
    }

    public static void add(String string) {
        TimeStampCollector.add(string, System.currentTimeMillis());
    }

    private static void clear() {
        labels.clear();
        times.clear();
    }

    public static void start() {
        TimeStampCollector.clear();
        TimeStampCollector.add("Start");
    }

    public static void log() {
        for (int i = 1; i < labels.size(); ++i) {
            logger.fine("\n" + TimeStampCollector.getDescription());
        }
    }

    public static String getDescription() {
        Formatter formatter = new Formatter(new StringBuilder());
        for (int i = 1; i < labels.size(); ++i) {
            formatter.format("%s%n", TimeStampCollector.getDescription(i));
        }
        String string = formatter.toString();
        formatter.close();
        return string;
    }

    private static String getDescription(int n) {
        try {
            if (n == 0) {
                return String.format("%45s", labels.get(0));
            }
            return String.format("%45s %5d ms", labels.get(n), times.get(n) - times.get(n - 1));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return indexOutOfBoundsException.getLocalizedMessage();
        }
    }

    public static long startTime() {
        try {
            return times.firstElement();
        }
        catch (NoSuchElementException noSuchElementException) {
            return -1L;
        }
    }

    public static long lastTime() {
        try {
            return times.lastElement();
        }
        catch (NoSuchElementException noSuchElementException) {
            return -1L;
        }
    }
}

