/*
 * Decompiled with CFR 0.152.
 */
package alma.valuetypes;

import alma.entity.xmlbinding.valuetypes.FluxT;
import alma.valuetypes.Frequency;
import alma.valuetypes.data.FluxData;

public class Flux
extends FluxData<Flux> {
    private static final double MAGNITUDE_SHIFT = 11.1;
    private static final double MAGNITUDE_SCALE = -2.5;
    private static final double MAGNITUDE_FREQUENCY_GHZ = 550000.0;

    public Flux(FluxT fluxT) {
        super(fluxT);
    }

    public static Flux createFluxFromVisibleMagnitude(double d) {
        Flux flux = Flux.createFlux();
        flux.setVisibleMagnitude(d);
        return flux;
    }

    public void setVisibleMagnitude(double d) {
        double d2 = Math.pow(10.0, (d + 11.1) / -2.5);
        this.setContent(d2);
        this.setUnit(UNIT_JY);
    }

    public double getVisibleMagnitude() {
        double d = this.getContentInUnits(UNIT_JY);
        double d2 = -2.5 * Math.log10(d) - 11.1;
        return d2;
    }

    public static Frequency visibleCentreFrequency() {
        Frequency frequency = Frequency.createFrequency();
        frequency.setUnit(Frequency.UNIT_GHZ);
        frequency.setContent(550000.0);
        return frequency;
    }

    public String defaultUnit() {
        return this.unitMap().getDefaultUnit();
    }

    public double getmJy() {
        return this.getContentInUnits(UNIT_MJY);
    }

    public double getJy() {
        return this.getContentInUnits(UNIT_JY);
    }
}

