/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.xmlrpc;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.astrogrid.samp.RegInfo;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.client.ClientProfile;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.hub.KeyGenerator;
import org.astrogrid.samp.xmlrpc.ActorHandler;
import org.astrogrid.samp.xmlrpc.HubActor;
import org.astrogrid.samp.xmlrpc.SampXmlRpcClient;
import org.astrogrid.samp.xmlrpc.SampXmlRpcClientFactory;
import org.astrogrid.samp.xmlrpc.XmlRpcCallableClient;

class HubXmlRpcHandler
extends ActorHandler {
    public HubXmlRpcHandler(SampXmlRpcClientFactory xClientFactory, ClientProfile profile, String secret, KeyGenerator keyGen) {
        super("samp.hub.", HubActor.class, new HubActorImpl(xClientFactory, profile, secret, keyGen));
    }

    protected Object invokeMethod(Method method, Object obj, Object[] args) throws IllegalAccessException, InvocationTargetException {
        return method.invoke(obj, args);
    }

    private static class HubActorImpl
    implements HubActor {
        private final SampXmlRpcClientFactory xClientFactory_;
        private final ClientProfile profile_;
        private final String secret_;
        private final KeyGenerator keyGen_;
        private final Map clientMap_;

        HubActorImpl(SampXmlRpcClientFactory xClientFactory, ClientProfile profile, String secret, KeyGenerator keyGen) {
            this.xClientFactory_ = xClientFactory;
            this.profile_ = profile;
            this.secret_ = secret;
            this.keyGen_ = keyGen;
            this.clientMap_ = Collections.synchronizedMap(new HashMap());
        }

        public Map register(String secret) throws SampException {
            if (!this.profile_.isHubRunning()) {
                throw new SampException("Hub not running");
            }
            if (this.secret_.equals(secret)) {
                HubConnection connection = this.profile_.register();
                if (connection == null) {
                    throw new SampException("Hub is not running");
                }
                String privateKey = this.keyGen_.next();
                RegInfo regInfo = connection.getRegInfo();
                regInfo.put("samp.private-key", privateKey);
                this.clientMap_.put(privateKey, connection);
                return regInfo;
            }
            throw new SampException("Bad password");
        }

        public void unregister(String privateKey) throws SampException {
            HubConnection connection = (HubConnection)this.clientMap_.remove(privateKey);
            if (connection == null) {
                throw new SampException("Unknown private key");
            }
            connection.unregister();
        }

        public void ping(String privateKey) throws SampException {
            this.getConnection(privateKey).ping();
        }

        public void setXmlrpcCallback(String privateKey, String surl) throws SampException {
            SampXmlRpcClient xClient;
            try {
                xClient = this.xClientFactory_.createClient(new URL(surl));
            }
            catch (MalformedURLException e) {
                throw new SampException("Bad URL: " + surl, e);
            }
            catch (IOException e) {
                throw new SampException("No connection: " + e.getMessage(), e);
            }
            this.getConnection(privateKey).setCallable(new XmlRpcCallableClient(xClient, privateKey));
        }

        public void declareMetadata(String privateKey, Map metadata) throws SampException {
            this.getConnection(privateKey).declareMetadata(metadata);
        }

        public Map getMetadata(String privateKey, String clientId) throws SampException {
            return this.getConnection(privateKey).getMetadata(clientId);
        }

        public void declareSubscriptions(String privateKey, Map subs) throws SampException {
            this.getConnection(privateKey).declareSubscriptions(subs);
        }

        public Map getSubscriptions(String privateKey, String clientId) throws SampException {
            return this.getConnection(privateKey).getSubscriptions(clientId);
        }

        public List getRegisteredClients(String privateKey) throws SampException {
            return Arrays.asList(this.getConnection(privateKey).getRegisteredClients());
        }

        public Map getSubscribedClients(String privateKey, String mtype) throws SampException {
            return this.getConnection(privateKey).getSubscribedClients(mtype);
        }

        public void notify(String privateKey, String recipientId, Map msg) throws SampException {
            this.getConnection(privateKey).notify(recipientId, msg);
        }

        public List notifyAll(String privateKey, Map msg) throws SampException {
            return this.getConnection(privateKey).notifyAll(msg);
        }

        public String call(String privateKey, String recipientId, String msgTag, Map msg) throws SampException {
            return this.getConnection(privateKey).call(recipientId, msgTag, msg);
        }

        public Map callAll(String privateKey, String msgTag, Map msg) throws SampException {
            return this.getConnection(privateKey).callAll(msgTag, msg);
        }

        public Map callAndWait(String privateKey, String recipientId, Map msg, String timeoutStr) throws SampException {
            int timeout;
            try {
                timeout = SampUtils.decodeInt(timeoutStr);
            }
            catch (Exception e) {
                throw new SampException("Bad timeout format (should be SAMP int)", e);
            }
            return this.getConnection(privateKey).callAndWait(recipientId, msg, timeout);
        }

        public void reply(String privateKey, String msgId, Map response) throws SampException {
            this.getConnection(privateKey).reply(msgId, response);
        }

        public void ping() throws SampException {
            if (!this.profile_.isHubRunning()) {
                throw new SampException("Hub is stopped");
            }
        }

        private HubConnection getConnection(String privateKey) throws SampException {
            HubConnection connection = (HubConnection)this.clientMap_.get(privateKey);
            if (connection == null) {
                throw new SampException("Unknown private key");
            }
            return connection;
        }
    }
}

