/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DOMUtils {
    private static String[] nodeTypeMap;
    static final /* synthetic */ boolean $assertionsDisabled;

    private DOMUtils() {
    }

    public static Element getChildElementByName(Node parent, String name) {
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element childEl;
            String childName;
            if (!(child instanceof Element) || !(childName = (childEl = (Element)child).getTagName()).equals(name)) continue;
            return childEl;
        }
        return null;
    }

    public static String getTextContent(Element el) {
        StringBuffer sb = new StringBuffer();
        for (Node child = el.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Text)) continue;
            Text childText = (Text)child;
            sb.append(childText.getData());
        }
        return sb.toString();
    }

    public static Element getFirstElementSibling(Node node) {
        return node == null || node instanceof Element ? (Element)node : DOMUtils.getFirstElementSibling(node.getNextSibling());
    }

    public static Node relativizeDOM(Node n, URI baseURI, String attname) {
        NamedNodeMap nm;
        if (n == null || baseURI == null) {
            return n;
        }
        if (attname == null) {
            attname = "uri";
        }
        if ((nm = n.getAttributes()) != null) {
            for (int i = 0; i < nm.getLength(); ++i) {
                Attr att = (Attr)nm.item(i);
                if (!att.getName().equals(attname)) continue;
                String oldAttValue = att.getValue();
                try {
                    att.setValue(baseURI.relativize(new URI(oldAttValue)).toString());
                    continue;
                }
                catch (URISyntaxException ex) {
                    att.setValue(oldAttValue);
                }
            }
        }
        for (Node kid = n.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            DOMUtils.relativizeDOM(kid, baseURI, attname);
        }
        return n;
    }

    public static String mapNodeType(short nodeType) {
        if (!$assertionsDisabled && nodeType >= nodeTypeMap.length) {
            throw new AssertionError();
        }
        String val = nodeTypeMap[nodeType];
        if (val == null) {
            val = "UNKNOWN!!!";
        }
        if (!$assertionsDisabled && !(val instanceof String)) {
            throw new AssertionError();
        }
        return val;
    }

    public static Document newDocument() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Unexpected error constructing default document factory", e);
        }
    }

    static {
        $assertionsDisabled = !DOMUtils.class.desiredAssertionStatus();
        nodeTypeMap = new String[16];
        if (!$assertionsDisabled && 2 >= nodeTypeMap.length) {
            throw new AssertionError();
        }
        DOMUtils.nodeTypeMap[2] = "Attribute";
        if (!$assertionsDisabled && 4 >= nodeTypeMap.length) {
            throw new AssertionError();
        }
        DOMUtils.nodeTypeMap[4] = "CDATASection";
        if (!$assertionsDisabled && 8 >= nodeTypeMap.length) {
            throw new AssertionError();
        }
        DOMUtils.nodeTypeMap[8] = "Comment";
        if (!$assertionsDisabled && 11 >= nodeTypeMap.length) {
            throw new AssertionError();
        }
        DOMUtils.nodeTypeMap[11] = "DocumentFragment";
        if (!$assertionsDisabled && 9 >= nodeTypeMap.length) {
            throw new AssertionError();
        }
        DOMUtils.nodeTypeMap[9] = "Document";
        if (!$assertionsDisabled && 10 >= nodeTypeMap.length) {
            throw new AssertionError();
        }
        DOMUtils.nodeTypeMap[10] = "DocumentType";
        if (!$assertionsDisabled && 1 >= nodeTypeMap.length) {
            throw new AssertionError();
        }
        DOMUtils.nodeTypeMap[1] = "Element";
        if (!$assertionsDisabled && 6 >= nodeTypeMap.length) {
            throw new AssertionError();
        }
        DOMUtils.nodeTypeMap[6] = "Entity";
        if (!$assertionsDisabled && 5 >= nodeTypeMap.length) {
            throw new AssertionError();
        }
        DOMUtils.nodeTypeMap[5] = "EntityReference";
        if (!$assertionsDisabled && 12 >= nodeTypeMap.length) {
            throw new AssertionError();
        }
        DOMUtils.nodeTypeMap[12] = "Notation";
        if (!$assertionsDisabled && 7 >= nodeTypeMap.length) {
            throw new AssertionError();
        }
        DOMUtils.nodeTypeMap[7] = "ProcessingInstruction";
        if (!$assertionsDisabled && 3 >= nodeTypeMap.length) {
            throw new AssertionError();
        }
        DOMUtils.nodeTypeMap[3] = "Text";
    }
}

