/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.skycat;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import jsky.catalog.BasicQueryArgs;
import jsky.catalog.Catalog;
import jsky.catalog.FieldDesc;
import jsky.catalog.FieldDescAdapter;
import jsky.catalog.MemoryCatalog;
import jsky.catalog.QueryArgs;
import jsky.catalog.QueryResult;
import jsky.catalog.RowCoordinates;
import jsky.catalog.skycat.SkycatCatalog;
import jsky.catalog.skycat.SkycatConfigEntry;
import jsky.catalog.skycat.SkycatConfigFile;
import jsky.coords.CoordinateRadius;
import jsky.coords.Coordinates;
import jsky.coords.WorldCoords;

public class SkycatTable
extends MemoryCatalog {
    private SkycatConfigEntry _entry;

    public SkycatTable(SkycatCatalog catalog, InputStream in, int maxRows) throws IOException {
        super((Catalog)catalog, in, maxRows);
        if (catalog != null) {
            this.setConfigEntry(catalog.getConfigEntry());
            this.setId(this._entry.getShortName());
        }
        this.checkProperties();
    }

    public SkycatTable(SkycatCatalog catalog, InputStream in, QueryArgs queryArgs) throws IOException {
        this(catalog, in, queryArgs.getMaxRows());
        this.setQueryArgs(queryArgs);
    }

    public SkycatTable(SkycatCatalog catalog, InputStream in) throws IOException {
        this(catalog, in, -1);
    }

    public SkycatTable(SkycatCatalog catalog, String filename) throws IOException {
        super((Catalog)catalog, filename);
        if (catalog != null) {
            this.setConfigEntry(catalog.getConfigEntry());
            this.setId(this._entry.getShortName());
        }
        this.setFilename(filename);
        String name = new File(filename).getName();
        this.setName(name);
        this.setId(name);
        this.setTitle(name);
        this.checkProperties();
    }

    public SkycatTable(SkycatConfigFile cf, String filename) throws IOException {
        this((SkycatCatalog)null, filename);
        this.setConfigEntry(new SkycatConfigEntry(cf, this.getProperties()));
    }

    public SkycatTable(String filename) throws IOException {
        this(SkycatConfigFile.getConfigFile(), filename);
    }

    public SkycatTable(SkycatConfigEntry configEntry, Vector dataRows, FieldDesc[] fields) {
        super(fields, dataRows);
        String name = configEntry.getShortName();
        this.setName(name);
        this.setId(name);
        this.setTitle("Query Results from: " + configEntry.getLongName());
        this.setConfigEntry(configEntry);
        this._initColumnClasses();
    }

    protected SkycatTable(SkycatTable table, FieldDesc[] fields, Vector dataRows) {
        super(fields, dataRows);
        this.setName(table.getName());
        this.setId(table.getId());
        this.setTitle("Query Results from: " + table.getTitle());
        this.setConfigEntry(table.getConfigEntry());
        this._initColumnClasses();
    }

    protected SkycatTable() {
    }

    @Override
    public Catalog getCatalog() {
        Catalog catalog = super.getCatalog();
        if (catalog != null) {
            return catalog;
        }
        String filename = this.getFilename();
        if (filename == null) {
            filename = "unknown";
        }
        if (this._entry == null) {
            Properties properties = new Properties();
            String name = new File(filename).getName();
            properties.setProperty("serv_type", "local");
            properties.setProperty("long_name", name);
            properties.setProperty("short_name", name);
            properties.setProperty("url", filename);
            properties.setProperty("ra_col", "-1");
            properties.setProperty("dec_col", "-1");
            this._entry = new SkycatConfigEntry(properties);
        } else {
            this._entry.setServType("local");
            this._entry.setURLs(new String[]{filename});
        }
        return new SkycatCatalog(this._entry, this);
    }

    public SkycatConfigEntry getConfigEntry() {
        return this._entry;
    }

    public void setConfigEntry(SkycatConfigEntry entry) {
        FieldDesc[] fields;
        Properties p = (Properties)entry.getProperties().clone();
        String servType = p.getProperty("serv_type");
        if (servType == null || !servType.equals("local")) {
            p.setProperty("serv_type", "local");
            p.remove("search_cols");
            p.setProperty("short_name", entry.getShortName());
            p.setProperty("long_name", entry.getLongName());
            this._entry = new SkycatConfigEntry(p);
        } else {
            this._entry = entry;
        }
        RowCoordinates rowCoordinates = entry.getRowCoordinates();
        this.setRowCoordinates(rowCoordinates);
        if (rowCoordinates.isWCS() && (fields = this.getFields()) != null) {
            int decCol;
            int raCol;
            int idCol = rowCoordinates.getIdCol();
            if (idCol >= 0 && idCol < fields.length) {
                ((FieldDescAdapter)fields[idCol]).setIsId(true);
            }
            if ((raCol = rowCoordinates.getRaCol()) >= 0 && raCol < fields.length) {
                ((FieldDescAdapter)fields[raCol]).setIsRA(true);
            }
            if ((decCol = rowCoordinates.getDecCol()) >= 0 && decCol < fields.length) {
                ((FieldDescAdapter)fields[decCol]).setIsDec(true);
            }
        }
    }

    protected void checkProperties() {
        String name = this.getName();
        String id = this.getId();
        String title = this.getTitle();
        Properties properties = this.getProperties();
        if (properties.getProperty("serv_type") == null) {
            if (name == null) {
                if (id != null) {
                    this.setName(id);
                } else {
                    this.setName("unknown");
                }
            }
            if (id == null) {
                this.setId(name);
            }
            if (title == null) {
                this.setTitle(name);
            }
            properties.setProperty("serv_type", "local");
            properties.setProperty("long_name", this.getName());
            properties.setProperty("short_name", this.getId());
            properties.setProperty("url", "none");
        }
    }

    @Override
    protected MemoryCatalog makeQueryResult(FieldDesc[] fields, Vector dataRows) {
        SkycatTable table = new SkycatTable(this, fields, dataRows);
        table.setProperties(this.getProperties());
        return table;
    }

    @Override
    protected void _saveProperties(PrintStream out) {
        Properties properties = this.getProperties();
        out.println("# Begin properties");
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.equals("long_name") || key.equals("short_name") || key.equals("url") || key.equals("serv_type")) continue;
            out.println(key + ": " + properties.getProperty(key));
        }
        out.println("# End properties");
        out.println("");
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("usage: java -classpath ... SkycatTable filename");
            System.exit(1);
        }
        SkycatTable cat = null;
        try {
            cat = new SkycatTable(args[0]);
            cat.saveAsSkycatTable(System.out);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("");
        System.out.println("test row,col access:");
        System.out.println("table(0,0) = " + cat.getValueAt(0, 0));
        System.out.println("table(3,4) = " + cat.getValueAt(3, 4));
        System.out.println("table(3, ra) = " + cat.getValueAt(3, "ra"));
        System.out.println("table(3, RA) = " + cat.getValueAt(3, "RA"));
        System.out.println("table(3, dec) = " + cat.getValueAt(3, "dec"));
        System.out.println("table(3, Dec) = " + cat.getValueAt(3, "Dec"));
        try {
            SkycatTable table;
            System.out.println("");
            System.out.println("test query: of GSC0285601186");
            BasicQueryArgs q = new BasicQueryArgs(cat);
            q.setId("GSC0285601186");
            QueryResult r = cat.query(q);
            if (r instanceof SkycatTable) {
                table = (SkycatTable)r;
                System.out.println("Number of result rows: " + table.getRowCount());
                if (table.getRowCount() != 0) {
                    System.out.println("result: " + r.toString());
                }
            } else {
                System.out.println("Failed search by ID");
            }
            System.out.println("");
            System.out.println("test query: at center position/radius: ");
            q = new BasicQueryArgs(cat);
            q.setRegion(new CoordinateRadius((Coordinates)new WorldCoords("03:19:44.44", "+41:30:58.21"), 1.0));
            r = cat.query(q);
            if (r instanceof SkycatTable) {
                table = (SkycatTable)r;
                System.out.println("Number of result rows: " + table.getRowCount());
                if (table.getRowCount() != 0) {
                    System.out.println("result: " + r.toString());
                }
            } else {
                System.out.println("Failed search by position");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

