/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging;

import alma.acs.logging.config.LogConfig;
import alma.acs.logging.config.LogConfigSubscriber;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

class LogThrottle {
    private final LogStreamThrottle localLogThrottle;
    private final LogStreamThrottle remoteLogThrottle;
    private final ThrottleCallback throttleCallback;
    private final AtomicBoolean localLogsSuppressed = new AtomicBoolean(false);
    private final AtomicBoolean remoteLogsSuppressed = new AtomicBoolean(false);

    LogThrottle(LogConfig logConfig, ThrottleCallback throttleCallback) {
        this.localLogThrottle = new LogStreamThrottle(logConfig);
        this.remoteLogThrottle = new LogStreamThrottle(logConfig);
        this.throttleCallback = throttleCallback;
    }

    boolean checkPublishLogRecordLocal() {
        boolean thisLogSuppressed = !this.localLogThrottle.checkPublishLogRecord();
        boolean lastLocalLogSuppressed = this.localLogsSuppressed.getAndSet(thisLogSuppressed);
        if (thisLogSuppressed) {
            this.throttleCallback.suppressedLog(false);
        } else if (lastLocalLogSuppressed && !this.remoteLogsSuppressed.get()) {
            this.throttleCallback.clearedLogSuppression();
        }
        return !thisLogSuppressed;
    }

    boolean checkPublishLogRecordRemote() {
        boolean thisLogSuppressed = !this.remoteLogThrottle.checkPublishLogRecord();
        boolean lastRemoteLogSuppressed = this.remoteLogsSuppressed.getAndSet(thisLogSuppressed);
        if (thisLogSuppressed) {
            this.throttleCallback.suppressedLog(true);
        } else if (lastRemoteLogSuppressed && !this.localLogsSuppressed.get()) {
            this.throttleCallback.clearedLogSuppression();
        }
        return !thisLogSuppressed;
    }

    private static class LogStreamThrottle
    implements LogConfigSubscriber {
        private int maxLogsPerInterval = -1;
        private final long intervalLengthMillis = 1000L;
        private long intervalBeginMillis;
        private final AtomicInteger logCounter = new AtomicInteger(0);

        public LogStreamThrottle(LogConfig logConfig) {
            this.intervalBeginMillis = System.currentTimeMillis();
            if (logConfig == null) {
                throw new NullPointerException("LogConfig must not be null");
            }
            this.configureLogging(logConfig);
            logConfig.addSubscriber(this);
        }

        @Override
        public void configureLogging(LogConfig logConfig) {
            this.maxLogsPerInterval = logConfig.getMaxLogsPerSecond();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean checkPublishLogRecord() {
            if (this.maxLogsPerInterval < 0) {
                return true;
            }
            long time = System.currentTimeMillis();
            if (time > this.intervalBeginMillis + 1000L) {
                AtomicInteger atomicInteger = this.logCounter;
                synchronized (atomicInteger) {
                    this.intervalBeginMillis = time;
                    this.logCounter.set(0);
                }
            }
            return this.logCounter.getAndIncrement() < this.maxLogsPerInterval;
        }
    }

    static interface ThrottleCallback {
        public void suppressedLog(boolean var1);

        public void clearedLogSuppression();
    }
}

