/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Library;
import java.io.IOException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.cone.ConeQueryRowSequence;
import uk.ac.starlink.ttools.cone.QuerySequenceFactory;
import uk.ac.starlink.ttools.jel.JELUtils;
import uk.ac.starlink.ttools.jel.SequentialJELRowReader;

public class JELQuerySequenceFactory
implements QuerySequenceFactory {
    private final String raString_;
    private final String decString_;
    private final String srString_;

    public JELQuerySequenceFactory(String raExpr, String decExpr, String srExpr) {
        this.raString_ = raExpr;
        this.decString_ = decExpr;
        this.srString_ = srExpr;
    }

    public ConeQueryRowSequence createQuerySequence(StarTable table) throws IOException {
        return new JELQuerySequence(table);
    }

    private class JELQuerySequence
    extends SequentialJELRowReader
    implements ConeQueryRowSequence {
        private final Library lib_;
        private final CompiledExpression raExpr_;
        private final CompiledExpression decExpr_;
        private final CompiledExpression srExpr_;

        JELQuerySequence(StarTable table) throws IOException {
            super(table);
            this.lib_ = JELUtils.getLibrary(this);
            this.raExpr_ = this.compileDouble(JELQuerySequenceFactory.this.raString_);
            this.decExpr_ = this.compileDouble(JELQuerySequenceFactory.this.decString_);
            this.srExpr_ = this.compileDouble(JELQuerySequenceFactory.this.srString_);
        }

        public double getRa() throws IOException {
            return this.doEvaluateDouble(this.raExpr_);
        }

        public double getDec() throws IOException {
            return this.doEvaluateDouble(this.decExpr_);
        }

        public double getRadius() throws IOException {
            return this.doEvaluateDouble(this.srExpr_);
        }

        private CompiledExpression compileDouble(String sexpr) throws IOException {
            try {
                return JELUtils.compile(this.lib_, this.getTable(), sexpr, Double.TYPE);
            }
            catch (CompilationException e) {
                throw new IOException("Bad numeric expression \"" + sexpr + "\"" + " - " + e.getMessage());
            }
        }

        private double doEvaluateDouble(CompiledExpression expr) throws IOException {
            try {
                return this.evaluateDouble(expr);
            }
            catch (Throwable e) {
                throw new IOException("Evaluation error: " + expr);
            }
        }
    }
}

