/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.Point;
import uk.ac.starlink.ttools.plot.PlotData;
import uk.ac.starlink.ttools.plot.PointIterator;
import uk.ac.starlink.ttools.plot.PointPlacer;
import uk.ac.starlink.ttools.plot.PointSequence;

public class PlotDataPointIterator
extends PointIterator {
    private final PlotData data_;
    private final PointPlacer placer_;
    private final int nset_;
    private final int[] point_;
    private PointSequence pseq_;
    private int ip_ = -1;

    public PlotDataPointIterator(PlotData data, PointPlacer placer) {
        this.data_ = data;
        this.placer_ = placer;
        this.nset_ = data.getSetCount();
        this.pseq_ = data.getPointSequence();
        this.point_ = new int[3];
    }

    protected int[] nextPoint() {
        while (this.pseq_ != null && this.pseq_.next()) {
            Point xy;
            ++this.ip_;
            boolean use = false;
            for (int is = 0; is < this.nset_ && !use; ++is) {
                use = use || this.pseq_.isIncluded(is);
            }
            if (!use || (xy = this.placer_.getXY(this.pseq_.getPoint())) == null) continue;
            this.point_[0] = this.ip_;
            this.point_[1] = xy.x;
            this.point_[2] = xy.y;
            return this.point_;
        }
        this.pseq_.close();
        this.pseq_ = null;
        return null;
    }
}

