/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.ac.starlink.ttools.plot.ColorTweaker;
import uk.ac.starlink.ttools.plot.DataColorTweaker;
import uk.ac.starlink.ttools.plot.MarkStyle;
import uk.ac.starlink.ttools.plot.PixelMask;
import uk.ac.starlink.ttools.plot.PlotVolume;
import uk.ac.starlink.ttools.plot.Point3D;

public class VectorSortPlotVolume
extends PlotVolume {
    private final DataColorTweaker markTweaker_;
    private final DataColorTweaker labelTweaker_;
    private final Rectangle bounds_;
    private List pointList_;
    private int iseq_;
    private boolean hasLabels_;
    private final int[] rgbs_;
    private final float[][] frgbs_;
    private final int[] labelRgbs_;
    private final float[][] labelFrgbs_;
    private final MarkStyle[] styles_;
    private final FixColorTweaker fixer_;
    private final float[] frgba_;
    private static final int NO_RGBA = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public VectorSortPlotVolume(Component c, Graphics g, MarkStyle[] styles, double padFactor, int[] padBorders, double fogginess, DataColorTweaker tweaker) {
        super(c, g, styles, padFactor, padBorders, fogginess);
        this.bounds_ = c.getBounds();
        this.pointList_ = new ArrayList();
        this.markTweaker_ = this.createFoggingTweaker(tweaker);
        this.labelTweaker_ = this.createFoggingTweaker(null);
        int nstyle = styles.length;
        this.frgba_ = new float[4];
        this.styles_ = styles;
        this.rgbs_ = new int[nstyle];
        this.labelRgbs_ = new int[nstyle];
        this.frgbs_ = new float[nstyle][];
        this.labelFrgbs_ = new float[nstyle][];
        for (int is = 0; is < nstyle; ++is) {
            Color color = styles[is].getColor();
            this.rgbs_[is] = color.getRGB();
            this.frgbs_[is] = color.getRGBComponents(null);
            Color labelColor = styles[is].getLabelColor();
            this.labelRgbs_[is] = labelColor.getRGB();
            this.labelFrgbs_[is] = labelColor.getRGBComponents(null);
        }
        this.fixer_ = new FixColorTweaker();
    }

    public void plot2d(int px, int py, double z, double[] coords, int istyle, boolean showPoint, String label, int nerr, int[] xoffs, int[] yoffs, double[] zerrs) {
        int rgb = this.getMarkRgb(istyle, coords);
        if (rgb != 0) {
            VectorPoint3D p3;
            boolean hasErr = nerr > 0;
            boolean hasLabel = label != null;
            boolean bl = this.hasLabels_ = this.hasLabels_ || hasLabel;
            if (hasErr || hasLabel) {
                int labelRgb = this.getLabelRgb(istyle, coords);
                p3 = new ExtrasVectorPoint3D(this.iseq_++, z, px, py, istyle, rgb, showPoint, label, labelRgb, nerr, xoffs, yoffs);
            } else if (showPoint) {
                p3 = new VectorPoint3D(this.iseq_++, z, px, py, istyle, rgb);
            } else {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"pointless call");
                }
                p3 = null;
            }
            this.addPoint(p3);
        }
    }

    public void flush() {
        VectorPoint3D[] points = this.getSortedPoints();
        int np = points.length;
        Graphics g = this.getGraphics();
        if (this.hasLabels_) {
            PixelMask mask = new PixelMask(this.bounds_);
            for (int ip = 0; ip < np; ++ip) {
                VectorPoint3D point = points[ip];
                if (!point.hasLabel()) continue;
                int px = point.px_;
                int py = point.py_;
                if (!mask.get(px, py)) {
                    point.render(g, this, true);
                    continue;
                }
                point.render(g, this, false);
                mask.set(px, py);
            }
        } else {
            for (int ip = 0; ip < np; ++ip) {
                points[ip].render(g, this, false);
            }
        }
    }

    private void addPoint(VectorPoint3D point) {
        this.pointList_.add(point);
    }

    private VectorPoint3D[] getSortedPoints() {
        VectorPoint3D[] points = this.pointList_.toArray(new VectorPoint3D[0]);
        this.pointList_ = new ArrayList();
        Arrays.sort(points, Point3D.getComparator(false, true));
        return points;
    }

    private int getMarkRgb(int istyle, double[] coords) {
        return this.getRgb(coords, this.markTweaker_, this.rgbs_[istyle], this.frgbs_[istyle]);
    }

    private int getLabelRgb(int istyle, double[] coords) {
        return this.getRgb(coords, this.labelTweaker_, this.labelRgbs_[istyle], this.labelFrgbs_[istyle]);
    }

    private int getRgb(double[] coords, DataColorTweaker tweaker, int rgb, float[] frgb) {
        if (tweaker == null) {
            return rgb;
        }
        this.frgba_[0] = frgb[0];
        this.frgba_[1] = frgb[1];
        this.frgba_[2] = frgb[2];
        this.frgba_[3] = frgb[3];
        if (tweaker.setCoords(coords)) {
            tweaker.tweakColor(this.frgba_);
            float r = this.frgba_[0];
            float b = this.frgba_[2];
            this.frgba_[2] = r;
            this.frgba_[0] = b;
            return VectorSortPlotVolume.packRgba(this.frgba_);
        }
        return 0;
    }

    static {
        $assertionsDisabled = !VectorSortPlotVolume.class.desiredAssertionStatus();
    }

    private static class ExtrasVectorPoint3D
    extends VectorPoint3D {
        final boolean showPoint_;
        final String label_;
        final int labelRgb_;
        final int nerr_;
        final int[] xoffs_;
        final int[] yoffs_;

        public ExtrasVectorPoint3D(int iseq, double z, int px, int py, int istyle, int rgb, boolean showPoint, String label, int labelRgb, int nerr, int[] xoffs, int[] yoffs) {
            super(iseq, z, px, py, istyle, rgb);
            this.showPoint_ = showPoint;
            this.label_ = label;
            this.labelRgb_ = labelRgb;
            this.nerr_ = nerr;
            this.xoffs_ = nerr > 0 ? (int[])xoffs.clone() : null;
            this.yoffs_ = nerr > 0 ? (int[])yoffs.clone() : null;
        }

        public boolean hasLabel() {
            return this.label_ != null;
        }

        public void render(Graphics g, VectorSortPlotVolume plotVol, boolean withLabel) {
            MarkStyle style = this.getStyle(plotVol);
            FixColorTweaker tweaker = this.getColorTweaker(plotVol);
            if (this.nerr_ > 0) {
                style.drawErrors(g, this.px_, this.py_, this.xoffs_, this.yoffs_, tweaker);
            }
            if (this.showPoint_) {
                style.drawMarker(g, this.px_, this.py_, tweaker);
            }
            if (withLabel && this.label_ != null) {
                tweaker.setRgb(this.labelRgb_);
                style.drawLabel(g, this.px_, this.py_, this.label_, tweaker);
            }
        }
    }

    private static class VectorPoint3D
    extends Point3D {
        final int px_;
        final int py_;
        final int isrgb_;

        public VectorPoint3D(int iseq, double z, int px, int py, int istyle, int rgb) {
            super(iseq, z);
            this.px_ = px;
            this.py_ = py;
            this.isrgb_ = (istyle & 0xFF) << 24 | rgb & 0xFFFFFF;
        }

        FixColorTweaker getColorTweaker(VectorSortPlotVolume plotVol) {
            FixColorTweaker fixer = plotVol.fixer_;
            fixer.setRgb(this.isrgb_ & 0xFFFFFF);
            return fixer;
        }

        MarkStyle getStyle(VectorSortPlotVolume plotVol) {
            return plotVol.styles_[(this.isrgb_ & 0xFF000000) >> 24];
        }

        public boolean hasLabel() {
            return false;
        }

        public void render(Graphics g, VectorSortPlotVolume plotVol, boolean withLabel) {
            MarkStyle style = this.getStyle(plotVol);
            FixColorTweaker tweaker = this.getColorTweaker(plotVol);
            style.drawMarker(g, this.px_, this.py_, tweaker);
        }
    }

    private static class FixColorTweaker
    implements ColorTweaker {
        private static final float BYTE_SCALE = 0.0039064027f;
        private int rgb_;
        private Color color_;
        private boolean fok_;
        private float fr_;
        private float fg_;
        private float fb_;

        private FixColorTweaker() {
        }

        void setRgb(int rgb) {
            this.rgb_ = rgb;
            this.color_ = null;
            this.fok_ = false;
        }

        public Color tweakColor(Color color) {
            if (this.color_ == null) {
                this.color_ = new Color(this.rgb_);
            }
            return this.color_;
        }

        public void tweakColor(float[] rgba) {
            if (!this.fok_) {
                this.fr_ = (float)((this.rgb_ & 0xFF0000) >> 16) * 0.0039064027f;
                this.fg_ = (float)((this.rgb_ & 0xFF00) >> 8) * 0.0039064027f;
                this.fb_ = (float)((this.rgb_ & 0xFF) >> 0) * 0.0039064027f;
                this.fok_ = true;
            }
            rgba[0] = this.fr_;
            rgba[1] = this.fg_;
            rgba[2] = this.fb_;
        }
    }
}

