/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Iterator;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.task.ExtraParameter;
import uk.ac.starlink.ttools.task.TableEnvironment;

public class XmlEncodingParameter
extends Parameter
implements ExtraParameter {
    private Charset charset_;

    public XmlEncodingParameter(String name) {
        super(name);
        this.setUsage("<xml-encoding>");
        this.setNullPermitted(true);
        this.setDescription(new String[]{"<p>Selects the Unicode encoding used for the output XML.", "The available options and default are dependent on your JVM,", "but the default probably corresponds to UTF-8.", "Use <code>help=" + this.getName() + "</code> for a full listing.", "</p>"});
    }

    public String getExtraUsage(TableEnvironment env) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('\n').append("   Supported encodings:\n");
        Iterator<String> it = Charset.availableCharsets().keySet().iterator();
        while (it.hasNext()) {
            sbuf.append("      ").append(it.next().toString()).append('\n');
        }
        return sbuf.toString();
    }

    public Charset charsetValue(Environment env) throws TaskException {
        this.checkGotValue(env);
        return this.charset_;
    }

    public void setValueFromString(Environment env, String sval) throws TaskException {
        try {
            this.charset_ = sval == null ? null : Charset.forName(sval);
            super.setValueFromString(env, sval);
        }
        catch (UnsupportedCharsetException e) {
            throw new ParameterValueException((Parameter)this, (Throwable)e);
        }
        catch (IllegalCharsetNameException e) {
            throw new ParameterValueException((Parameter)this, (Throwable)e);
        }
    }
}

