/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.interactor;

import diva.canvas.event.LayerEvent;
import diva.canvas.event.MouseFilter;
import diva.canvas.interactor.Interactor;

public abstract class AbstractInteractor
implements Interactor {
    private boolean _consuming = true;
    private boolean _enabled = true;
    private boolean _motionEnabled = false;
    private MouseFilter _mouseFilter = MouseFilter.defaultFilter;

    public boolean accept(LayerEvent event) {
        return this.isEnabled() && this.getMouseFilter().accept(event);
    }

    public MouseFilter getMouseFilter() {
        return this._mouseFilter;
    }

    public boolean isConsuming() {
        return this._consuming;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public boolean isMotionEnabled() {
        return this._motionEnabled;
    }

    public void mouseDragged(LayerEvent layerEvent) {
    }

    public void mouseEntered(LayerEvent layerEvent) {
    }

    public void mouseExited(LayerEvent layerEvent) {
    }

    public void mouseMoved(LayerEvent layerEvent) {
    }

    public void mousePressed(LayerEvent layerEvent) {
    }

    public void mouseReleased(LayerEvent layerEvent) {
    }

    public void mouseClicked(LayerEvent layerEvent) {
    }

    public void setConsuming(boolean flag) {
        this._consuming = flag;
    }

    public void setEnabled(boolean flag) {
        this._enabled = flag;
    }

    protected void setMotionEnabled(boolean flag) {
        this._motionEnabled = flag;
    }

    public void setMouseFilter(MouseFilter filter) {
        this._mouseFilter = filter;
    }
}

