/*
 * Decompiled with CFR 0.152.
 */
package diva.resource;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;

public class RelativeBundle
extends ResourceBundle {
    private Class _loader;
    private HashMap _imageIcons = new HashMap();
    private ResourceBundle _delegate;

    public RelativeBundle(String baseName, Class loader, ResourceBundle overrides) {
        try {
            this._delegate = ResourceBundle.getBundle(baseName, Locale.getDefault());
        }
        catch (MissingResourceException e) {
            System.err.println(baseName + ".properties not found");
            System.exit(1);
        }
        this._loader = loader == null ? this.getClass() : loader;
        if (overrides != null) {
            this.setParent(overrides);
        }
    }

    public URL getResource(String key) {
        String s = this.getString(key);
        return this._loader.getResource(s);
    }

    public InputStream getResourceAsStream(String key) {
        String s = this.getString(key);
        return this._loader.getResourceAsStream(s);
    }

    public ImageIcon getImageIcon(String key) {
        URL url;
        ImageIcon icon = (ImageIcon)this._imageIcons.get(key);
        if (icon == null && (url = this.getResource(key)) != null) {
            icon = new ImageIcon(url);
            this._imageIcons.put(key, icon);
        }
        return icon;
    }

    public Image getImage(String key) {
        URL url = this.getResource(key);
        if (url != null) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            Image img = tk.getImage(url);
            return img;
        }
        return null;
    }

    protected Object handleGetObject(String key) throws MissingResourceException {
        try {
            return this._delegate.getObject(key);
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    public Enumeration getKeys() {
        return this._delegate.getKeys();
    }
}

