/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.graphics;

import diva.canvas.interactor.SelectionInteractor;
import diva.util.java2d.Polygon2D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JFrame;
import jsky.image.graphics.DivaImageGraphics;
import jsky.image.gui.DivaGraphicsImageDisplay;
import jsky.util.gui.BasicWindowMonitor;

public class ShapeUtil {
    public static final int ARROW_SIZE = 8;

    public static Shape makePlus(Point2D.Double center, Point2D.Double north, Point2D.Double east) {
        Point2D.Double south = new Point2D.Double(center.x - (north.x - center.x), center.y - (north.y - center.y));
        Point2D.Double west = new Point2D.Double(center.x + (center.x - east.x), center.y + (center.y - east.y));
        GeneralPath path = new GeneralPath();
        path.append(new Line2D.Double(east, west), false);
        path.append(new Line2D.Double(north, south), false);
        return path;
    }

    public static Shape makeCross(double x, double y, double size) {
        Point2D.Double sw = new Point2D.Double(x - size, y + size);
        Point2D.Double se = new Point2D.Double(x + size, y + size);
        Point2D.Double nw = new Point2D.Double(x - size, y - size);
        Point2D.Double ne = new Point2D.Double(x + size, y - size);
        GeneralPath path = new GeneralPath();
        path.append(new Line2D.Double(se, nw), false);
        path.append(new Line2D.Double(sw, ne), false);
        return path;
    }

    public static Shape makeTriangle(double x, double y, double size) {
        Point2D.Double north = new Point2D.Double(x, y - size);
        Point2D.Double sw = new Point2D.Double(x - size, y + size);
        Point2D.Double se = new Point2D.Double(x + size, y + size);
        Polygon2D.Double p = new Polygon2D.Double();
        p.moveTo(se.x, se.y);
        p.lineTo(sw.x, sw.y);
        p.lineTo(north.x, north.y);
        p.closePath();
        return p;
    }

    public static Shape makeDiamond(double x, double y, double size) {
        Point2D.Double north = new Point2D.Double(x, y - size);
        Point2D.Double east = new Point2D.Double(x - size, y);
        Point2D.Double south = new Point2D.Double(x, y + size);
        Point2D.Double west = new Point2D.Double(x + size, y);
        Polygon2D.Double p = new Polygon2D.Double();
        p.moveTo(east.x, east.y);
        p.lineTo(north.x, north.y);
        p.lineTo(west.x, west.y);
        p.lineTo(south.x, south.y);
        p.closePath();
        return p;
    }

    public static Shape makeSquare(double x, double y, double size) {
        return new Rectangle2D.Double(x - size, y - size, size * 2.0, size * 2.0);
    }

    public static Shape makeEllipse(double x, double y, double size) {
        return new Ellipse2D.Double(x - size, y - size, size * 2.0, size * 2.0);
    }

    public static Shape makeEllipse(Point2D.Double center, Point2D.Double north, Point2D.Double east) {
        Point2D.Double south = new Point2D.Double(center.x - (north.x - center.x), center.y - (north.y - center.y));
        Point2D.Double west = new Point2D.Double(center.x + (center.x - east.x), center.y + (center.y - east.y));
        GeneralPath p = new GeneralPath();
        p.moveTo((float)north.x, (float)north.y);
        p.quadTo((float)west.x, (float)west.y, (float)south.x, (float)south.y);
        p.quadTo((float)east.x, (float)east.y, (float)north.x, (float)north.y);
        p.closePath();
        return p;
    }

    public static Shape makeCompass(Point2D.Double center, Point2D.Double north, Point2D.Double east) {
        GeneralPath path = new GeneralPath();
        path.append(new Line2D.Double(center, east), false);
        ShapeUtil.addArrowLine(path, center, north);
        return path;
    }

    public static Shape makeLine(Point2D.Double center, Point2D.Double north) {
        Point2D.Double south = new Point2D.Double(center.x - (north.x - center.x), center.y - (north.y - center.y));
        return new Line2D.Double(north, south);
    }

    public static Shape makeArrow(Point2D.Double center, Point2D.Double north) {
        GeneralPath path = new GeneralPath();
        ShapeUtil.addArrowLine(path, center, north);
        return path;
    }

    public static void addArrowLine(GeneralPath path, Point2D.Double startPos, Point2D.Double endPos) {
        path.append(new Line2D.Double(startPos, endPos), false);
        double x = startPos.x - endPos.x;
        double y = startPos.y - endPos.y;
        boolean flip = x < 0.0;
        double angle = Math.atan(y / x);
        path.append(ShapeUtil.makeArrowHead(endPos, 8.0, angle, flip), false);
    }

    public static Polygon2D makeArrowHead(Point2D.Double pos, double length, double angle, boolean flip) {
        AffineTransform at = new AffineTransform();
        at.setToRotation(angle, pos.x, pos.y);
        double l1 = length;
        double l2 = length * 1.3;
        double w = length * 0.4;
        if (flip) {
            l1 = -l1;
            l2 = -l2;
        }
        Polygon2D.Double polygon = new Polygon2D.Double();
        ((Polygon2D)polygon).moveTo(pos.x, pos.y);
        ((Polygon2D)polygon).lineTo(pos.x + l2, pos.y + w);
        ((Polygon2D)polygon).lineTo(pos.x + l1, pos.y);
        ((Polygon2D)polygon).lineTo(pos.x + l2, pos.y - w);
        polygon.closePath();
        ((Polygon2D)polygon).transform(at);
        return polygon;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("GraphicsImageDisplay");
        DivaGraphicsImageDisplay imageDisplay = new DivaGraphicsImageDisplay();
        imageDisplay.clear();
        DivaImageGraphics g = new DivaImageGraphics(imageDisplay);
        SelectionInteractor si = g.getSelectionInteractor();
        Point2D.Double center = new Point2D.Double(50.0, 50.0);
        Point2D.Double north = new Point2D.Double(65.0, 20.0);
        Point2D.Double east = new Point2D.Double(35.0, 40.0);
        Shape shape = ShapeUtil.makeCompass(center, north, east);
        Color fill = Color.blue;
        Color outline = Color.yellow;
        float lineWidth = 1.0f;
        g.add(g.makeFigure(shape, fill, outline, lineWidth, si));
        frame.getContentPane().add((Component)imageDisplay, "Center");
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(new BasicWindowMonitor());
    }
}

