/*
 * Decompiled with CFR 0.152.
 */
package alma.Control;

import alma.Control.AllLO2ParametersHelper;
import alma.Control.LO2ParametersHelper;
import alma.Control.SkyFreqSidebandHelper;
import alma.Control.TuningParameters;
import alma.ReceiverBandMod.ReceiverBand;
import alma.ReceiverBandMod.ReceiverBandHelper;
import java.io.IOException;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public abstract class TuningParametersHelper {
    private static volatile TypeCode _type;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TypeCode type() {
        if (_type != null) return _type;
        Class<TuningParametersHelper> clazz = TuningParametersHelper.class;
        synchronized (TuningParametersHelper.class) {
            if (_type != null) return _type;
            _type = ORB.init().create_struct_tc(TuningParametersHelper.id(), "TuningParameters", new StructMember[]{new StructMember("receiverBand", TuningParametersHelper.receiverBandFactory(), null), new StructMember("LSFrequency", TuningParametersHelper.LSFrequencyFactory(), null), new StructMember("FLOOGFrequency", TuningParametersHelper.FLOOGFrequencyFactory(), null), new StructMember("tuneHigh", TuningParametersHelper.tuneHighFactory(), null), new StructMember("coldMultiplier", TuningParametersHelper.coldMultiplierFactory(), null), new StructMember("band0band1selectUSB", TuningParametersHelper.band0band1selectUSBFactory(), null), new StructMember("band2band3selectUSB", TuningParametersHelper.band2band3selectUSBFactory(), null), new StructMember("LO2", TuningParametersHelper.LO2Factory(), null), new StructMember("weightedError", TuningParametersHelper.weightedErrorFactory(), null), new StructMember("score", TuningParametersHelper.scoreFactory(), null), new StructMember("index", TuningParametersHelper.indexFactory(), null)});
            // ** MonitorExit[var0] (shouldn't be in output)
            return _type;
        }
    }

    private static TypeCode coldMultiplierFactory() {
        return ORB.init().get_primitive_tc(TCKind.from_int((int)2));
    }

    private static TypeCode scoreFactory() {
        return ORB.init().get_primitive_tc(TCKind.from_int((int)7));
    }

    private static TypeCode receiverBandFactory() {
        return ORB.init().create_enum_tc(ReceiverBandHelper.id(), "ReceiverBand", new String[]{"ALMA_RB_01", "ALMA_RB_02", "ALMA_RB_03", "ALMA_RB_04", "ALMA_RB_05", "ALMA_RB_06", "ALMA_RB_07", "ALMA_RB_08", "ALMA_RB_09", "ALMA_RB_10", "ALMA_RB_ALL", "ALMA_HOLOGRAPHY_RECEIVER", "BURE_01", "BURE_02", "BURE_03", "BURE_04", "EVLA_4", "EVLA_P", "EVLA_L", "EVLA_C", "EVLA_S", "EVLA_X", "EVLA_Ku", "EVLA_K", "EVLA_Ka", "EVLA_Q", "UNSPECIFIED"});
    }

    private static TypeCode tuneHighFactory() {
        return ORB.init().get_primitive_tc(TCKind.from_int((int)8));
    }

    private static TypeCode band2band3selectUSBFactory() {
        return ORB.init().get_primitive_tc(TCKind.from_int((int)8));
    }

    private static TypeCode weightedErrorFactory() {
        return ORB.init().get_primitive_tc(TCKind.from_int((int)7));
    }

    private static TypeCode indexFactory() {
        return ORB.init().get_primitive_tc(TCKind.from_int((int)2));
    }

    private static TypeCode band0band1selectUSBFactory() {
        return ORB.init().get_primitive_tc(TCKind.from_int((int)8));
    }

    private static TypeCode LO2Factory() {
        return ORB.init().create_alias_tc(AllLO2ParametersHelper.id(), "AllLO2Parameters", ORB.init().create_array_tc(4, ORB.init().create_struct_tc(LO2ParametersHelper.id(), "LO2Parameters", new StructMember[]{new StructMember("DYTOFrequency", ORB.init().get_primitive_tc(TCKind.from_int((int)7)), null), new StructMember("FTSFrequency", ORB.init().get_primitive_tc(TCKind.from_int((int)7)), null), new StructMember("tuneHigh", ORB.init().get_primitive_tc(TCKind.from_int((int)8)), null), new StructMember("skyFreqSideband", ORB.init().create_enum_tc(SkyFreqSidebandHelper.id(), "SkyFreqSideband", new String[]{"USB", "LSB", "DSB"}), null), new StructMember("use12GHzFilter", ORB.init().get_primitive_tc(TCKind.from_int((int)8)), null), new StructMember("isUsed", ORB.init().get_primitive_tc(TCKind.from_int((int)8)), null)})));
    }

    private static TypeCode LSFrequencyFactory() {
        return ORB.init().get_primitive_tc(TCKind.from_int((int)7));
    }

    private static TypeCode FLOOGFrequencyFactory() {
        return ORB.init().get_primitive_tc(TCKind.from_int((int)7));
    }

    public static void insert(Any any, TuningParameters s) {
        any.type(TuningParametersHelper.type());
        TuningParametersHelper.write(any.create_output_stream(), s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TuningParameters extract(Any any) {
        InputStream in = any.create_input_stream();
        try {
            TuningParameters tuningParameters = TuningParametersHelper.read(in);
            return tuningParameters;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected exception " + e.toString());
            }
        }
    }

    public static String id() {
        return "IDL:alma/Control/TuningParameters:1.0";
    }

    public static TuningParameters read(InputStream in) {
        TuningParameters result = new TuningParameters();
        result.receiverBand = ReceiverBandHelper.read((InputStream)in);
        result.LSFrequency = in.read_double();
        result.FLOOGFrequency = in.read_double();
        result.tuneHigh = in.read_boolean();
        result.coldMultiplier = in.read_short();
        result.band0band1selectUSB = in.read_boolean();
        result.band2band3selectUSB = in.read_boolean();
        result.LO2 = AllLO2ParametersHelper.read(in);
        result.weightedError = in.read_double();
        result.score = in.read_double();
        result.index = in.read_short();
        return result;
    }

    public static void write(OutputStream out, TuningParameters s) {
        ReceiverBandHelper.write((OutputStream)out, (ReceiverBand)s.receiverBand);
        out.write_double(s.LSFrequency);
        out.write_double(s.FLOOGFrequency);
        out.write_boolean(s.tuneHigh);
        out.write_short(s.coldMultiplier);
        out.write_boolean(s.band0band1selectUSB);
        out.write_boolean(s.band2band3selectUSB);
        AllLO2ParametersHelper.write(out, s.LO2);
        out.write_double(s.weightedError);
        out.write_double(s.score);
        out.write_short(s.index);
    }
}

