/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.gui.BasicTableLoadDialog;
import uk.ac.starlink.vo.DalQuery;
import uk.ac.starlink.vo.DoubleValueField;
import uk.ac.starlink.vo.KeywordServiceQueryFactory;
import uk.ac.starlink.vo.RegCapabilityInterface;
import uk.ac.starlink.vo.RegResource;
import uk.ac.starlink.vo.RegistryServiceTableLoadDialog;
import uk.ac.starlink.vo.SkyPositionEntry;

public class SiapTableLoadDialog
extends RegistryServiceTableLoadDialog {
    private final SkyPositionEntry skyEntry_ = new SkyPositionEntry("J2000");
    private final DoubleValueField raField_ = this.skyEntry_.getRaDegreesField();
    private final DoubleValueField decField_ = this.skyEntry_.getDecDegreesField();
    private final DoubleValueField sizeField_ = DoubleValueField.makeSizeDegreesField(SIZE_INFO);
    private static final ValueInfo SIZE_INFO = new DefaultValueInfo("Angular Size", Double.class, "Angular size of the search region in RA and Dec");

    public SiapTableLoadDialog() {
        super("SIAP Query", "Get results of a Simple Image Access Protocol query", new KeywordServiceQueryFactory("ivo://ivoa.net/std/SIA"), false);
        this.skyEntry_.addField(this.sizeField_);
        this.skyEntry_.addActionListener(this.getOkAction());
        this.getControlBox().add(this.skyEntry_);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.skyEntry_.setEnabled(enabled);
    }

    public BasicTableLoadDialog.TableSupplier getTableSupplier() {
        RegResource[] resources = this.getRegistryPanel().getSelectedResources();
        RegCapabilityInterface[] capabilities = this.getRegistryPanel().getSelectedCapabilities();
        if (resources.length != 1 || capabilities.length < 1) {
            throw new IllegalStateException("No SIAP service selected");
        }
        RegResource resource = resources[0];
        RegCapabilityInterface capability = capabilities[0];
        double ra = this.raField_.getValue();
        double dec = this.decField_.getValue();
        double size = this.sizeField_.getValue();
        final DalQuery query = new DalQuery(resource, capability, ra, dec, size);
        final ArrayList<DescribedValue> metadata = new ArrayList<DescribedValue>();
        metadata.addAll(Arrays.asList(this.raField_.getDescribedValue(), this.decField_.getDescribedValue(), this.sizeField_.getDescribedValue()));
        return new BasicTableLoadDialog.TableSupplier(){

            public StarTable getTable(StarTableFactory factory, String format) throws IOException {
                StarTable st = query.execute(factory);
                st.getParameters().addAll(metadata);
                return st;
            }

            public String getTableID() {
                return query.toString();
            }
        };
    }

    public RegCapabilityInterface[] getCapabilities(RegResource resource) {
        RegCapabilityInterface[] caps = super.getCapabilities(resource);
        ArrayList<RegCapabilityInterface> siapcapList = new ArrayList<RegCapabilityInterface>();
        for (int i = 0; i < caps.length; ++i) {
            if (!"ivo://ivoa.net/std/SIA".equals(caps[i].getStandardId())) continue;
            siapcapList.add(caps[i]);
        }
        return siapcapList.toArray(new RegCapabilityInterface[0]);
    }
}

