/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ORB;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.giop.BiDirPolicy;
import org.jacorb.orb.util.CorbaLoc;
import org.jacorb.poa.AOM;
import org.jacorb.poa.AOMListener;
import org.jacorb.poa.EventListener;
import org.jacorb.poa.EventMulticaster;
import org.jacorb.poa.GOA;
import org.jacorb.poa.POAListener;
import org.jacorb.poa.POAManager;
import org.jacorb.poa.POAMonitor;
import org.jacorb.poa.POAMonitorLightImpl;
import org.jacorb.poa.RPPoolManagerListener;
import org.jacorb.poa.RequestController;
import org.jacorb.poa.RequestQueueListener;
import org.jacorb.poa.except.ApplicationError;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.poa.except.ParentIsHolding;
import org.jacorb.poa.except.ResourceLimitReachedException;
import org.jacorb.poa.policy.IdAssignmentPolicy;
import org.jacorb.poa.policy.IdUniquenessPolicy;
import org.jacorb.poa.policy.ImplicitActivationPolicy;
import org.jacorb.poa.policy.LifespanPolicy;
import org.jacorb.poa.policy.RequestProcessingPolicy;
import org.jacorb.poa.policy.ServantRetentionPolicy;
import org.jacorb.poa.policy.ThreadPolicy;
import org.jacorb.poa.util.ByteArrayKey;
import org.jacorb.poa.util.IdUtil;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.ssl.SSLPolicy;
import org.jacorb.ssl.SSLPolicyValue;
import org.omg.BiDirPolicy.BidirectionalPolicy;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.PortableServer.AdapterActivator;
import org.omg.PortableServer.CurrentPackage.NoContext;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POAManagerFactory;
import org.omg.PortableServer.POAManagerPackage.State;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.AdapterNonExistent;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.NoServant;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongAdapter;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantActivator;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantManager;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.omg.PortableServer.ThreadPolicyValue;
import org.omg.PortableServer._POALocalBase;
import org.slf4j.Logger;

public class POA
extends _POALocalBase
implements Configurable {
    private final ORB orb;
    private Configuration configuration = null;
    private Logger logger = null;
    private byte[] implName = null;
    private final String logPrefix;
    private POAListener poaListener;
    private POAMonitor monitor;
    private final POAManager poaManager;
    private final POA parent;
    private final String name;
    private String qualifiedName;
    private final Hashtable<String, POA> childs = new Hashtable();
    Servant defaultServant;
    ServantManager servantManager;
    private AdapterActivator adapterActivator;
    private AOM aom;
    private RequestController requestController;
    private byte[] poaId;
    private byte[] watermark;
    private long objectIdCount;
    protected org.omg.PortableServer.ThreadPolicy threadPolicy;
    protected org.omg.PortableServer.LifespanPolicy lifespanPolicy;
    protected org.omg.PortableServer.IdUniquenessPolicy idUniquenessPolicy;
    protected org.omg.PortableServer.IdAssignmentPolicy idAssignmentPolicy;
    protected org.omg.PortableServer.ServantRetentionPolicy servantRetentionPolicy;
    protected org.omg.PortableServer.RequestProcessingPolicy requestProcessingPolicy;
    protected org.omg.PortableServer.ImplicitActivationPolicy implicitActivationPolicy;
    protected BidirectionalPolicy bidirectionalPolicy;
    protected SSLPolicy sslPolicy;
    private final Map all_policies;
    private final Hashtable createdReferences;
    private boolean etherealize;
    private int shutdownState = 0;
    private final java.lang.Object poaCreationLog = new java.lang.Object();
    private final java.lang.Object poaDestructionLog = new java.lang.Object();
    private final java.lang.Object unknownAdapterLog = new java.lang.Object();
    private boolean unknownAdapterCalled;
    private boolean configured = false;

    POA(ORB _orb, String _name, POA _parent, POAManager _poaManager, Policy[] policies) {
        BiDirPolicy bdp;
        this.orb = _orb;
        this.name = _name;
        this.parent = _parent;
        this.poaManager = _poaManager;
        this.logPrefix = "POA " + this.name;
        this.all_policies = new HashMap();
        this.createdReferences = new Hashtable();
        if (policies != null) {
            block11: for (int i = 0; i < policies.length; ++i) {
                this.all_policies.put(policies[i].policy_type(), policies[i]);
                switch (policies[i].policy_type()) {
                    case 16: {
                        this.threadPolicy = (org.omg.PortableServer.ThreadPolicy)policies[i];
                        continue block11;
                    }
                    case 17: {
                        this.lifespanPolicy = (org.omg.PortableServer.LifespanPolicy)policies[i];
                        continue block11;
                    }
                    case 18: {
                        this.idUniquenessPolicy = (org.omg.PortableServer.IdUniquenessPolicy)policies[i];
                        continue block11;
                    }
                    case 19: {
                        this.idAssignmentPolicy = (org.omg.PortableServer.IdAssignmentPolicy)policies[i];
                        continue block11;
                    }
                    case 21: {
                        this.servantRetentionPolicy = (org.omg.PortableServer.ServantRetentionPolicy)policies[i];
                        continue block11;
                    }
                    case 22: {
                        this.requestProcessingPolicy = (org.omg.PortableServer.RequestProcessingPolicy)policies[i];
                        continue block11;
                    }
                    case 20: {
                        this.implicitActivationPolicy = (org.omg.PortableServer.ImplicitActivationPolicy)policies[i];
                        continue block11;
                    }
                    case 37: {
                        this.bidirectionalPolicy = (BidirectionalPolicy)policies[i];
                        continue block11;
                    }
                    case 101: {
                        this.sslPolicy = (SSLPolicy)policies[i];
                    }
                }
            }
        }
        if (this.bidirectionalPolicy != null && (bdp = (BiDirPolicy)this.bidirectionalPolicy).useBiDirGIOP()) {
            _orb.turnOnBiDirGIOP();
        }
    }

    @Override
    public void configure(Configuration myConfiguration) throws ConfigurationException {
        this.configuration = myConfiguration;
        this.logger = this.configuration.getLogger("org.jacorb.poa");
        String tmp = this.configuration.getAttribute("jacorb.implname", "");
        if (tmp.length() > 0) {
            this.implName = tmp.getBytes();
        }
        this.watermark = this.generateWatermark();
        this.aom = this.isRetain() ? new AOM(this.isUniqueId(), this.logger) : null;
        this.requestController = new RequestController(this, this.orb, this.aom, this.orb.newRPPoolManager(this.isSingleThreadModel()));
        this.requestController.configure(this.configuration);
        this.poaManager.registerPOA(this);
        this.monitor = new POAMonitorLightImpl();
        this.monitor.init(this, this.aom, this.requestController.getRequestQueue(), this.requestController.getPoolManager(), "POA " + this.name);
        this.monitor.openMonitor();
        if (this.poaListener != null) {
            this.poaListener.poaCreated(this);
        }
        this.monitor.configure(this.configuration);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("POA " + this.name + " ready");
        }
        this.configured = true;
    }

    public void _addPOAEventListener(EventListener listener) {
        this.checkIsConfigured();
        if (listener instanceof POAListener) {
            this.addPOAListener((POAListener)listener);
        }
        if (listener instanceof AOMListener && this.aom != null) {
            this.aom.addAOMListener((AOMListener)listener);
        }
        if (listener instanceof RequestQueueListener) {
            this.requestController.getRequestQueue().addRequestQueueListener((RequestQueueListener)listener);
        }
        if (listener instanceof RPPoolManagerListener) {
            this.requestController.getPoolManager().addRPPoolManagerListener((RPPoolManagerListener)listener);
        }
    }

    public Servant _incarnateServant(byte[] oid, ServantActivator sa) throws ForwardRequest {
        return this.aom.incarnate(new ByteArrayKey(oid), sa, (org.omg.PortableServer.POA)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public POA _getChildPOA(String adapter_name) throws ParentIsHolding {
        this.checkIsConfigured();
        this.checkDestructionApparent();
        POA child = this.childs.get(adapter_name);
        if (child == null || child.isDestructionApparent()) {
            if (this.adapterActivator == null) {
                if (this.isHolding()) {
                    throw new ParentIsHolding();
                }
                throw new OBJECT_NOT_EXIST("no adapter activator exists for " + adapter_name, 1330446338, CompletionStatus.COMPLETED_NO);
            }
            if (this.isDiscarding()) {
                throw new TRANSIENT("a parent poa is in discarding state", 1330446337, CompletionStatus.COMPLETED_NO);
            }
            if (this.isInactive()) {
                throw new OBJ_ADAPTER("a parent poa is in inactive state", 1330446337, CompletionStatus.COMPLETED_NO);
            }
            boolean successful = false;
            if (this.isSingleThreadModel()) {
                java.lang.Object object = this.unknownAdapterLog;
                synchronized (object) {
                    while (this.unknownAdapterCalled) {
                        try {
                            this.unknownAdapterLog.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.unknownAdapterCalled = true;
                    try {
                        successful = this.the_activator().unknown_adapter((org.omg.PortableServer.POA)this, POAUtil.unmaskStr(adapter_name));
                    }
                    finally {
                        this.unknownAdapterCalled = false;
                        this.unknownAdapterLog.notifyAll();
                    }
                }
            }
            successful = this.the_activator().unknown_adapter((org.omg.PortableServer.POA)this, POAUtil.unmaskStr(adapter_name));
            if (successful) {
                child = this.childs.get(adapter_name);
                if (child == null) {
                    throw new POAInternalError("error: unknown_adapter returns true, but the child poa doesn't extist");
                }
            } else {
                throw new OBJECT_NOT_EXIST("poa activation is failed", 1330446338, CompletionStatus.COMPLETED_NO);
            }
        }
        return child;
    }

    public String _getQualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = this.parent == null ? "" : (this.parent.the_parent() == null ? this.name : this.parent._getQualifiedName() + '/' + this.name);
        }
        return this.qualifiedName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _invoke(ServerRequest request) throws WrongAdapter {
        this.checkIsConfigured();
        java.lang.Object object = this.poaDestructionLog;
        synchronized (object) {
            this.checkDestructionApparent();
            if (request.remainingPOAName() == null && this.isSystemId() && !this.previouslyGeneratedObjectId(request.objectId())) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn(this.logPrefix + " rid: " + request.requestId() + " opname: " + request.operation() + " _invoke: object id not previously generated!");
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(this.logPrefix + " ObjectId : " + CorbaLoc.parseKey(request.objectId()) + " to POA watermark : " + CorbaLoc.parseKey(this.watermark) + " mismatch.");
                    }
                }
                throw new WrongAdapter();
            }
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.logPrefix + " rid: " + request.requestId() + " opname: " + request.operation() + " _invoke: queuing request");
                }
                this.requestController.queueRequest(request);
            }
            catch (ResourceLimitReachedException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Caught " + e + " when queueing " + request.operation());
                }
                throw new TRANSIENT("resource limit reached", 1330446337, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    public static POA _POA_init(ORB orb) {
        POAManager poaMgr = new POAManager(orb);
        Policy[] policies = null;
        policies = new Policy[]{new ImplicitActivationPolicy(ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION)};
        GOA rootPOA = new GOA(orb, "RootPOA", null, poaMgr, policies);
        return rootPOA;
    }

    public void _removePOAEventListener(EventListener listener) {
        if (listener instanceof POAListener) {
            this.removePOAListener((POAListener)listener);
        }
        if (listener instanceof AOMListener && this.aom != null) {
            this.aom.removeAOMListener((AOMListener)listener);
        }
        if (listener instanceof RequestQueueListener) {
            this.requestController.getRequestQueue().removeRequestQueueListener((RequestQueueListener)listener);
        }
        if (listener instanceof RPPoolManagerListener) {
            this.requestController.getPoolManager().removeRPPoolManagerListener((RPPoolManagerListener)listener);
        }
    }

    public byte[] activate_object(Servant servant) throws ServantAlreadyActive, WrongPolicy {
        this.checkIsConfigured();
        this.checkDestructionApparent();
        if (!this.isRetain() || !this.isSystemId()) {
            throw new WrongPolicy();
        }
        byte[] objectId = this.generateObjectId();
        try {
            this.aom.add(objectId, servant);
            this.orb.set_delegate(servant);
        }
        catch (ObjectAlreadyActive e) {
            throw new POAInternalError("error: object already active (activate_object)");
        }
        return objectId;
    }

    public void activate_object_with_id(byte[] oid, Servant servant) throws ServantAlreadyActive, ObjectAlreadyActive, WrongPolicy {
        this.checkIsConfigured();
        this.checkDestructionApparent();
        if (oid == null) {
            throw new BAD_PARAM("Cannot activate_object_with_id with null ID.", 1330446350, CompletionStatus.COMPLETED_NO);
        }
        if (!this.isRetain()) {
            throw new WrongPolicy();
        }
        if (this.isSystemId() && !this.previouslyGeneratedObjectId(oid)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(this.logPrefix + "oid: " + POAUtil.convert(oid) + " - activate_object_with_id: oid not previously generated!");
            }
            throw new BAD_PARAM(1330446350, CompletionStatus.COMPLETED_NO);
        }
        this.aom.add(oid, servant);
        this.orb.set_delegate(servant);
    }

    protected synchronized void addPOAListener(POAListener listener) {
        this.poaListener = EventMulticaster.add(this.poaListener, listener);
    }

    protected void changeToActive() {
        if (this.poaListener != null) {
            this.poaListener.poaStateChanged(this, 0);
        }
        this.monitor.changeState("changed to active...");
        this.requestController.resetPreviousCompletionCall();
        this.requestController.continueToWork();
        this.monitor.changeState("active");
    }

    protected void changeToDiscarding() {
        if (this.poaListener != null) {
            this.poaListener.poaStateChanged(this, 2);
        }
        this.monitor.changeState("changed to discarding ...");
        this.requestController.resetPreviousCompletionCall();
        this.requestController.continueToWork();
        this.requestController.waitForCompletion();
        this.monitor.changeState("discarding");
    }

    protected void changeToHolding() {
        if (this.poaListener != null) {
            this.poaListener.poaStateChanged(this, 1);
        }
        this.monitor.changeState("changed to holding ...");
        this.requestController.resetPreviousCompletionCall();
        this.requestController.waitForCompletion();
        this.monitor.changeState("holding");
    }

    protected void changeToInactive(boolean etherealize_objects) {
        if (this.poaListener != null) {
            this.poaListener.poaStateChanged(this, 3);
        }
        this.monitor.changeState("changed to inactive ...");
        this.requestController.resetPreviousCompletionCall();
        this.requestController.continueToWork();
        this.requestController.waitForCompletion();
        if (this.etherealize && this.isRetain() && this.useServantManager()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.logPrefix + "etherialize all servants ...");
            }
            this.aom.removeAll((ServantActivator)this.servantManager, this, true);
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.logPrefix + "etherialize all servants ...");
            }
            if (this.monitor != null) {
                this.monitor.changeState("inactive (etherialization completed)");
            }
        } else if (this.monitor != null) {
            this.monitor.changeState("inactive (no etherialization)");
        }
    }

    public org.omg.PortableServer.IdAssignmentPolicy create_id_assignment_policy(IdAssignmentPolicyValue value) {
        this.checkDestructionApparent();
        return new IdAssignmentPolicy(value);
    }

    public org.omg.PortableServer.IdUniquenessPolicy create_id_uniqueness_policy(IdUniquenessPolicyValue value) {
        this.checkDestructionApparent();
        return new IdUniquenessPolicy(value);
    }

    public org.omg.PortableServer.ImplicitActivationPolicy create_implicit_activation_policy(ImplicitActivationPolicyValue value) {
        this.checkDestructionApparent();
        return new ImplicitActivationPolicy(value);
    }

    public org.omg.PortableServer.LifespanPolicy create_lifespan_policy(LifespanPolicyValue value) {
        this.checkDestructionApparent();
        return new LifespanPolicy(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.omg.PortableServer.POA create_POA(String adapter_name, org.omg.PortableServer.POAManager a_POAManager, Policy[] policies) throws AdapterAlreadyExists, InvalidPolicy {
        POA child;
        this.checkIsConfigured();
        this.checkDestructionApparent();
        if (adapter_name == null) {
            throw new BAD_PARAM("Cannot pass null as an adapter name");
        }
        String poa_name = POAUtil.maskStr(adapter_name);
        if (a_POAManager != null && !(a_POAManager instanceof POAManager)) {
            throw new ApplicationError("error: the POAManager is incompatible with type \"jacorb.poa.POAManager\"!");
        }
        Policy[] policyList = null;
        if (policies != null) {
            short index = this.verifyPolicyList(policies);
            if (index != -1) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Policy list invalid at index " + index);
                }
                throw new InvalidPolicy(index);
            }
            policyList = new Policy[policies.length];
            for (int i = 0; i < policies.length; ++i) {
                policyList[i] = policies[i].copy();
            }
        }
        java.lang.Object object = this.poaCreationLog;
        synchronized (object) {
            child = this.childs.get(poa_name);
            if (child != null && !child.isDestructionApparent()) {
                throw new AdapterAlreadyExists();
            }
            if (child != null) {
                POA aChild;
                while ((aChild = this.childs.get(poa_name)) != null) {
                    try {
                        this.poaCreationLog.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (child == aChild) continue;
                    throw new AdapterAlreadyExists();
                }
            }
            if (this.isShutdownInProgress()) {
                throw new BAD_INV_ORDER(1330446353, CompletionStatus.COMPLETED_NO);
            }
            POAManager aPOAManager = a_POAManager == null ? new POAManager(this.orb) : (POAManager)a_POAManager;
            child = new GOA(this.orb, poa_name, this, aPOAManager, policyList);
            try {
                child.configure(this.configuration);
            }
            catch (ConfigurationException e) {
                throw new INTERNAL(e.toString());
            }
            try {
                if (this.poaListener != null) {
                    this.poaListener.poaCreated(child);
                }
            }
            catch (INTERNAL e) {
                aPOAManager.poaCreationFailed = true;
                throw e;
            }
            this.childs.put(poa_name, child);
        }
        return child;
    }

    public Object create_reference(String intf_rep_id) throws WrongPolicy {
        this.checkIsConfigured();
        this.checkDestructionApparent();
        if (!this.isSystemId()) {
            throw new WrongPolicy();
        }
        return this.getReference(this.generateObjectId(), intf_rep_id, false);
    }

    public Object create_reference_with_id(byte[] oid, String intf_rep_id) throws WrongPolicy {
        this.checkIsConfigured();
        this.checkDestructionApparent();
        if (this.isSystemId() && !this.previouslyGeneratedObjectId(oid)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(this.logPrefix + "oid: " + POAUtil.convert(oid) + "create_reference_with_id : object key not previously generated!");
            }
            throw new BAD_PARAM(1330446350, CompletionStatus.COMPLETED_NO);
        }
        return this.getReference(oid, intf_rep_id, false);
    }

    public org.omg.PortableServer.RequestProcessingPolicy create_request_processing_policy(RequestProcessingPolicyValue value) {
        this.checkDestructionApparent();
        return new RequestProcessingPolicy(value);
    }

    public org.omg.PortableServer.ServantRetentionPolicy create_servant_retention_policy(ServantRetentionPolicyValue value) {
        this.checkDestructionApparent();
        return new ServantRetentionPolicy(value);
    }

    public org.omg.PortableServer.ThreadPolicy create_thread_policy(ThreadPolicyValue value) {
        this.checkDestructionApparent();
        return new ThreadPolicy(value);
    }

    public synchronized void deactivate_object(byte[] oid) throws ObjectNotActive, WrongPolicy {
        this.checkIsConfigured();
        if (!this.isRetain()) {
            throw new WrongPolicy();
        }
        ((GOA)this).clearGroupRegistration(oid);
        ByteArrayKey oidbak = new ByteArrayKey(oid);
        this.aom.remove(oidbak, this.requestController, this.useServantManager() ? (ServantActivator)this.servantManager : null, this, false);
        this.createdReferences.remove(oidbak);
    }

    public void destroy(boolean etherealize_objects, boolean wait_for_completion) {
        this.checkIsConfigured();
        if (wait_for_completion && this.isInInvocationContext()) {
            throw new BAD_INV_ORDER(1330446339, CompletionStatus.COMPLETED_NO);
        }
        this.makeShutdownInProgress(etherealize_objects);
        Enumeration en = ((Hashtable)this.childs.clone()).elements();
        while (en.hasMoreElements()) {
            POA child = (POA)en.nextElement();
            child.destroy(this.etherealize, wait_for_completion);
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                POA.this.requestController.waitForShutdown();
                POA.this.makeDestructionApparent();
                POA.this.makeDestructionComplete();
            }
        };
        thread.setName("POADestructor");
        thread.start();
        if (wait_for_completion) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private byte[] extractWatermark(byte[] id) {
        if (id.length < this.watermark.length) {
            return new byte[0];
        }
        return IdUtil.extract(id, id.length - this.watermark.length, this.watermark.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.omg.PortableServer.POA find_POA(String adapter_name, boolean activate_it) throws AdapterNonExistent {
        this.checkDestructionApparent();
        String poa_name = POAUtil.maskStr(adapter_name);
        POA child = this.childs.get(poa_name);
        if (child == null || child.isDestructionApparent()) {
            boolean successful = false;
            if (activate_it && this.the_activator() != null) {
                if (this.isSingleThreadModel()) {
                    java.lang.Object object = this.unknownAdapterLog;
                    synchronized (object) {
                        while (this.unknownAdapterCalled) {
                            try {
                                this.unknownAdapterLog.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        this.unknownAdapterCalled = true;
                        try {
                            successful = this.the_activator().unknown_adapter((org.omg.PortableServer.POA)this, adapter_name);
                        }
                        finally {
                            this.unknownAdapterCalled = false;
                            this.unknownAdapterLog.notifyAll();
                        }
                    }
                }
                successful = this.the_activator().unknown_adapter((org.omg.PortableServer.POA)this, adapter_name);
            }
            if (successful) {
                child = this.childs.get(poa_name);
                if (child == null) {
                    throw new POAInternalError("error: unknown_adapter returns true, but the child poa does'n extist");
                }
            } else {
                throw new AdapterNonExistent();
            }
        }
        return child;
    }

    synchronized byte[] generateObjectId() {
        if (this.isPersistent()) {
            return IdUtil.concat(IdUtil.createId(), this.watermark);
        }
        return IdUtil.concat(IdUtil.toId(this.objectIdCount++), this.watermark);
    }

    private byte[] generateWatermark() {
        if (this.watermark == null) {
            this.watermark = this.isPersistent() ? IdUtil.toId(new String(this.getPOAId()).hashCode()) : IdUtil.createId();
        }
        return this.watermark;
    }

    public Servant get_servant() throws NoServant, WrongPolicy {
        this.checkIsConfigured();
        this.checkDestructionApparent();
        if (!this.isUseDefaultServant()) {
            throw new WrongPolicy();
        }
        if (this.defaultServant == null) {
            throw new NoServant();
        }
        return this.defaultServant;
    }

    public ServantManager get_servant_manager() throws WrongPolicy {
        this.checkIsConfigured();
        this.checkDestructionApparent();
        if (!this.isUseServantManager()) {
            throw new WrongPolicy();
        }
        return this.servantManager;
    }

    private void checkIsConfigured() {
        if (!this.configured) {
            throw new IllegalStateException("POA: not configured!");
        }
    }

    protected POAMonitor getMonitor() {
        return this.monitor;
    }

    protected ORB getORB() {
        return this.orb;
    }

    public byte[] getPOAId() {
        if (this.poaId == null) {
            byte[] impl_name = this.getImplName();
            int in_length = impl_name.length;
            byte[] poa_name = this._getQualifiedName().getBytes();
            int pn_length = poa_name.length;
            int offset = 0;
            if (pn_length == 0) {
                this.poaId = new byte[in_length];
                System.arraycopy(impl_name, 0, this.poaId, 0, in_length);
            } else {
                this.poaId = new byte[in_length + pn_length + 1];
                System.arraycopy(impl_name, 0, this.poaId, 0, in_length);
                this.poaId[offset += in_length] = 47;
                System.arraycopy(poa_name, 0, this.poaId, ++offset, pn_length);
            }
        }
        return this.poaId;
    }

    private byte[] getImplName() {
        byte[] impl;
        if (!this.isPersistent() || this.implName == null) {
            impl = this.orb.getServerId();
            if (this.logger.isInfoEnabled()) {
                if (this.isPersistent()) {
                    this.logger.info("Impl name not set; using server ID: " + new String(impl));
                } else {
                    this.logger.info("Using server ID (" + new String(impl) + ") for transient POA");
                }
            }
        } else {
            impl = this.implName;
        }
        return POAUtil.maskId(impl);
    }

    protected Object getReference(byte[] oid, String intf_rep_id, boolean cache) {
        byte[] object_id = POAUtil.maskId(oid);
        int pid_length = this.getPOAId().length;
        int oid_length = object_id.length;
        byte[] object_key = new byte[pid_length + oid_length + 1];
        int offset = 0;
        System.arraycopy(this.getPOAId(), 0, object_key, offset, pid_length);
        object_key[offset += pid_length] = 47;
        System.arraycopy(object_id, 0, object_key, ++offset, oid_length);
        ByteArrayKey key = new ByteArrayKey(oid);
        Object result = (Object)this.createdReferences.get(key);
        if (result == null) {
            result = this.orb.getReference(this, object_key, intf_rep_id, !this.isPersistent());
            if (cache) {
                this.createdReferences.put(key, result);
            }
            if (this.poaListener != null) {
                this.poaListener.referenceCreated(result);
            }
        }
        return result;
    }

    protected RequestController getRequestController() {
        return this.requestController;
    }

    protected State getState() {
        return this.poaManager.get_state();
    }

    public Object id_to_reference(byte[] oid) throws ObjectNotActive, WrongPolicy {
        this.checkDestructionApparent();
        if (!this.isRetain()) {
            throw new WrongPolicy();
        }
        Servant servant = this.aom.getServant(oid);
        if (servant == null) {
            throw new ObjectNotActive();
        }
        return this.getReference(oid, servant._all_interfaces((org.omg.PortableServer.POA)this, oid)[0], true);
    }

    public Servant id_to_servant(byte[] oid) throws ObjectNotActive, WrongPolicy {
        Servant servant;
        this.checkDestructionApparent();
        if (!this.isRetain() && !this.isUseDefaultServant()) {
            throw new WrongPolicy();
        }
        if (this.isRetain() && (servant = this.aom.getServant(oid)) != null) {
            return servant;
        }
        if (this.useDefaultServant()) {
            return this.defaultServant;
        }
        throw new ObjectNotActive();
    }

    protected boolean isActive() {
        return this.poaManager.get_state().value() == 1;
    }

    protected void checkDestructionApparent() {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("POA destroyed", 1330446340, CompletionStatus.COMPLETED_NO);
        }
    }

    protected static void checkNotLocal(Object obj) throws WrongAdapter {
        if (obj instanceof LocalObject) {
            throw new WrongAdapter("Local object");
        }
    }

    protected boolean isDestructionApparent() {
        return this.shutdownState >= 2;
    }

    public boolean isDestructionComplete() {
        return this.shutdownState >= 3;
    }

    protected boolean isDiscarding() {
        return this.poaManager.get_state().value() == 2;
    }

    protected boolean isHolding() {
        return this.poaManager.get_state().value() == 0;
    }

    protected boolean isImplicitActivation() {
        return this.implicitActivationPolicy != null && this.implicitActivationPolicy.value() == ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION;
    }

    protected boolean isInactive() {
        return this.poaManager.get_state().value() == 3;
    }

    private boolean isInInvocationContext() {
        try {
            if (this.orb.getPOACurrent().getORB() == this.orb) {
                return true;
            }
        }
        catch (NoContext noContext) {
            // empty catch block
        }
        return false;
    }

    private boolean isInInvocationContext(Servant servant) {
        try {
            if (this.orb.getPOACurrent().get_POA() == this && (servant == null || this.orb.getPOACurrent().getServant() == servant)) {
                return true;
            }
        }
        catch (NoContext noContext) {
            // empty catch block
        }
        return false;
    }

    protected boolean isMultipleId() {
        return this.idUniquenessPolicy != null && this.idUniquenessPolicy.value() == IdUniquenessPolicyValue.MULTIPLE_ID;
    }

    public boolean isPersistent() {
        return this.lifespanPolicy != null && this.lifespanPolicy.value() == LifespanPolicyValue.PERSISTENT;
    }

    public boolean isRetain() {
        return this.servantRetentionPolicy == null || this.servantRetentionPolicy.value() == ServantRetentionPolicyValue.RETAIN;
    }

    protected boolean isShutdownInProgress() {
        return this.shutdownState >= 1;
    }

    protected boolean isSingleThreadModel() {
        return this.threadPolicy != null && this.threadPolicy.value() == ThreadPolicyValue.SINGLE_THREAD_MODEL;
    }

    public boolean isSystemId() {
        return this.idAssignmentPolicy == null || this.idAssignmentPolicy.value() == IdAssignmentPolicyValue.SYSTEM_ID;
    }

    protected boolean isUniqueId() {
        return this.idUniquenessPolicy == null || this.idUniquenessPolicy.value() == IdUniquenessPolicyValue.UNIQUE_ID;
    }

    protected boolean isUseDefaultServant() {
        return this.requestProcessingPolicy != null && this.requestProcessingPolicy.value() == RequestProcessingPolicyValue.USE_DEFAULT_SERVANT;
    }

    public boolean isUseServantManager() {
        return this.requestProcessingPolicy != null && this.requestProcessingPolicy.value() == RequestProcessingPolicyValue.USE_SERVANT_MANAGER;
    }

    public boolean isSSLRequired() {
        return this.sslPolicy != null && this.sslPolicy.value() == SSLPolicyValue.SSL_REQUIRED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeDestructionApparent() {
        java.lang.Object object = this.poaDestructionLog;
        synchronized (object) {
            if (this.shutdownState < 2) {
                this.poaManager.unregisterPOA(this);
                this.shutdownState = 2;
                if (this.poaListener != null) {
                    this.poaListener.poaStateChanged(this, 4);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.logPrefix + "destruction is apparent");
                }
                this.monitor.changeState("destruction is apparent ...");
            }
        }
    }

    private void makeDestructionComplete() {
        if (this.shutdownState < 3) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.logPrefix + "clear up the queue ...");
            }
            this.requestController.clearUpQueue((SystemException)((java.lang.Object)new OBJECT_NOT_EXIST("adapter destroyed", 1330446339, CompletionStatus.COMPLETED_NO)));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.logPrefix + "... done");
            }
            if (this.aom != null) {
                this.aom.aomRemoval.end();
            }
            if (this.etherealize && this.isRetain() && this.useServantManager()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.logPrefix + "etherialize all servants ...");
                }
                this.aom.removeAll((ServantActivator)this.servantManager, this, true);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.logPrefix + "... done");
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.logPrefix + "remove all processors from the pool ...");
            }
            this.requestController.clearUpPool();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.logPrefix + "... done");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.logPrefix + "stop the request controller ...");
            }
            this.requestController.end();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.logPrefix + "... done");
            }
            this.shutdownState = 3;
            if (this.parent != null) {
                this.parent.unregisterChild(this.name);
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.logPrefix + " destroyed");
            }
            this.monitor.changeState("destroyed");
            this.createdReferences.clear();
            this.all_policies.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeShutdownInProgress(boolean etherealize_objects) {
        java.lang.Object object = this.poaCreationLog;
        synchronized (object) {
            if (this.shutdownState < 1) {
                this.etherealize = etherealize_objects;
                this.shutdownState = 1;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.logPrefix + "shutdown is in progress");
                }
                this.monitor.changeState("shutdown is in progress ...");
            }
        }
    }

    public boolean previouslyGeneratedObjectId(byte[] oid) {
        return IdUtil.equals(this.watermark, this.extractWatermark(oid));
    }

    public boolean previouslyGeneratedObjectKey(byte[] object_key) {
        return IdUtil.equals(object_key, this.getPOAId(), this.getPOAId().length);
    }

    public byte[] reference_to_id(Object reference) throws WrongAdapter, WrongPolicy {
        byte[] objectId;
        this.checkDestructionApparent();
        POA.checkNotLocal(reference);
        byte[] objectKey = this.orb.mapObjectKey(((Delegate)((ObjectImpl)reference)._get_delegate()).getObjectKey());
        try {
            objectId = POAUtil.extractOID(objectKey);
        }
        catch (POAInternalError e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(this.logPrefix + "Unable to extract OID from objectKey: " + new String(objectKey));
            }
            throw new WrongAdapter();
        }
        if (this.isSystemId() && !this.previouslyGeneratedObjectId(objectId)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(this.logPrefix + "oid: " + POAUtil.convert(objectId) + "reference_to_id: oid not previously generated!");
            }
            throw new WrongAdapter();
        }
        if (!this.isSystemId() && !this._getQualifiedName().equals(POAUtil.extractPOAName(objectKey))) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(this.logPrefix + "reference: " + new String(objectKey) + "reference_to_id: reference not previously generated for this POA!");
            }
            throw new WrongAdapter();
        }
        return objectId;
    }

    public Servant reference_to_servant(Object reference) throws ObjectNotActive, WrongAdapter, WrongPolicy {
        byte[] objectId;
        if (reference == null) {
            throw new BAD_PARAM("reference may not be null");
        }
        this.checkDestructionApparent();
        POA.checkNotLocal(reference);
        if (!this.isRetain() && !this.isUseDefaultServant()) {
            throw new WrongPolicy();
        }
        byte[] objectKey = this.orb.mapObjectKey(((Delegate)((ObjectImpl)reference)._get_delegate()).getObjectKey());
        try {
            objectId = POAUtil.extractOID(objectKey);
        }
        catch (POAInternalError e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(this.logPrefix + "Unable to extract OID from objectKey: " + new String(objectKey));
            }
            throw new WrongAdapter();
        }
        if (this.isSystemId() && !this.previouslyGeneratedObjectId(objectId)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(this.logPrefix + "oid: " + POAUtil.convert(objectId) + "reference_to_servant: oid not previously generated!");
            }
            throw new WrongAdapter();
        }
        if (!this.isSystemId() && !this._getQualifiedName().equals(POAUtil.extractPOAName(objectKey))) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(this.logPrefix + "reference: " + new String(objectKey) + "reference_to_id: reference not previously generated for this POA!");
            }
            throw new WrongAdapter();
        }
        ByteArrayKey oid = new ByteArrayKey(objectId);
        if (this.aom != null && this.aom.isDeactivating(oid) || this.requestController.isDeactivating(oid)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(this.logPrefix + "oid: " + POAUtil.convert(objectId) + "cannot process request, because object is already in the deactivation process");
            }
            throw new OBJECT_NOT_EXIST(1330446340, CompletionStatus.COMPLETED_NO);
        }
        Servant servant = null;
        if (this.isRetain() && (servant = this.aom.getServant(oid)) != null) {
            return servant;
        }
        if (this.useDefaultServant()) {
            return this.defaultServant;
        }
        throw new ObjectNotActive();
    }

    protected synchronized void removePOAListener(POAListener listener) {
        this.poaListener = EventMulticaster.remove(this.poaListener, listener);
    }

    public byte[] servant_to_id(Servant servant) throws ServantNotActive, WrongPolicy {
        this.checkDestructionApparent();
        if (!(this.isUseDefaultServant() || this.isRetain() && this.isUniqueId() || this.isRetain() && this.isImplicitActivation())) {
            throw new WrongPolicy();
        }
        byte[] objectId = null;
        if (this.isRetain()) {
            if (this.isUniqueId() && (objectId = this.aom.getObjectId(servant)) != null) {
                return objectId;
            }
            if (this.isImplicitActivation() && (this.isMultipleId() || !this.aom.contains(servant))) {
                objectId = this.generateObjectId();
                try {
                    this.aom.add(objectId, servant);
                }
                catch (ObjectAlreadyActive e) {
                    throw new POAInternalError("error: object already active (servant_to_id)");
                }
                catch (ServantAlreadyActive e) {
                    objectId = this.aom.getObjectId(servant);
                }
                this.orb.set_delegate(servant);
                return objectId;
            }
        }
        if (this.isUseDefaultServant() && servant == this.defaultServant && this.isInInvocationContext(servant)) {
            try {
                objectId = this.orb.getPOACurrent().get_object_id();
            }
            catch (NoContext e) {
                throw new POAInternalError("error: not in invocation context (servant_to_id)");
            }
            return objectId;
        }
        throw new ServantNotActive();
    }

    public Object servant_to_reference(Servant servant) throws ServantNotActive, WrongPolicy {
        this.checkDestructionApparent();
        boolean isInInvocationContext = this.isInInvocationContext(servant);
        if (!(this.isRetain() && this.isUniqueId() || this.isRetain() && this.isImplicitActivation() || isInInvocationContext)) {
            throw new WrongPolicy();
        }
        byte[] objectId = null;
        if (isInInvocationContext) {
            try {
                objectId = this.orb.getPOACurrent().get_object_id();
            }
            catch (NoContext e) {
                throw new POAInternalError("error: not in invocation context (servant_to_reference)");
            }
            return this.getReference(objectId, servant._all_interfaces((org.omg.PortableServer.POA)this, objectId)[0], true);
        }
        if (this.isRetain()) {
            if (this.isUniqueId() && (objectId = this.aom.getObjectId(servant)) != null) {
                return this.getReference(objectId, servant._all_interfaces((org.omg.PortableServer.POA)this, objectId)[0], true);
            }
            if (this.isImplicitActivation() && (this.isMultipleId() || !this.aom.contains(servant))) {
                objectId = this.generateObjectId();
                try {
                    this.aom.add(objectId, servant);
                }
                catch (ObjectAlreadyActive e) {
                    throw new POAInternalError("error: object already active (servant_to_reference)");
                }
                catch (ServantAlreadyActive e) {
                    objectId = this.aom.getObjectId(servant);
                }
                this.orb.set_delegate(servant);
                return this.getReference(objectId, servant._all_interfaces((org.omg.PortableServer.POA)this, objectId)[0], true);
            }
        }
        throw new ServantNotActive();
    }

    public void set_servant(Servant _defaultServant) throws WrongPolicy {
        this.checkDestructionApparent();
        if (!this.isUseDefaultServant()) {
            throw new WrongPolicy();
        }
        this.defaultServant = _defaultServant;
        if (this.defaultServant != null) {
            this.orb.set_delegate(this.defaultServant);
        }
    }

    public void set_servant_manager(ServantManager servant_manager) throws WrongPolicy {
        this.checkDestructionApparent();
        if (!this.isUseServantManager()) {
            throw new WrongPolicy();
        }
        if (this.servantManager != null) {
            throw new BAD_INV_ORDER();
        }
        if (this.isRetain() && !(servant_manager instanceof ServantActivator)) {
            throw new WrongPolicy();
        }
        if (!this.isRetain() && !(servant_manager instanceof ServantLocator)) {
            throw new WrongPolicy();
        }
        this.servantManager = servant_manager;
    }

    protected void setMonitor(POAMonitor _monitor) {
        this.monitor = _monitor;
    }

    public AdapterActivator the_activator() {
        this.checkDestructionApparent();
        return this.adapterActivator;
    }

    public void the_activator(AdapterActivator adapter_activator) {
        this.checkDestructionApparent();
        this.adapterActivator = adapter_activator;
    }

    public String the_name() {
        this.checkDestructionApparent();
        return POAUtil.unmaskStr(this.name);
    }

    public byte[] id() {
        throw new NO_IMPLEMENT("NYI");
    }

    public org.omg.PortableServer.POA the_parent() {
        this.checkDestructionApparent();
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.omg.PortableServer.POA[] the_children() {
        org.omg.PortableServer.POA[] children;
        this.checkDestructionApparent();
        int i = 0;
        java.lang.Object object = this.poaCreationLog;
        synchronized (object) {
            children = new org.omg.PortableServer.POA[this.childs.size()];
            Enumeration<POA> enumeration = this.childs.elements();
            while (enumeration.hasMoreElements()) {
                children[i] = (org.omg.PortableServer.POA)enumeration.nextElement();
                ++i;
            }
        }
        return children;
    }

    public org.omg.PortableServer.POAManager the_POAManager() {
        this.checkDestructionApparent();
        return this.poaManager;
    }

    public POAManagerFactory the_POAManagerFactory() {
        throw new NO_IMPLEMENT("Not yet implemented", 1330446337, CompletionStatus.COMPLETED_NO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterChild(String name) {
        java.lang.Object object = this.poaCreationLog;
        synchronized (object) {
            this.childs.remove(name);
            this.poaCreationLog.notifyAll();
        }
    }

    public boolean useDefaultServant() {
        return this.isUseDefaultServant() && this.defaultServant != null;
    }

    protected boolean useServantManager() {
        return this.isUseServantManager() && this.servantManager != null;
    }

    private short verifyPolicyList(Policy[] policies) {
        block9: for (short i = 0; i < policies.length; i = (short)((short)(i + 1))) {
            switch (policies[i].policy_type()) {
                case 16: {
                    continue block9;
                }
                case 17: {
                    if (((org.omg.PortableServer.LifespanPolicy)policies[i]).value() != LifespanPolicyValue.PERSISTENT || this.implName != null) continue block9;
                    this.logger.error("Cannot create a persistent poa. The implname property has not been set.");
                    return i;
                }
                case 18: {
                    continue block9;
                }
                case 19: {
                    continue block9;
                }
                case 21: {
                    if (((org.omg.PortableServer.ServantRetentionPolicy)policies[i]).value() != ServantRetentionPolicyValue.NON_RETAIN) continue block9;
                    Policy policy = POAUtil.getPolicy(policies, 22);
                    if (policy == null) {
                        return i;
                    }
                    if (((org.omg.PortableServer.RequestProcessingPolicy)policy).value() == RequestProcessingPolicyValue.USE_DEFAULT_SERVANT || ((org.omg.PortableServer.RequestProcessingPolicy)policy).value() == RequestProcessingPolicyValue.USE_SERVANT_MANAGER) continue block9;
                    return i;
                }
                case 22: {
                    Policy policy;
                    if (((org.omg.PortableServer.RequestProcessingPolicy)policies[i]).value() == RequestProcessingPolicyValue.USE_ACTIVE_OBJECT_MAP_ONLY) {
                        policy = POAUtil.getPolicy(policies, 21);
                        if (policy == null || ((org.omg.PortableServer.ServantRetentionPolicy)policy).value() == ServantRetentionPolicyValue.RETAIN) continue block9;
                        return i;
                    }
                    if (((org.omg.PortableServer.RequestProcessingPolicy)policies[i]).value() != RequestProcessingPolicyValue.USE_DEFAULT_SERVANT) continue block9;
                    policy = POAUtil.getPolicy(policies, 18);
                    Policy policy2 = POAUtil.getPolicy(policies, 21);
                    if (policy == null && policy2 == null) {
                        return i;
                    }
                    if (!(policy != null && policy2 == null ? ((org.omg.PortableServer.IdUniquenessPolicy)policy).value() != IdUniquenessPolicyValue.MULTIPLE_ID : (policy == null && policy2 != null ? ((org.omg.PortableServer.ServantRetentionPolicy)policy2).value() != ServantRetentionPolicyValue.NON_RETAIN : policy != null && policy2 != null && ((org.omg.PortableServer.IdUniquenessPolicy)policy).value() != IdUniquenessPolicyValue.MULTIPLE_ID && ((org.omg.PortableServer.ServantRetentionPolicy)policy2).value() != ServantRetentionPolicyValue.NON_RETAIN))) continue block9;
                    return i;
                }
                case 20: {
                    if (((org.omg.PortableServer.ImplicitActivationPolicy)policies[i]).value() != ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION) continue block9;
                    Policy policy = POAUtil.getPolicy(policies, 21);
                    if (policy != null && ((org.omg.PortableServer.ServantRetentionPolicy)policy).value() != ServantRetentionPolicyValue.RETAIN) {
                        return i;
                    }
                    policy = POAUtil.getPolicy(policies, 19);
                    if (policy == null || ((org.omg.PortableServer.IdAssignmentPolicy)policy).value() == IdAssignmentPolicyValue.SYSTEM_ID) continue block9;
                    return i;
                }
            }
        }
        return -1;
    }

    public Policy getPolicy(int type) {
        return (Policy)this.all_policies.get(type);
    }

    public void addLocalRequest() {
        this.requestController.addLocalRequest();
    }

    public void removeLocalRequest() {
        this.requestController.removeLocalRequest();
    }

    public int getNumberOfObjects() {
        return this.aom.size();
    }
}

