/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.logging.client.cache;

import com.cosylab.logging.client.cache.LogBufferedFileCache;
import com.cosylab.logging.client.cache.LogCacheException;
import com.cosylab.logging.engine.log.ILogEntry;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class MultiFileTableRecord {
    private LogBufferedFileCache lbfc;
    private int minLogIdx = Integer.MAX_VALUE;
    private int maxLogIdx = Integer.MIN_VALUE;

    public MultiFileTableRecord() throws LogCacheException {
        this.lbfc = new LogBufferedFileCache();
    }

    public int getNumOfLogs() {
        return this.lbfc.getSize();
    }

    public long getFileSize() throws IOException {
        return this.lbfc.getFileSize();
    }

    public void addLog(ILogEntry log, int key) throws LogCacheException {
        if (log == null) {
            throw new IllegalArgumentException("The log can't be null");
        }
        this.lbfc.add(log);
        if (key < this.minLogIdx) {
            this.minLogIdx = key;
        }
        if (key > this.maxLogIdx) {
            this.maxLogIdx = key;
        }
    }

    public int getMinLogIdx() {
        return this.minLogIdx;
    }

    public int getMaxLogIdx() {
        return this.maxLogIdx;
    }

    public ILogEntry getLog(Integer key) throws LogCacheException {
        if (key == null) {
            throw new IllegalArgumentException("The key can't be null");
        }
        if (key < this.minLogIdx || key > this.maxLogIdx) {
            throw new LogCacheException("Key " + key + " out of range [" + this.minLogIdx + ", " + this.maxLogIdx + "]");
        }
        return this.lbfc.getLog(key - this.minLogIdx);
    }

    public void flushBuffer() throws LogCacheException {
        this.lbfc.flushBuffer();
    }

    public void deleteLog(Integer key) throws LogCacheException {
        if (key == null) {
            throw new IllegalArgumentException("The key can't be null");
        }
        this.lbfc.deleteLog(key - this.minLogIdx);
    }

    public void clear() throws LogCacheException {
        this.minLogIdx = Integer.MAX_VALUE;
        this.maxLogIdx = Integer.MIN_VALUE;
        this.lbfc.clear();
    }

    public boolean isEmpty() {
        return this.lbfc.getSize() == 0;
    }

    public Integer getFirstLog() {
        if (this.isEmpty()) {
            return null;
        }
        return this.lbfc.getFirstLog() + this.minLogIdx;
    }

    public Integer getLastLog() {
        if (this.isEmpty()) {
            return null;
        }
        return this.lbfc.getLastLog() + this.minLogIdx;
    }

    public int getFirstLogs(int n, Collection<Integer> keys) {
        return this.lbfc.getFirstLogs(n, keys);
    }

    public Set<Integer> keySet() {
        Set<Integer> keys = this.lbfc.keySet();
        HashSet<Integer> ret = new HashSet<Integer>();
        for (Integer key : keys) {
            ret.add(key + this.minLogIdx);
        }
        return ret;
    }

    public void replaceLog(Integer key, ILogEntry log) throws LogCacheException {
        this.lbfc.replaceLog(key - this.minLogIdx, log);
    }
}

