/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jsky.util.FileUtil;
import jsky.util.SwingWorker;
import jsky.util.gui.BasicWindowMonitor;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.ProgressBarUtil;
import jsky.util.gui.ProgressException;
import jsky.util.gui.StatusPanel;

public class ProgressBarFilterInputStream
extends FilterInputStream {
    protected ProgressBarUtil progressBar;
    JTextField statusField;
    protected DefaultBoundedRangeModel model;
    protected int nread = 0;
    protected int size = 0;
    protected long updateTime = 0L;
    protected boolean interrupted = false;

    public ProgressBarFilterInputStream(ProgressBarUtil progressBar, JTextField statusField, InputStream in, int size) {
        super(in);
        this.progressBar = progressBar;
        this.statusField = statusField;
        this.setSize(size);
    }

    public ProgressBarFilterInputStream(ProgressBarUtil progressBar, JTextField statusField, URL url) {
        super(FileUtil.makeURLStream((URL)url));
        this.progressBar = progressBar;
        this.statusField = statusField;
        progressBar.startAnimation();
        statusField.setText("Connect: Host " + url.getHost());
        try {
            int size = url.openConnection().getContentLength();
            progressBar.stopAnimation();
            this.setSize(size);
        }
        catch (Exception e) {
            statusField.setText(e.getMessage());
            progressBar.stopAnimation();
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        statusField.setText("Connected to Host " + url.getHost());
    }

    public ProgressBarFilterInputStream(StatusPanel statusPanel, URL url) {
        this(statusPanel.getProgressBar(), statusPanel.getTextField(), url);
    }

    public void interrupt() {
        this.interrupted = true;
        this.progressBar.stopAnimation();
        this.progressBar.setStringPainted(false);
        if (this.model != null) {
            this.model.setValue(0);
        }
        this.statusField.setText("Reading interrupted.");
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void checkForInterrupt() throws IOException {
        if (this.interrupted) {
            throw new ProgressException("Reading interrupted");
        }
    }

    public void setSize(final int size) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressBarFilterInputStream.this.setSize(size);
                }
            });
            return;
        }
        this.size = size;
        if (size <= 0) {
            this.model = null;
            this.progressBar.startAnimation();
            this.progressBar.setStringPainted(false);
        } else {
            this.progressBar.stopAnimation();
            this.model = new DefaultBoundedRangeModel(0, 0, 0, size);
            this.progressBar.setModel(this.model);
            this.progressBar.setStringPainted(true);
        }
    }

    protected void setNumBytesRead(final int n) {
        this.nread = n;
        long t = System.currentTimeMillis();
        if (t - this.updateTime > 200L) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProgressBarFilterInputStream.this.setNumBytesRead(n);
                    }
                });
                return;
            }
            if (this.model != null) {
                this.progressBar.stopAnimation();
                this.model.setValue(this.nread);
            }
            this.statusField.setText("Reading File: " + this.nread + " bytes");
            this.updateTime = t;
        }
    }

    public void clear() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressBarFilterInputStream.this.clear();
                }
            });
            return;
        }
        this.nread = 0;
        this.updateTime = 0L;
        this.progressBar.stopAnimation();
        this.progressBar.setStringPainted(false);
        this.statusField.setText("Document Done");
        if (this.model != null) {
            this.model.setValue(0);
        }
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public int read() throws IOException {
        this.checkForInterrupt();
        int c = this.in.read();
        if (c >= 0) {
            this.setNumBytesRead(this.nread + 1);
        } else {
            this.clear();
        }
        return c;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkForInterrupt();
        int nr = this.in.read(b, off, len);
        if (nr > 0) {
            this.setNumBytesRead(this.nread + nr);
        } else if (nr == -1) {
            this.clear();
        }
        return nr;
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkForInterrupt();
        long nr = this.in.skip(n);
        if (nr > 0L) {
            this.setNumBytesRead(this.nread + (int)nr);
        }
        return nr;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.clear();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
        this.clear();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        JPanel top = new JPanel();
        final StatusPanel statusPanel = new StatusPanel();
        final ProgressBarUtil progressBarUtil = statusPanel.getProgressBar();
        top.setLayout(new BorderLayout());
        top.add((Component)statusPanel, "North");
        frame.getContentPane().add((Component)top, "North");
        JPanel bot = new JPanel();
        final JButton busyButton = new JButton("Look Busy");
        final JButton startButton = new JButton("Start Reading");
        final JButton stopButton = new JButton("Stop");
        bot.add(busyButton);
        bot.add(startButton);
        bot.add(stopButton);
        frame.getContentPane().add((Component)bot, "South");
        class TestListener
        implements ActionListener {
            ProgressBarFilterInputStream stream;
            URL url;

            public TestListener() {
                try {
                    this.url = new URL("file:/etc/hosts");
                }
                catch (Exception e) {
                    DialogUtil.error(e);
                    System.exit(1);
                }
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Object w = e.getSource();
                if (w == busyButton) {
                    if (this.stream != null) {
                        this.stream.interrupt();
                        this.stream = null;
                    }
                    progressBarUtil.startAnimation();
                } else if (w == startButton) {
                    if (this.stream != null) {
                        this.stream.interrupt();
                        this.stream = null;
                    }
                    this.stream = new ProgressBarFilterInputStream(statusPanel, this.url);
                    SwingWorker worker = new SwingWorker(){

                        public Object construct() {
                            try {
                                while (stream.read() != -1) {
                                }
                                return null;
                            }
                            catch (Exception ex) {
                                return null;
                            }
                        }
                    };
                    worker.start();
                } else if (w == stopButton) {
                    if (this.stream != null) {
                        this.stream.interrupt();
                        this.stream = null;
                    } else {
                        progressBarUtil.stopAnimation();
                    }
                }
            }
        }
        TestListener tl = new TestListener();
        busyButton.addActionListener(tl);
        startButton.addActionListener(tl);
        stopButton.addActionListener(tl);
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(new BasicWindowMonitor());
    }
}

