/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.BevelBorder;
import javax.swing.event.EventListenerList;
import jsky.util.gui.BasicWindowMonitor;

public class ToggleButtonPanel
extends JPanel {
    protected EventListenerList listenerList = new EventListenerList();
    JToggleButton[] buttons;
    JToggleButton selectedButton;
    boolean enableMultipleSelection;

    public ToggleButtonPanel(String[] names, int nrows, int ncols, boolean enableMultipleSelection, int hgap, int vgap) {
        this((Object[])names, nrows, ncols, enableMultipleSelection, hgap, vgap);
    }

    public ToggleButtonPanel(Icon[] icons, int nrows, int ncols, boolean enableMultipleSelection, int hgap, int vgap) {
        this((Object[])icons, nrows, ncols, enableMultipleSelection, hgap, vgap);
    }

    private ToggleButtonPanel(Object[] ids, int nrows, int ncols, boolean enableMultipleSelection, int hgap, int vgap) {
        this.setLayout(new GridLayout(nrows, ncols, hgap, vgap));
        this.buttons = new JToggleButton[ids.length];
        ButtonGroup group = new ButtonGroup();
        this.enableMultipleSelection = enableMultipleSelection;
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] == null) {
                this.add(new JLabel());
                continue;
            }
            this.buttons[i] = ids[i] instanceof Icon ? new JToggleButton((Icon)ids[i]) : new JToggleButton(ids[i].toString());
            this.buttons[i].setFocusPainted(false);
            this.buttons[i].setFont(this.buttons[i].getFont().deriveFont(0));
            this.buttons[i].setBorder(new BevelBorder(0));
            this.buttons[i].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ToggleButtonPanel.this.selectedButton = (JToggleButton)e.getItem();
                    if (e.getStateChange() == 1) {
                        ToggleButtonPanel.this.selectedButton.setBorder(new BevelBorder(1));
                        ToggleButtonPanel.this.fireItemEvent(e);
                    } else {
                        ToggleButtonPanel.this.selectedButton.setBorder(new BevelBorder(0));
                        ToggleButtonPanel.this.selectedButton = null;
                        if (ToggleButtonPanel.this.enableMultipleSelection) {
                            ToggleButtonPanel.this.fireItemEvent(e);
                        }
                    }
                }
            });
            if (!enableMultipleSelection) {
                group.add(this.buttons[i]);
            }
            this.add(this.buttons[i]);
        }
    }

    public void addItemListener(ItemListener l) {
        this.listenerList.add(ItemListener.class, l);
    }

    public void removeItemListener(ItemListener l) {
        this.listenerList.remove(ItemListener.class, l);
    }

    protected void fireItemEvent(ItemEvent itemEvent) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ItemListener.class) continue;
            ((ItemListener)listeners[i + 1]).itemStateChanged(itemEvent);
        }
    }

    public JToggleButton getSelected() {
        return this.selectedButton;
    }

    public int getNumberOfButtons() {
        return this.buttons.length;
    }

    public JToggleButton getButton(int n) {
        return this.buttons[n];
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("ToggleButtonPanel");
        String[] names = new String[]{"one", "two", "three", "four", "five", null, "six", "seven", "eight", "eight", "nine", "ten"};
        ToggleButtonPanel panel = new ToggleButtonPanel(names, 0, 4, true, 1, 1);
        panel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JToggleButton bb = (JToggleButton)e.getItem();
                if (e.getStateChange() == 1) {
                    System.out.println("Selected " + bb.getText());
                } else {
                    System.out.println("Deselected " + bb.getText());
                }
            }
        });
        frame.getContentPane().add((Component)panel, "Center");
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(new BasicWindowMonitor());
    }
}

