/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.acs.maci.manager.app;

import alma.acs.logging.formatters.ConsoleLogFormatter;
import com.cosylab.acs.maci.manager.ManagerShutdown;
import com.cosylab.acs.maci.manager.app.ManagerEngine;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class Manager
implements ManagerShutdown {
    private ManagerEngine engine;
    private boolean shuttingDown = false;

    public Manager() {
        this.getManagerEngine().initialize();
        LogRecord record = new LogRecord(Level.INFO, "AcsManagerStatusMessage_ManagerStarted Manager Application initialized.");
        record.setLoggerName(this.getManagerEngine().getLogger().getName());
        String formattedString = new ConsoleLogFormatter().format(record);
        System.out.println(formattedString);
    }

    public ManagerEngine getManagerEngine() {
        if (this.engine == null) {
            this.engine = new ManagerEngine(this);
        }
        return this.engine;
    }

    @Override
    public boolean isShutdownInProgress() {
        return this.shuttingDown;
    }

    @Override
    public synchronized void shutdown(boolean sigInt) {
        if (!this.shuttingDown) {
            this.internalDestroy();
            if (!sigInt && !System.getProperty("ACS.noExit", "false").equalsIgnoreCase("true")) {
                System.exit(0);
            }
        }
    }

    public void internalDestroy() {
        this.shuttingDown = true;
        this.getManagerEngine().destroy();
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-n") && !args[i].equals("-nr")) continue;
            System.getProperties().put("Manager.recovery", "false");
        }
        new Manager();
    }
}

