/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.uid;

import alma.archive.database.helpers.DatabaseHelper;
import alma.archive.database.interfaces.IdentifierManager;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.range.IdentifierRange;
import alma.xmlstore.IdentifierPackage.NotAvailable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UidGenerator {
    private IdentifierManager imanager;
    private static Pattern p = DatabaseHelper.basicUidPattern;
    private AtomicLong documentid;
    private final long maxDocumentid = Long.MAX_VALUE;
    private Logger my_logger;
    private String globalid;
    private String archiveid;
    private volatile boolean connected = false;

    public UidGenerator() throws ArchiveException, NotAvailable {
        this.my_logger = Logger.getLogger(UidGenerator.class.getSimpleName());
        this.my_logger.setUseParentHandlers(false);
        this.my_logger.setLevel(Level.INFO);
        for (Handler nextHandler : this.my_logger.getHandlers()) {
            this.my_logger.removeHandler(nextHandler);
        }
        this.my_logger.addHandler(new Handler(this){
            private int reinitCalls = 0;

            @Override
            public void publish(LogRecord record) {
                String string = String.valueOf(record.getLevel()) + " [Thread-" + record.getThreadID() + "]";
                String className = record.getSourceClassName().substring(record.getSourceClassName().lastIndexOf(46) + 1);
                string = string + " " + className + "." + record.getSourceMethodName();
                string = string + ": " + record.getMessage();
                System.out.println(string);
                if (className.equals("DatabaseConnectionPool") && record.getSourceMethodName().equals("reinit") && record.getMessage().contains("->")) {
                    ++this.reinitCalls;
                    if (this.reinitCalls > 1) {
                        throw new RuntimeException("initialisation called more than once");
                    }
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        });
        this.connect();
    }

    public UidGenerator(Logger logger) throws ArchiveException, NotAvailable {
        this.my_logger = logger;
        this.connect();
    }

    private synchronized void connect() throws ArchiveException, NotAvailable {
        if (this.my_logger.isLoggable(Level.FINEST)) {
            this.my_logger.finest("-> connect");
        }
        if (!this.connected) {
            try {
                if (this.imanager == null) {
                    this.my_logger.log(Level.INFO, "Connecting to the identifier manager");
                    this.imanager = InternalIFFactory.getIdentifierManager(this.my_logger);
                    this.my_logger.log(Level.INFO, "Connected to the identifier manager");
                }
                this.archiveid = this.imanager.getArchiveId();
                String newUID = this.getIdNamespace();
                this.globalid = UidGenerator.extractGlobal(newUID);
                this.documentid = new AtomicLong(1L);
                this.connected = true;
            }
            catch (ModuleCriticalException e) {
                this.my_logger.log(Level.SEVERE, "failed to connect", e);
                throw new NotAvailable(e.getMessage());
            }
        }
        if (this.my_logger.isLoggable(Level.FINEST)) {
            this.my_logger.finest("<- connect");
        }
    }

    private void close() {
        if (this.imanager != null) {
            try {
                this.imanager.close();
                this.my_logger.log(Level.INFO, "Disconnected from the identifier manager");
            }
            catch (DatabaseException e) {
                this.my_logger.log(Level.INFO, "Unable to disconnect from the identifier manager");
            }
        }
    }

    public String[] getUIDs(short number) throws NotAvailable {
        return this.syncGetUIDs(number);
    }

    public boolean checkUIDsyntax(String identifier) {
        Matcher m = p.matcher(identifier);
        return m.matches();
    }

    private synchronized String[] syncGetUIDs(short number) throws NotAvailable {
        String[] out = new String[number];
        for (int count = 0; count < number; ++count) {
            out[count] = this.getNextIDInternal();
        }
        return out;
    }

    private String getNextIDInternal() throws NotAvailable {
        if (this.my_logger.isLoggable(Level.FINER)) {
            this.my_logger.finer("-> getNextIDInternal");
        }
        long nextID = this.documentid.getAndIncrement();
        String uid = null;
        if (nextID <= Long.MAX_VALUE) {
            uid = UidGenerator.generateUID(this.archiveid, this.globalid, nextID);
        } else {
            if (this.my_logger.isLoggable(Level.FINER)) {
                this.my_logger.finer("nextId has exceeded max, rolling over");
            }
            String newUID = this.getIdNamespace();
            this.globalid = UidGenerator.extractGlobal(newUID);
            this.documentid.set(1L);
            uid = this.getNextIDInternal();
        }
        if (this.my_logger.isLoggable(Level.FINER)) {
            this.my_logger.finer("<- getNextIDInternal");
        }
        return uid;
    }

    public String getNextId() throws NotAvailable {
        return this.getNextIDInternal();
    }

    private static String extractGlobal(String uid) {
        int start = uid.indexOf(47, 7) + 2;
        int end = uid.indexOf(47, start);
        return uid.substring(start, end);
    }

    protected static final String generateUID(String _archiveID, String _rangeID, long _localId) {
        String uid = "uid://" + _archiveID + "/X" + _rangeID + "/X" + Long.toHexString(_localId);
        return uid;
    }

    public String getIdNamespace() throws NotAvailable {
        try {
            if (this.imanager == null) {
                this.my_logger.log(Level.INFO, "Not connected to the identifier manager, connecting");
                this.connect();
            }
            return this.imanager.getIdNamespace().toASCIIString();
        }
        catch (ArchiveException e) {
            throw new NotAvailable(e.getMessage());
        }
    }

    public IdentifierRange getNewRange() throws NotAvailable {
        try {
            return this.imanager.getNewRange();
        }
        catch (ArchiveException e) {
            throw new NotAvailable(e.getLocalizedMessage());
        }
    }

    public IdentifierRange getNewRestrictedRange(int number, String user) throws NotAvailable {
        try {
            IdentifierRange r = this.imanager.getNewRange(number);
            return r;
        }
        catch (Throwable thr) {
            throw new NotAvailable(thr.toString());
        }
    }

    public void cleanUp() {
        this.close();
    }
}

