/*
 * Decompiled with CFR 0.152.
 */
package alma.sourcecat.dao;

import alma.sourcecat.dao.SourceNameDao;
import alma.sourcecat.model.SourceName;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;

public final class SourceNameDaoImpl
implements SourceNameDao {
    private static final Log LOG = LogFactory.getLog(SourceNameDaoImpl.class);
    private JdbcTemplate jdbcTmpl;
    private static final int FETCH_SIZE = 10000;
    private Map<Integer, Collection<SourceName>> idNames = Collections.emptyMap();

    public void setDataSource(DataSource dataSource) {
        this.jdbcTmpl = new JdbcTemplate(dataSource);
        this.jdbcTmpl.setFetchSize(10000);
        this.refreshCachedSourceNames();
    }

    @Override
    public Integer addSourceName(Integer sourceId, String newName) {
        String newNameIdSql = "SELECT name_id_seq.nextval FROM dual";
        String addSourceNameSql = "INSERT INTO sourcename (id, is_alma_default, source_id, name) VALUES (?, ?, ?, upper(?))";
        int nameId = 0;
        try {
            nameId = (Integer)this.jdbcTmpl.queryForObject("SELECT name_id_seq.nextval FROM dual", Integer.class);
            boolean isAlmaStandard = newName.matches("^(J|j)\\d{4}(\\+|-)\\d{4}$");
            this.jdbcTmpl.update("INSERT INTO sourcename (id, is_alma_default, source_id, name) VALUES (?, ?, ?, upper(?))", new Object[]{nameId, isAlmaStandard ? "Y" : "N", sourceId, newName});
            this.getOrCreateCachedName(sourceId).add(new SourceName(nameId, newName.toUpperCase()));
        }
        catch (DataAccessException e) {
            LOG.error((Object)String.format("Add source name failed: %s %s.", sourceId == null ? "null" : sourceId.toString(), newName), (Throwable)e);
            nameId = 0;
        }
        return nameId;
    }

    private Collection<SourceName> getOrCreateCachedName(Integer sourceId) {
        Collection<SourceName> names = this.idNames.get(sourceId);
        if (names == null) {
            names = new TreeSet<SourceName>();
            this.idNames.put(sourceId, names);
        }
        return names;
    }

    @Override
    public Boolean removeSourceName(Integer sourceId, Integer nameId) {
        boolean success;
        block5: {
            String deleteSourceNameSql = "DELETE FROM source_name WHERE source_id = ? AND name_id = ?";
            String deleteNameSql = "DELETE FROM names WHERE name_id = ?";
            success = false;
            if (sourceId != null && nameId != null) {
                try {
                    if (this.jdbcTmpl.update("DELETE FROM source_name WHERE source_id = ? AND name_id = ?", new Object[]{sourceId, nameId}) != 1) break block5;
                    try {
                        this.jdbcTmpl.update("DELETE FROM names WHERE name_id = ?", new Object[]{nameId});
                        this.removeCachedSourceName(sourceId, nameId, null);
                    }
                    catch (DataIntegrityViolationException e) {
                        LOG.debug((Object)String.format("Name %d not deleted.", nameId), (Throwable)e);
                    }
                    success = true;
                }
                catch (DataAccessException e) {
                    LOG.error((Object)String.format("Could not remove name %s from source %s.", nameId, sourceId), (Throwable)e);
                }
            }
        }
        return success;
    }

    @Override
    public Boolean removeSourceName(Integer sourceId, String name) {
        String sql = "delete from sourcename where source_id = ? and name = upper(?)";
        int numRowsRemoved = this.jdbcTmpl.update("delete from sourcename where source_id = ? and name = upper(?)", new Object[]{sourceId, name});
        this.removeCachedSourceName(sourceId, null, name);
        return numRowsRemoved == 1;
    }

    private final void removeCachedSourceName(Integer sourceId, Integer nameId, String name) {
        Collection<SourceName> sourceNames = this.idNames.get(sourceId);
        List matches = sourceNames.stream().filter(e -> nameId != null && nameId.intValue() == e.getId() || name != null && name.equalsIgnoreCase(e.getName())).collect(Collectors.toList());
        sourceNames.removeAll(matches);
    }

    @Override
    public Collection<SourceName> getNamesForSource(Integer sourceId) {
        return this.idNames.get(sourceId);
    }

    @Override
    public void refreshCachedSourceNames() {
        String sql = "select source_id, id, name from sourcename";
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"-> cacheAllNames");
        }
        long startTime = System.currentTimeMillis();
        this.idNames = new HashMap<Integer, Collection<SourceName>>();
        this.jdbcTmpl.query("select source_id, id, name from sourcename", (RowCallbackHandler)new SourceNameRowCallbackHandler());
        LOG.info((Object)("loaded " + this.idNames.size() + " source names in " + (System.currentTimeMillis() - startTime) + "ms"));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("cached " + this.idNames.size()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<- cacheAllNames");
        }
    }

    @Override
    public Collection<SourceName> getAndCacheNames(Integer sourceId) {
        String sql = "select source_id, id, name from sourcename where source_id = ?";
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"-> cacheAllNames");
        }
        this.jdbcTmpl.query("select source_id, id, name from sourcename where source_id = ?", new Object[]{sourceId}, (RowCallbackHandler)new SourceNameRowCallbackHandler());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<- cacheAllNames");
        }
        return this.idNames.get(sourceId);
    }

    @Override
    public Map<Integer, List<SourceName>> getSources(Set<Integer> sourceIds) {
        final HashMap<Integer, List<SourceName>> sourceNames = new HashMap<Integer, List<SourceName>>();
        ArrayList<Integer> ids = new ArrayList<Integer>(sourceIds);
        for (int i = 0; i < ids.size(); i += 1000) {
            List subList = ids.subList(i, Math.min(i + 1000, ids.size()));
            String sql = "select source_id, id, name from sourcename where source_id in " + subList.toString().replace('[', '(').replace(']', ')');
            this.jdbcTmpl.query(sql, new RowCallbackHandler(){

                public void processRow(ResultSet rs) throws SQLException {
                    Integer sourceId = rs.getInt("source_id");
                    ArrayList<SourceName> existingSourceNames = (ArrayList<SourceName>)sourceNames.get(sourceId);
                    if (existingSourceNames == null) {
                        existingSourceNames = new ArrayList<SourceName>();
                        sourceNames.put(sourceId, existingSourceNames);
                    }
                    existingSourceNames.add(new SourceName(rs.getInt("id"), rs.getString("name")));
                }
            });
        }
        return sourceNames;
    }

    @Override
    public boolean exists(String name) {
        String sql = "select count(*) from sourcename where name = ?";
        return 0 != (Integer)this.jdbcTmpl.queryForObject("select count(*) from sourcename where name = ?", new Object[]{name.toUpperCase().trim()}, Integer.class);
    }

    class SourceNameRowCallbackHandler
    implements RowCallbackHandler {
        SourceNameRowCallbackHandler() {
        }

        public void processRow(ResultSet rs) throws SQLException {
            Integer sourceId = rs.getInt("source_id");
            Integer nameId = rs.getInt("id");
            String name = rs.getString("name");
            Collection<SourceName> namesForId = SourceNameDaoImpl.this.getOrCreateCachedName(sourceId);
            namesForId.add(new SourceName(nameId, name));
        }
    }
}

