#*******************************************************************************
# ALMA - Atacama Large Millimeter Array
# Copyright (c) UKATC - UK Astronomy Technology Centre, Science and Technology Facilities Council, 2011
# (in the framework of the ALMA collaboration).
# All rights reserved.
# 
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
#*******************************************************************************
# This is the root class for all Python scripts.
# It provides hooks for a controlled script execution environment.
#
# A M Chavan, ESO, 14-Jan-2005
#
# $Id: ControlScript.py,v 1.2 2005/01/26 14:44:37 amchavan Exp $
        
from org.exolab.castor.xml             import Unmarshaller
from alma.entity.xmlbinding.schedblock import SchedBlock
from java.io                           import StringReader

__all__ = [ "ControlScript" ]
                 
class ControlScript:

    # The SchedBlock instance resulting form unmarshaling the
    # XML file given as input to the constructor.
    #
    schedblock = None
    
    # Constructor
    # 
    # xml   The text of an XML file encoding the
    #       SchedBlock to execute: it will be unmarshaled,
    #       and the resulting SchedBlock will be available
    #       via the 'schedblock' variable. 
    #       If it is None, then no action is taken
    #
    def __init__( self, xml ):
    	if( xml != None ):
	    self.schedblock = self.__unmarshal__( xml )
            
    # The 'execute' method will be called by the runtime
    # environment.
    # The script's logic should be coded here.
    # This implementation does nothing and returns zero,
    # meaning "all is well". Execution errors can be
    # reported via exceptions or by a non-zero return code.
    #
    def execute( self ):
        return 0
        
    # The 'unmarshal' method can be called to convert
    # an XML string to a business object.
    #
    # Returns an instance of alma.entity.xmlbinding.schedblock.SchedBlock
    #
    def __unmarshal__( self, xml ):
        reader = StringReader( xml )
        castor = Unmarshaller( SchedBlock )
        sblock = castor.unmarshal( reader )
        return sblock
        