/*
 * Decompiled with CFR 0.152.
 */
package jsky.image;

import java.awt.RenderingHints;
import javax.media.jai.Histogram;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import jsky.image.ImageHistogram;
import jsky.image.ImageUtil;
import jsky.image.operator.ImageOps;

public class ImageLookup {
    protected static final int NCOLORS = 256;
    protected static final int MIN_COLOR = 0;
    protected static final int MAX_COLOR = 255;
    protected static final int LOOKUP_SIZE = 65536;
    protected static final int LOOKUP_MIN = Short.MIN_VALUE;
    protected static final int LOOKUP_MAX = Short.MAX_VALUE;
    public static final int LINEAR_SCALE = 0;
    public static final int SQRT_SCALE = 1;
    public static final int LOG_SCALE = 2;
    public static final int HIST_EQ = 3;
    protected LookupTableJAI lookupTable;
    protected byte[] lookupArray;
    protected int lookupSize;
    protected int lookupOffset;
    protected int dataType;
    protected int scaledLowCut;
    protected int scaledHighCut;

    public LookupTableJAI getLookupTable() {
        return this.lookupTable;
    }

    protected PlanarImage scaleToShortRange(PlanarImage im, double lowCut, double highCut) {
        this.dataType = im.getSampleModel().getDataType();
        this.lookupSize = 65536;
        this.lookupOffset = 0;
        this.scaledLowCut = (int)lowCut;
        this.scaledHighCut = (int)highCut;
        switch (this.dataType) {
            case 0: {
                this.lookupOffset = -128;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.lookupOffset = Short.MIN_VALUE;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                double scale = (double)this.lookupSize / (highCut - lowCut);
                this.lookupOffset = Short.MIN_VALUE;
                double bias = -((lowCut + highCut) * 0.5) * scale;
                this.scaledLowCut = (int)(lowCut * scale + bias);
                this.scaledHighCut = (int)(highCut * scale + bias);
                RenderingHints hint = ImageUtil.getSampleModelHint(im.getTileWidth(), im.getTileHeight(), 2);
                im = ImageOps.rescale(im, scale, bias, hint);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported image data type: " + this.dataType);
            }
        }
        this.scaledLowCut -= this.lookupOffset;
        this.scaledHighCut -= this.lookupOffset;
        return im;
    }

    protected PlanarImage makeLookupTable(PlanarImage im, double lowCut, double highCut) {
        im = this.scaleToShortRange(im, lowCut, highCut);
        this.lookupArray = new byte[this.lookupSize];
        this.lookupTable = new LookupTableJAI(this.lookupArray, this.lookupOffset);
        return im;
    }

    protected int fillLookupTable(int imageVal, int imageLim, int pixVal) {
        if (imageLim > this.lookupSize) {
            imageLim = this.lookupSize;
        }
        while (imageVal < imageLim) {
            this.lookupArray[imageVal++] = (byte)pixVal;
        }
        return imageVal;
    }

    public PlanarImage scale(PlanarImage im, int scaleAlgorithm, double lowCut, double highCut) {
        return this.scale(im, scaleAlgorithm, lowCut, highCut, null, null);
    }

    public PlanarImage scale(PlanarImage im, int scaleAlgorithm, double lowCut, double highCut, ROI roi, ImageHistogram imageHistogram) {
        switch (scaleAlgorithm) {
            case 0: {
                return this.linearScale(im, lowCut, highCut);
            }
            case 1: {
                return this.sqrtScale(im, lowCut, highCut);
            }
            case 2: {
                return this.logScale(im, lowCut, highCut);
            }
            case 3: {
                if (roi == null || imageHistogram == null) break;
                return this.histEqScale(im, lowCut, highCut, roi, imageHistogram);
            }
        }
        return this.linearScale(im, lowCut, highCut);
    }

    public PlanarImage linearScale(PlanarImage im, double lowCut, double highCut) {
        int level;
        im = this.makeLookupTable(im, lowCut, highCut);
        int imageVal = this.scaledLowCut;
        double scale = (double)(this.scaledHighCut - this.scaledLowCut + 1) / 256.0;
        double upperBound = (double)this.scaledLowCut + 0.5;
        int pixVal = level = 0;
        while (level++ < 255) {
            int imageLim = (int)(upperBound += scale);
            imageVal = this.fillLookupTable(imageVal, imageLim, pixVal);
            if (imageLim > this.lookupSize) break;
            pixVal = level;
        }
        this.fillLookupTable(imageVal, this.lookupSize, pixVal);
        return im;
    }

    public PlanarImage sqrtScale(PlanarImage im, double lowCut, double highCut) {
        im = this.makeLookupTable(im, lowCut, highCut);
        int imageVal = this.scaledLowCut;
        int level = 0;
        int pixVal = 0;
        double range = this.scaledHighCut - this.scaledLowCut + 1;
        double expo = 10.0;
        while (level++ < 255) {
            int imageLim = this.scaledLowCut + (int)(Math.pow((double)level / 255.0, expo) * range + 0.5);
            if (imageLim > this.scaledHighCut) {
                imageLim = this.scaledHighCut;
            }
            imageVal = this.fillLookupTable(imageVal, imageLim, pixVal);
            pixVal = level;
        }
        this.fillLookupTable(imageVal, this.lookupSize, pixVal);
        return im;
    }

    public PlanarImage logScale(PlanarImage im, double lowCut, double highCut) {
        im = this.makeLookupTable(im, lowCut, highCut);
        int imageVal = this.scaledLowCut;
        int level = 0;
        int pixVal = 0;
        double range = this.scaledHighCut - this.scaledLowCut + 1;
        double expo = 10.0;
        double scale = expo >= 0.0 ? range / (Math.exp(expo) - 1.0) : range / (1.0 - Math.exp(expo));
        while (level++ < 255) {
            int imageLim = expo > 0.0 ? this.scaledLowCut + (int)((Math.exp((double)level / 255.0 * expo) - 1.0) * scale + 0.5) : this.scaledLowCut + (int)(1.0 - Math.exp((double)level / 255.0 * expo) * scale + 0.5);
            if (imageLim > this.scaledHighCut) {
                imageLim = this.scaledHighCut;
            }
            imageVal = this.fillLookupTable(imageVal, imageLim, pixVal);
            pixVal = level;
        }
        this.fillLookupTable(imageVal, this.lookupSize, pixVal);
        return im;
    }

    public PlanarImage histEqScale(PlanarImage im, double lowCut, double highCut, ROI roi, ImageHistogram imageHistogram) {
        int level;
        double n = highCut - lowCut;
        if (n < 256.0) {
            return this.linearScale(im, lowCut, highCut);
        }
        int numBins = 2048;
        if (n < (double)numBins) {
            numBins = (int)n;
        }
        PlanarImage shortIm = this.makeLookupTable(im, lowCut, highCut);
        Histogram histogram = imageHistogram.getHistogram(im, numBins, lowCut, highCut, roi, 4, 4);
        int[] bins = histogram.getBins(0);
        int maxCount = 0;
        int totalCount = 0;
        for (int i = 0; i < numBins; ++i) {
            totalCount += bins[i];
            if (bins[i] <= maxCount) continue;
            maxCount = bins[i];
        }
        if (maxCount == 0) {
            return shortIm;
        }
        int imageVal = this.scaledLowCut;
        double scale = (double)numBins / 256.0;
        double upperBound = (double)this.scaledLowCut + 0.5;
        int pixVal = level = 0;
        int binIndex = 0;
        int pixelsPerColor = totalCount / 256;
        while (level++ < 255) {
            int binCount = 0;
            do {
                upperBound += scale;
            } while ((binCount += bins[binIndex]) < pixelsPerColor && binIndex++ < numBins);
            int imageLim = (int)upperBound;
            imageVal = this.fillLookupTable(imageVal, imageLim, pixVal);
            if (imageLim > this.lookupSize) break;
            pixVal = level;
        }
        this.fillLookupTable(imageVal, this.lookupSize, pixVal);
        return shortIm;
    }
}

