/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock.data;

import alma.entity.xmlbinding.schedblock.AbstractSpectralWindowT;
import alma.entity.xmlbinding.schedblock.SpectralLineT;
import alma.entity.xmlbinding.schedblock.types.AbstractSpectralWindowTPolnProductsType;
import alma.entity.xmlbinding.schedblock.types.AbstractSpectralWindowTSideBandType;
import alma.entity.xmlbinding.schedblock.types.AbstractSpectralWindowTWindowFunctionType;
import alma.entity.xmlbinding.valuetypes.FrequencyT;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.Copier;
import alma.hla.runtime.obsprep.bo.CopyException;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.bo.ReferenceableProxy;
import alma.hla.runtime.obsprep.bo.ReferenceablesMap;
import alma.hla.runtime.obsprep.bo.Referring;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.bo.schedblock.SpectralLine;
import alma.valuetypes.Frequency;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSpectralWindowData
extends BusinessObject
implements IBusinessObject {
    public static final String SIDEBAND_LSB = AbstractSpectralWindowTSideBandType.LSB.toString();
    public static final String SIDEBAND_USB = AbstractSpectralWindowTSideBandType.USB.toString();
    public static final String SIDEBAND_DSB = AbstractSpectralWindowTSideBandType.DSB.toString();
    public static final String SIDEBAND_NOSB = AbstractSpectralWindowTSideBandType.NOSB.toString();
    public static final String WINDOWFUNCTION_UNIFORM = AbstractSpectralWindowTWindowFunctionType.UNIFORM.toString();
    public static final String WINDOWFUNCTION_HANNING = AbstractSpectralWindowTWindowFunctionType.HANNING.toString();
    public static final String WINDOWFUNCTION_HAMMING = AbstractSpectralWindowTWindowFunctionType.HAMMING.toString();
    public static final String WINDOWFUNCTION_BARTLETT = AbstractSpectralWindowTWindowFunctionType.BARTLETT.toString();
    public static final String WINDOWFUNCTION_BLACKMANN = AbstractSpectralWindowTWindowFunctionType.BLACKMANN.toString();
    public static final String WINDOWFUNCTION_BLACKMANN_HARRIS = AbstractSpectralWindowTWindowFunctionType.BLACKMANN_HARRIS.toString();
    public static final String WINDOWFUNCTION_WELCH = AbstractSpectralWindowTWindowFunctionType.WELCH.toString();
    public static final String POLNPRODUCTS_XX = AbstractSpectralWindowTPolnProductsType.XX.toString();
    public static final String POLNPRODUCTS_YY = AbstractSpectralWindowTPolnProductsType.YY.toString();
    public static final String POLNPRODUCTS_XX_YY = AbstractSpectralWindowTPolnProductsType.XX_YY.toString();
    public static final String POLNPRODUCTS_XX_YY_XY_YX = AbstractSpectralWindowTPolnProductsType.XX_YY_XY_YX.toString();
    protected static String[] knownSideBandList = new String[]{SIDEBAND_LSB, SIDEBAND_USB, SIDEBAND_DSB, SIDEBAND_NOSB};
    protected static String[] knownWindowFunctionList = new String[]{WINDOWFUNCTION_UNIFORM, WINDOWFUNCTION_HANNING, WINDOWFUNCTION_HAMMING, WINDOWFUNCTION_BARTLETT, WINDOWFUNCTION_BLACKMANN, WINDOWFUNCTION_BLACKMANN_HARRIS, WINDOWFUNCTION_WELCH};
    protected static String[] knownPolnProductsList = new String[]{POLNPRODUCTS_XX, POLNPRODUCTS_YY, POLNPRODUCTS_XX_YY, POLNPRODUCTS_XX_YY_XY_YX};
    private Frequency boCenterFrequency = null;
    private Frequency boEffectiveBandwidth = null;
    private Frequency boDesiredCenterFrequency = null;
    private ArrayList<SpectralLine> boSpectralLine = new ArrayList();

    protected AbstractSpectralWindowData(AbstractSpectralWindowT castorObject) {
        super(castorObject);
    }

    protected static final void patchAbstractSpectralWindowT(AbstractSpectralWindowT castorObject) {
        castorObject.setSpectralAveragingFactor(1);
        castorObject.setAssociatedSpectralWindowNumberInPair(0);
        castorObject.setUseThisSpectralWindow(true);
        AbstractSpectralWindowTSideBandType sideBandCastorEnumElement = AbstractSpectralWindowTSideBandType.valueOf("NOSB");
        castorObject.setSideBand(sideBandCastorEnumElement);
        AbstractSpectralWindowTWindowFunctionType windowFunctionCastorEnumElement = AbstractSpectralWindowTWindowFunctionType.valueOf("HANNING");
        castorObject.setWindowFunction(windowFunctionCastorEnumElement);
        AbstractSpectralWindowTPolnProductsType polnProductsCastorEnumElement = AbstractSpectralWindowTPolnProductsType.valueOf("XX,YY");
        castorObject.setPolnProducts(polnProductsCastorEnumElement);
        castorObject.setRepresentativeWindow(false);
    }

    private void wrapCenterFrequency() {
        FrequencyT subSo = this.getCastorObject().getCenterFrequency();
        if (subSo != null) {
            Frequency subBo;
            this.boCenterFrequency = subBo = new Frequency(subSo);
        }
    }

    public void setCenterFrequency(Frequency newValue) {
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        FrequencyT subCastorObject = newValue.getCastorObject();
        castorObject.setCenterFrequency(subCastorObject);
        this.boCenterFrequency = newValue;
        String propName = "alma.obsprep.bo.schedblock.AbstractSpectralWindow.centerFrequency";
        Frequency propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.schedblock.AbstractSpectralWindow.centerFrequency", propValue);
    }

    public Frequency gettrueCenterFrequency() {
        Frequency ret = this.boCenterFrequency;
        return ret;
    }

    public Frequency getCenterFrequency() {
        Frequency ret = this.gettrueCenterFrequency();
        if (ret == null) {
            ret = Frequency.createFrequency();
            this.setCenterFrequency(ret);
        }
        return ret;
    }

    public void setSpectralAveragingFactor(int newValue) {
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        castorObject.setSpectralAveragingFactor(newValue);
        String propName = "alma.obsprep.bo.schedblock.AbstractSpectralWindow.spectralAveragingFactor";
        Integer propValue = new Integer(newValue);
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.schedblock.AbstractSpectralWindow.spectralAveragingFactor", propValue);
    }

    public int gettrueSpectralAveragingFactor() {
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        int ret = castorObject.getSpectralAveragingFactor();
        return ret;
    }

    public int getSpectralAveragingFactor() {
        int ret = this.gettrueSpectralAveragingFactor();
        return ret;
    }

    public boolean hasSpectralAveragingFactor() {
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        boolean ret = castorObject.hasSpectralAveragingFactor();
        return ret;
    }

    public void setName(String newValue) {
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        castorObject.setName(newValue);
        String propName = "alma.obsprep.bo.schedblock.AbstractSpectralWindow.name";
        String propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.schedblock.AbstractSpectralWindow.name", propValue);
    }

    public String gettrueName() {
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        String ret = castorObject.getName();
        return ret;
    }

    @Override
    public String getName() {
        String ret = this.gettrueName();
        if (ret == null) {
            ret = "";
            this.setName(ret);
        }
        return ret;
    }

    private void wrapEffectiveBandwidth() {
        FrequencyT subSo = this.getCastorObject().getEffectiveBandwidth();
        if (subSo != null) {
            Frequency subBo;
            this.boEffectiveBandwidth = subBo = new Frequency(subSo);
        }
    }

    public void setEffectiveBandwidth(Frequency newValue) {
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        FrequencyT subCastorObject = newValue.getCastorObject();
        castorObject.setEffectiveBandwidth(subCastorObject);
        this.boEffectiveBandwidth = newValue;
        String propName = "alma.obsprep.bo.schedblock.AbstractSpectralWindow.effectiveBandwidth";
        Frequency propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.schedblock.AbstractSpectralWindow.effectiveBandwidth", propValue);
    }

    public Frequency gettrueEffectiveBandwidth() {
        Frequency ret = this.boEffectiveBandwidth;
        return ret;
    }

    public Frequency getEffectiveBandwidth() {
        Frequency ret = this.gettrueEffectiveBandwidth();
        if (ret == null) {
            ret = Frequency.createFrequency();
            this.setEffectiveBandwidth(ret);
        }
        return ret;
    }

    public void setEffectiveNumberOfChannels(int newValue) {
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        castorObject.setEffectiveNumberOfChannels(newValue);
        String propName = "alma.obsprep.bo.schedblock.AbstractSpectralWindow.effectiveNumberOfChannels";
        Integer propValue = new Integer(newValue);
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.schedblock.AbstractSpectralWindow.effectiveNumberOfChannels", propValue);
    }

    public int gettrueEffectiveNumberOfChannels() {
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        int ret = castorObject.getEffectiveNumberOfChannels();
        return ret;
    }

    public int getEffectiveNumberOfChannels() {
        int ret = this.gettrueEffectiveNumberOfChannels();
        return ret;
    }

    public boolean hasEffectiveNumberOfChannels() {
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        boolean ret = castorObject.hasEffectiveNumberOfChannels();
        return ret;
    }

    public void setAssociatedSpectralWindowNumberInPair(int newValue) {
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        castorObject.setAssociatedSpectralWindowNumberInPair(newValue);
        String propName = "alma.obsprep.bo.schedblock.AbstractSpectralWindow.associatedSpectralWindowNumberInPair";
        Integer propValue = new Integer(newValue);
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.schedblock.AbstractSpectralWindow.associatedSpectralWindowNumberInPair", propValue);
    }

    public int gettrueAssociatedSpectralWindowNumberInPair() {
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        int ret = castorObject.getAssociatedSpectralWindowNumberInPair();
        return ret;
    }

    public int getAssociatedSpectralWindowNumberInPair() {
        int ret = this.gettrueAssociatedSpectralWindowNumberInPair();
        return ret;
    }

    public boolean hasAssociatedSpectralWindowNumberInPair() {
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        boolean ret = castorObject.hasAssociatedSpectralWindowNumberInPair();
        return ret;
    }

    public void setUseThisSpectralWindow(boolean newValue) {
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        castorObject.setUseThisSpectralWindow(newValue);
        String propName = "alma.obsprep.bo.schedblock.AbstractSpectralWindow.useThisSpectralWindow";
        Boolean propValue = new Boolean(newValue);
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.schedblock.AbstractSpectralWindow.useThisSpectralWindow", propValue);
    }

    public boolean gettrueUseThisSpectralWindow() {
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        boolean ret = castorObject.getUseThisSpectralWindow();
        return ret;
    }

    public boolean getUseThisSpectralWindow() {
        boolean ret = this.gettrueUseThisSpectralWindow();
        return ret;
    }

    public boolean hasUseThisSpectralWindow() {
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        boolean ret = castorObject.hasUseThisSpectralWindow();
        return ret;
    }

    public void setSideBand(String newValue) throws IllegalArgumentException {
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        AbstractSpectralWindowTSideBandType castorEnumElement = AbstractSpectralWindowTSideBandType.valueOf(newValue);
        castorObject.setSideBand(castorEnumElement);
        String propName = "alma.obsprep.bo.schedblock.AbstractSpectralWindow.sideBand";
        String propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.schedblock.AbstractSpectralWindow.sideBand", propValue);
    }

    public String getSideBand() {
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        AbstractSpectralWindowTSideBandType value = castorObject.getSideBand();
        String ret = value == null ? null : value.toString();
        return ret;
    }

    public static String[] getKnownSideBandList() {
        return knownSideBandList;
    }

    public void setWindowFunction(String newValue) throws IllegalArgumentException {
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        AbstractSpectralWindowTWindowFunctionType castorEnumElement = AbstractSpectralWindowTWindowFunctionType.valueOf(newValue);
        castorObject.setWindowFunction(castorEnumElement);
        String propName = "alma.obsprep.bo.schedblock.AbstractSpectralWindow.windowFunction";
        String propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.schedblock.AbstractSpectralWindow.windowFunction", propValue);
    }

    public String getWindowFunction() {
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        AbstractSpectralWindowTWindowFunctionType value = castorObject.getWindowFunction();
        String ret = value == null ? null : value.toString();
        return ret;
    }

    public static String[] getKnownWindowFunctionList() {
        return knownWindowFunctionList;
    }

    public void setPolnProducts(String newValue) throws IllegalArgumentException {
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        AbstractSpectralWindowTPolnProductsType castorEnumElement = AbstractSpectralWindowTPolnProductsType.valueOf(newValue);
        castorObject.setPolnProducts(castorEnumElement);
        String propName = "alma.obsprep.bo.schedblock.AbstractSpectralWindow.polnProducts";
        String propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.schedblock.AbstractSpectralWindow.polnProducts", propValue);
    }

    public String getPolnProducts() {
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        AbstractSpectralWindowTPolnProductsType value = castorObject.getPolnProducts();
        String ret = value == null ? null : value.toString();
        return ret;
    }

    public static String[] getKnownPolnProductsList() {
        return knownPolnProductsList;
    }

    private void wrapDesiredCenterFrequency() {
        FrequencyT subSo = this.getCastorObject().getDesiredCenterFrequency();
        if (subSo != null) {
            Frequency subBo;
            this.boDesiredCenterFrequency = subBo = new Frequency(subSo);
        }
    }

    public void setDesiredCenterFrequency(Frequency newValue) {
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        FrequencyT subCastorObject = newValue.getCastorObject();
        castorObject.setDesiredCenterFrequency(subCastorObject);
        this.boDesiredCenterFrequency = newValue;
        String propName = "alma.obsprep.bo.schedblock.AbstractSpectralWindow.desiredCenterFrequency";
        Frequency propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.schedblock.AbstractSpectralWindow.desiredCenterFrequency", propValue);
    }

    public Frequency gettrueDesiredCenterFrequency() {
        Frequency ret = this.boDesiredCenterFrequency;
        return ret;
    }

    public Frequency getDesiredCenterFrequency() {
        Frequency ret = this.gettrueDesiredCenterFrequency();
        if (ret == null) {
            ret = Frequency.createFrequency();
            this.setDesiredCenterFrequency(ret);
        }
        return ret;
    }

    public void setRepresentativeWindow(boolean newValue) {
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        castorObject.setRepresentativeWindow(newValue);
        String propName = "alma.obsprep.bo.schedblock.AbstractSpectralWindow.representativeWindow";
        Boolean propValue = new Boolean(newValue);
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.schedblock.AbstractSpectralWindow.representativeWindow", propValue);
    }

    public boolean gettrueRepresentativeWindow() {
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        boolean ret = castorObject.getRepresentativeWindow();
        return ret;
    }

    public boolean getRepresentativeWindow() {
        boolean ret = this.gettrueRepresentativeWindow();
        return ret;
    }

    public boolean hasRepresentativeWindow() {
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        boolean ret = castorObject.hasRepresentativeWindow();
        return ret;
    }

    public void setGroupingIdentifier(String newValue) {
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        castorObject.setGroupingIdentifier(newValue);
        String propName = "alma.obsprep.bo.schedblock.AbstractSpectralWindow.groupingIdentifier";
        String propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.schedblock.AbstractSpectralWindow.groupingIdentifier", propValue);
    }

    public String gettrueGroupingIdentifier() {
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        String ret = castorObject.getGroupingIdentifier();
        return ret;
    }

    public String getGroupingIdentifier() {
        String ret = this.gettrueGroupingIdentifier();
        if (ret == null) {
            ret = "";
            this.setGroupingIdentifier(ret);
        }
        return ret;
    }

    public void setSpectralLine(SpectralLine[] bos) {
        this.clearSpectralLine();
        for (int i = 0; i < bos.length; ++i) {
            this.addSpectralLine(i, bos[i]);
        }
    }

    public SpectralLine[] gettrueSpectralLine() {
        return this.getSpectralLine();
    }

    public SpectralLine[] getSpectralLine() {
        int size = this.getSpectralLineCount();
        SpectralLine[] ret = new SpectralLine[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = this.getSpectralLine(i);
        }
        return ret;
    }

    public void addSpectralLine(SpectralLine bo) {
        this.addSpectralLine(this.getSpectralLineCount(), bo);
    }

    public void clearSpectralLine() {
        int size = this.getSpectralLineCount();
        for (int i = 0; i < size; ++i) {
            SpectralLine first = this.getSpectralLine(0);
            this.removeSpectralLine(first);
        }
    }

    public void addSpectralLine(int index, SpectralLine bo) throws IndexOutOfBoundsException {
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        SpectralLineT subCastorObject = bo.getCastorObject();
        castorObject.addSpectralLine(index, subCastorObject);
        this.boSpectralLine.add(index, bo);
        Referring.By by = Referring.By.UmlComposition;
        bo.addedTo((IBusinessObject)this, by, index);
    }

    public boolean removeSpectralLine(SpectralLine bo) {
        boolean ok = false;
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        SpectralLineT subCastorObject = bo.getCastorObject();
        ok = castorObject.removeSpectralLine(subCastorObject);
        this.boSpectralLine.remove(bo);
        if (ok) {
            Referring.By by = Referring.By.UmlComposition;
            bo.removedFrom((IBusinessObject)this, by);
        }
        return ok;
    }

    public SpectralLine getSpectralLine(int index) throws IndexOutOfBoundsException {
        SpectralLine ret = this.boSpectralLine.get(index);
        return ret;
    }

    public int getSpectralLineCount() {
        AbstractSpectralWindowT castorObject = this.getCastorObject();
        return castorObject.getSpectralLineCount();
    }

    private void wrapSpectralLine() {
        SpectralLineT[] all;
        for (SpectralLineT so : all = this.getCastorObject().getSpectralLine()) {
            SpectralLine bo = new SpectralLine(so);
            this.boSpectralLine.add(bo);
        }
    }

    @Override
    public AbstractSpectralWindowT getCastorObject() {
        return (AbstractSpectralWindowT)this.storageObject;
    }

    public AbstractSpectralWindow deepCopy() throws CopyException {
        return (AbstractSpectralWindow)super.deepCopy();
    }

    @Override
    protected void initAttribsAndPartsFrom(IBusinessObject original, Copier copier) throws CopyException {
        super.initAttribsAndPartsFrom(original, copier);
        AbstractSpectralWindowData orig = (AbstractSpectralWindowData)original;
        if (orig.gettrueCenterFrequency() != null) {
            this.setCenterFrequency((Frequency)copier.cpAttr((BusinessObject)orig.gettrueCenterFrequency()));
        }
        if (orig.hasSpectralAveragingFactor()) {
            this.setSpectralAveragingFactor(orig.getSpectralAveragingFactor());
        }
        if (orig.gettrueName() != null) {
            this.setName(orig.gettrueName());
        }
        if (orig.gettrueEffectiveBandwidth() != null) {
            this.setEffectiveBandwidth((Frequency)copier.cpAttr((BusinessObject)orig.gettrueEffectiveBandwidth()));
        }
        if (orig.hasEffectiveNumberOfChannels()) {
            this.setEffectiveNumberOfChannels(orig.getEffectiveNumberOfChannels());
        }
        if (orig.hasAssociatedSpectralWindowNumberInPair()) {
            this.setAssociatedSpectralWindowNumberInPair(orig.getAssociatedSpectralWindowNumberInPair());
        }
        if (orig.hasUseThisSpectralWindow()) {
            this.setUseThisSpectralWindow(orig.getUseThisSpectralWindow());
        }
        if (orig.getSideBand() != null) {
            this.setSideBand(orig.getSideBand());
        }
        if (orig.getWindowFunction() != null) {
            this.setWindowFunction(orig.getWindowFunction());
        }
        if (orig.getPolnProducts() != null) {
            this.setPolnProducts(orig.getPolnProducts());
        }
        if (orig.gettrueDesiredCenterFrequency() != null) {
            this.setDesiredCenterFrequency((Frequency)copier.cpAttr((BusinessObject)orig.gettrueDesiredCenterFrequency()));
        }
        if (orig.hasRepresentativeWindow()) {
            this.setRepresentativeWindow(orig.getRepresentativeWindow());
        }
        if (orig.gettrueGroupingIdentifier() != null) {
            this.setGroupingIdentifier(orig.gettrueGroupingIdentifier());
        }
        try {
            SpectralLine[] theSpectralLines = orig.gettrueSpectralLine();
            if (theSpectralLines != null) {
                this.clearSpectralLine();
                for (int i = 0; i < theSpectralLines.length; ++i) {
                    this.addSpectralLine((SpectralLine)copier.cpPart((BusinessObject)theSpectralLines[i]));
                }
            }
        }
        catch (Exception exc) {
            throw new CopyException("Failed to copy SpectralLine", (Throwable)exc);
        }
    }

    @Override
    protected void initEntityReferencesFrom(IBusinessObject original, Copier copier) throws CopyException {
        super.initEntityReferencesFrom(original, copier);
        AbstractSpectralWindowData orig = (AbstractSpectralWindowData)original;
    }

    @Override
    public void wrapObjects(ReferenceablesMap referencedObjects, List<ReferenceableProxy<? extends IBusinessObject>> referrers) {
        super.wrapObjects(referencedObjects, referrers);
        this.wrapCenterFrequency();
        this.wrapEffectiveBandwidth();
        this.wrapDesiredCenterFrequency();
        this.wrapSpectralLine();
    }

    @Override
    public List<IBusinessObject> referencedBOs(Referring.By ... bys) {
        List<IBusinessObject> r = super.referencedBOs(bys);
        block5: for (Referring.By by : bys) {
            switch (by) {
                case UmlComposition: {
                    this.addToCollection(r, this.gettrueSpectralLine());
                    continue block5;
                }
                case UmlUnidir: {
                    continue block5;
                }
                case UmlAttribution: {
                    this.addToCollection(r, this.gettrueCenterFrequency());
                    this.addToCollection(r, this.gettrueEffectiveBandwidth());
                    this.addToCollection(r, this.gettrueDesiredCenterFrequency());
                }
            }
        }
        return r;
    }
}

