/*
 * Decompiled with CFR 0.152.
 */
package alma.common.sourcecatalog.utilities;

import alma.common.sourcecatalog.utilities.InvalidCoordException;
import alma.common.sourcecatalog.utilities.OutOfRangeException;
import alma.common.sourcecatalog.utilities.TextUtils;
import java.util.StringTokenizer;

public final class Convert {
    public static final int DECIMAL_PLACES_ACCURACY = 3;
    public static final double HOURS_TO_DEGREES = 15.0;
    public static final int MAX_MILLISECS_DEC = 324000000;
    public static final int MAX_MILLISECS_RA = 1295999985;
    public static final int MILLISECS_PER_SEC = 1000;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int MINUTES_PER_DEGREE = 60;
    public static final int MINUTES_PER_HOUR = 60;
    public static final int DEC_MAX_DEGREES = 90;
    public static final int RA_MAX_HOURS = 24;
    public static final int MILLISECS_PER_MINUTE = 60000;
    public static final int MILLISECS_PER_UNIT = 3600000;
    public static final int FW_BEFORE = 2;
    public static final int FW_AFTER = 3;

    private Convert() {
    }

    private static void checkBoundsDDMMSS(int sign, int degrees, int minutes, int seconds, int milliSecs) throws InvalidCoordException {
        if (degrees > 90 || minutes >= 60 || seconds >= 60 || milliSecs >= 1000) {
            throw new InvalidCoordException("Illegal DD:MM:SS value: " + Convert.valuesToString(sign, degrees, minutes, seconds, milliSecs));
        }
        if (degrees == 90 && (minutes > 0 || seconds > 0 || milliSecs > 0)) {
            throw new InvalidCoordException("Illegal DD:MM:SS value: " + Convert.valuesToString(sign, degrees, minutes, seconds, milliSecs));
        }
    }

    private static void checkBoundsHHMMSS(int sign, int hours, int minutes, int seconds, int milliSecs) throws InvalidCoordException {
        if (sign < 0 || hours >= 24 || minutes >= 60 || seconds >= 60 || milliSecs >= 1000) {
            throw new InvalidCoordException("Invalid HH:MM:SS.SSS value: " + Convert.valuesToString(sign, hours, minutes, seconds, milliSecs));
        }
    }

    public static String convertToXXMMSS(long n) {
        String sign = "";
        if (n < 0L) {
            sign = "-";
            n = -n;
        }
        long millisecs = n % 1000L;
        long secs = (n /= 1000L) % 60L;
        long mins = (n /= 60L) % 60L;
        long xxx = n /= 60L;
        return sign + TextUtils.zeroPadded(2, xxx) + TextUtils.zeroPadded(2, mins) + TextUtils.zeroPadded(2, secs) + "." + TextUtils.zeroPadded(3, millisecs);
    }

    public static double DDMMSSToDeg(String value) throws InvalidCoordException, NumberFormatException {
        int marcsec = Convert.DDMMSSToMilliarcsec(value);
        double ret = (double)marcsec / 3600000.0;
        return ret;
    }

    public static int DDMMSSToMilliarcsec(String value) throws InvalidCoordException, NumberFormatException {
        return Convert.stringToMilliarcsec(value, false, false);
    }

    public static double HHMMSSToDeg(String value) throws InvalidCoordException, NumberFormatException {
        int marcsec = Convert.HHMMSSToMilliarcsec(value);
        double ret = (double)marcsec / 3600000.0;
        return ret;
    }

    public static int HHMMSSToMilliarcsec(String value) throws InvalidCoordException, NumberFormatException {
        return Convert.stringToMilliarcsec(value, true, false);
    }

    public static double HHMMSSToSec(String value) throws InvalidCoordException, NumberFormatException {
        int marcsec = Convert.HHMMSSToMilliarcsec(value);
        double ret = (double)marcsec / 1000.0;
        return ret;
    }

    public static boolean isValidDec(long dec) {
        return -324000000L <= dec && dec <= 324000000L;
    }

    public static boolean isValidRA(long ra) {
        return 0L <= ra && ra < 1295999985L;
    }

    public static String degToDDMMSS(double value) throws OutOfRangeException, InvalidCoordException {
        long msec = Math.round(value * 3600000.0);
        return Convert.milliarcsecToString(msec, false, false);
    }

    public static String degToHHMMSS(double value) throws OutOfRangeException, InvalidCoordException {
        long msec = Math.round(value * 3600000.0);
        return Convert.milliarcsecToString(msec, true, false);
    }

    public static String milliarcsecToDDMMSS(long value) throws OutOfRangeException, InvalidCoordException {
        return Convert.milliarcsecToString(value, false, false);
    }

    public static String milliarcsecToHHMMSS(long value) throws OutOfRangeException, InvalidCoordException {
        return Convert.milliarcsecToString(value, true, false);
    }

    public static String milliarcsecToString(long value, boolean ra, boolean noCheck) throws OutOfRangeException, InvalidCoordException {
        if (!noCheck) {
            if (value > Long.MAX_VALUE || value < Long.MIN_VALUE) {
                throw new OutOfRangeException("Out of range: " + value);
            }
            if (ra) {
                if (!Convert.isValidRA(value)) {
                    throw new InvalidCoordException("Invalid masec RA: " + value);
                }
            } else if (!Convert.isValidDec(value)) {
                throw new InvalidCoordException("Invalid masec Dec: " + value);
            }
        }
        if (ra) {
            value /= 15L;
        }
        char sign = ' ';
        if (value < 0L) {
            sign = '-';
            value = -value;
        }
        long units = value / 3600000L;
        long minutes = (value -= units * 3600000L) / 60000L;
        return sign + TextUtils.zeroPadded(2, units) + ":" + TextUtils.zeroPadded(2, minutes) + ":" + TextUtils.zeroPadded(2, (value -= minutes * 60000L) / 1000L) + "." + TextUtils.zeroPadded(3, value % 1000L);
    }

    public static String normalizeDec(String dec) throws OutOfRangeException, InvalidCoordException, NumberFormatException {
        int m = Convert.DDMMSSToMilliarcsec(dec);
        String t = Convert.milliarcsecToDDMMSS(m);
        return t;
    }

    public static String normalizeRa(String ra) throws OutOfRangeException, InvalidCoordException, NumberFormatException {
        int m = Convert.HHMMSSToMilliarcsec(ra);
        String t = Convert.milliarcsecToHHMMSS(m);
        return t;
    }

    public static double round(double db, int places) {
        double base = 1.0;
        for (int i = 1; i <= places; ++i) {
            base *= 10.0;
        }
        double tmp = db * base;
        tmp = tmp >= 0.0 ? (tmp += 0.5) : (tmp -= 0.5);
        int ip = (int)tmp;
        tmp = (double)ip / base;
        return tmp;
    }

    public static String secToHHMMSS(long value) throws OutOfRangeException, InvalidCoordException {
        long millisecs = value * 1000L;
        return Convert.milliarcsecToString(millisecs, false, true);
    }

    private static int stringToMilliarcsec(String value, boolean ra, boolean noCheck) throws InvalidCoordException, NumberFormatException {
        int result = 0;
        try {
            int units;
            value = value.trim();
            if (value.startsWith("+")) {
                value = value.substring(1);
            }
            if (value.indexOf(58) == -1) {
                return Convert.stringToMilliarcsecNoColons(value, ra, noCheck);
            }
            result = 0;
            StringTokenizer st = new StringTokenizer(value, " :");
            String unitsString = st.nextToken();
            int minutes = 0;
            int seconds = 0;
            int milliSecs = 0;
            int sign = 1;
            if (st.hasMoreTokens()) {
                minutes = new Integer(st.nextToken());
                if (st.hasMoreTokens()) {
                    seconds = new Integer(st.nextToken(": ,."));
                    if (st.hasMoreTokens()) {
                        Object ms = st.nextToken(".,");
                        for (int j = 1; j <= 3; ++j) {
                            ms = (String)ms + "0";
                        }
                        ms = ((String)ms).substring(0, 3);
                        milliSecs = new Integer((String)ms);
                    }
                }
            }
            if (unitsString.startsWith("-")) {
                sign = -1;
                units = -new Integer(unitsString).intValue();
            } else {
                units = new Integer(unitsString);
            }
            if (!noCheck) {
                if (ra) {
                    Convert.checkBoundsHHMMSS(sign, units, minutes, seconds, milliSecs);
                } else {
                    Convert.checkBoundsDDMMSS(sign, units, minutes, seconds, milliSecs);
                }
            }
            result = sign * (units * 3600000 + minutes * 60000 + seconds * 1000 + milliSecs);
            if (ra) {
                result *= 15;
            }
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Invalid number: '" + e.getMessage() + "'");
        }
        return result;
    }

    private static int stringToMilliarcsecNoColons(String value, boolean ra, boolean noCheck) throws InvalidCoordException, NumberFormatException {
        int milliSecs;
        int sign;
        int length = 6;
        String zeros = "000000";
        int result = 0;
        int iPoint = -1;
        int iSign = -1;
        Object main = null;
        Object frac = "000";
        int t = 0;
        int l = 0;
        value = value.trim();
        t = value.indexOf(46);
        l = value.length();
        iPoint = t == -1 ? l : t;
        if (value.startsWith("-")) {
            iSign = 1;
            sign = -1;
        } else {
            iSign = 0;
            sign = 1;
        }
        main = value.substring(iSign, iPoint).trim();
        if (iPoint < l) {
            frac = value.substring(iPoint + 1, l) + "000";
            main = TextUtils.padded("000000", 6, (String)main);
        } else {
            if (((String)main).length() == 1) {
                main = "0" + (String)main;
            }
            main = TextUtils.rightpadded("000000", 6, (String)main);
        }
        frac = ((String)frac).substring(0, 3);
        if (((String)main).length() > 6) {
            throw new InvalidCoordException("String too long: '" + value + "'");
        }
        String uu = ((String)main).substring(0, 2);
        String mm = ((String)main).substring(2, 4);
        String ss = ((String)main).substring(4, 6);
        int units = 0;
        try {
            units = new Integer(uu);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(e.getMessage());
        }
        int minutes = new Integer(mm);
        int seconds = new Integer(ss);
        try {
            milliSecs = new Integer((String)frac);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(e.getMessage());
        }
        if (!noCheck) {
            if (ra) {
                Convert.checkBoundsHHMMSS(sign, units, minutes, seconds, milliSecs);
            } else {
                Convert.checkBoundsDDMMSS(sign, units, minutes, seconds, milliSecs);
            }
        }
        result = sign * (units * 3600000 + minutes * 60000 + seconds * 1000 + milliSecs);
        if (ra) {
            result *= 15;
        }
        return result;
    }

    private static String valuesToString(int sign, int degrees, int minutes, int seconds, int milliSecs) {
        Object ret = null;
        ret = sign < 0 ? "-" : "";
        ret = (String)ret + degrees + ":" + minutes + ":" + seconds + "." + milliSecs;
        return ret;
    }
}

