/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import jsky.coords.CoordinateConverter;
import jsky.coords.WorldCoordinateConverter;
import jsky.image.EmptyRenderedImage;
import jsky.image.ImageProcessor;
import jsky.image.gui.BasicImageDisplay;
import jsky.image.gui.ImageCoordinateConverter;
import jsky.image.gui.ImageGraphicsHandler;
import jsky.image.operator.ImageOps;
import jsky.util.gui.BasicWindowMonitor;

public class ImageDisplay
extends JComponent
implements BasicImageDisplay,
ChangeListener {
    private static final PlanarImage _EMPTY_IMAGE = PlanarImage.wrapRenderedImage((RenderedImage)new EmptyRenderedImage());
    private ImageProcessor _imageProcessor;
    private PlanarImage _displayImage;
    private PlanarImage _pendingImage;
    private SampleModel _sampleModel;
    private ColorModel _colorModel;
    private CoordinateConverter _coordinateConverter;
    private float _scale = 1.0f;
    private float _actualScale = 1.0f;
    private boolean _prescaled = false;
    private RenderingHints _scaleHints;
    private Point2D.Double _origin = new Point2D.Double(0.0, 0.0);
    private boolean _centered = false;
    private boolean _autoCenterImage = true;
    private Interpolation _interpolation = new InterpolationNearest();
    private int _minTileX;
    private int _maxTileX;
    private int _minTileY;
    private int _maxTileY;
    private int _tileWidth;
    private int _tileHeight;
    private int _tileGridXOffset;
    private int _tileGridYOffset;
    private boolean _immediateMode = false;
    private WorldCoordinateConverter _wcs;
    private EventListenerList _listenerList = new EventListenerList();

    public ImageDisplay(ImageProcessor imageProcessor, String name) {
        this.setName(name);
        this.setImageProcessor(imageProcessor);
        this._imageProcessor.setName(name);
        this._coordinateConverter = new ImageCoordinateConverter(this);
        this.setBackground(Color.black);
        this.setPreferredSize(new Dimension(255, 255));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (ImageDisplay.this._pendingImage != null) {
                    ImageDisplay.this.setImage(ImageDisplay.this._pendingImage);
                    ImageDisplay.this._pendingImage = null;
                }
                ImageDisplay.this.updateImage();
            }
        });
    }

    public ImageDisplay(String name) {
        this(new ImageProcessor(), name);
    }

    public ImageDisplay() {
        this("Image Display");
    }

    @Override
    public void setImageProcessor(ImageProcessor imageProcessor) {
        this._imageProcessor = imageProcessor;
        this._imageProcessor.removeChangeListener((ChangeListener)this);
        this._imageProcessor.addChangeListener((ChangeListener)this);
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        this.updateImage();
    }

    @Override
    public ImageProcessor getImageProcessor() {
        return this._imageProcessor;
    }

    @Override
    public PlanarImage getImage() {
        return this._imageProcessor.getSourceImage();
    }

    @Override
    public PlanarImage getDisplayImage() {
        return this._displayImage;
    }

    @Override
    public CoordinateConverter getCoordinateConverter() {
        return this._coordinateConverter;
    }

    @Override
    public void setImage(PlanarImage im) {
        int cw = this.getWidth();
        int ch = this.getHeight();
        if (cw == 0) {
            this._pendingImage = im;
            return;
        }
        double dw = (float)im.getWidth() * this._scale;
        double dh = (float)im.getHeight() * this._scale;
        double x = Math.max((dw - (double)cw) / 2.0, 0.0);
        double y = Math.max((dh - (double)ch) / 2.0, 0.0);
        Rectangle2D.Double region = new Rectangle2D.Double(x / (double)this._scale, y / (double)this._scale, (float)cw / this._scale, (float)ch / this._scale);
        this._newImage(true);
        this._imageProcessor.setSourceImage(im, region);
        this._imageProcessor.update();
        this._newImage(false);
    }

    @Override
    public int getImageWidth() {
        PlanarImage image = this.getImage();
        if (image != null) {
            if (this._prescaled) {
                return (int)((float)image.getWidth() / this._scale);
            }
            return image.getWidth();
        }
        return 0;
    }

    @Override
    public int getImageHeight() {
        PlanarImage image = this.getImage();
        if (image != null) {
            if (this._prescaled) {
                return (int)((float)image.getHeight() / this._scale);
            }
            return image.getHeight();
        }
        return 0;
    }

    private void _newImage(boolean before) {
        if (before) {
            this._centered = true;
        }
    }

    public void clear() {
        this.setImage(_EMPTY_IMAGE);
    }

    public boolean isClear() {
        PlanarImage im = this._imageProcessor.getSourceImage();
        return im == _EMPTY_IMAGE;
    }

    @Override
    public void updateImage() {
        this._updateImage(this._imageProcessor.getDisplayImage());
    }

    private void _updateImage(PlanarImage im) {
        if (im == null) {
            return;
        }
        this._centerImage(im);
        this._displayImage = this._scale(im);
        this._sampleModel = this._displayImage.getSampleModel();
        if (this._sampleModel == null) {
            return;
        }
        this._colorModel = this._displayImage.getColorModel();
        if (this._colorModel == null) {
            this._colorModel = PlanarImage.createColorModel((SampleModel)this._sampleModel);
            if (this._colorModel == null) {
                throw new IllegalArgumentException("no color model");
            }
        }
        this._minTileX = this._displayImage.getMinTileX();
        this._maxTileX = this._displayImage.getMinTileX() + this._displayImage.getNumXTiles() - 1;
        this._minTileY = this._displayImage.getMinTileY();
        this._maxTileY = this._displayImage.getMinTileY() + this._displayImage.getNumYTiles() - 1;
        this._tileWidth = this._displayImage.getTileWidth();
        this._tileHeight = this._displayImage.getTileHeight();
        this._tileGridXOffset = this._displayImage.getTileGridXOffset();
        this._tileGridYOffset = this._displayImage.getTileGridYOffset();
        this.repaint();
    }

    @Override
    public boolean isWCS() {
        return this._wcs != null;
    }

    @Override
    public WorldCoordinateConverter getWCS() {
        return this._wcs;
    }

    @Override
    public void setWCS(WorldCoordinateConverter wcs) {
        this._wcs = wcs;
    }

    @Override
    public void setAutoCenterImage(boolean b) {
        this._autoCenterImage = b;
    }

    @Override
    public boolean isAutoCenterImage() {
        return this._autoCenterImage;
    }

    private void _centerImage(PlanarImage im) {
        if (!this._autoCenterImage) {
            return;
        }
        float scale = this._scale;
        if (this._prescaled) {
            scale = 1.0f;
        }
        int cw = this.getWidth();
        int ch = this.getHeight();
        double dw = (float)im.getWidth() * scale;
        double dh = (float)im.getHeight() * scale;
        double x = this._origin.getX();
        double y = this._origin.getY();
        boolean center = false;
        if (dw < (double)cw || this._centered) {
            x = (dw - (double)cw) / 2.0;
            center = true;
        }
        if (dh < (double)ch || this._centered) {
            y = (dh - (double)ch) / 2.0;
            center = true;
        }
        if (center) {
            this._origin.setLocation(x, y);
            this._centered = true;
        }
    }

    private int _XtoTileX(int x) {
        return (int)Math.floor((double)(x - this._tileGridXOffset) / (double)this._tileWidth);
    }

    private int _YtoTileY(int y) {
        return (int)Math.floor((double)(y - this._tileGridYOffset) / (double)this._tileHeight);
    }

    private int _TileXtoX(int tx) {
        return tx * this._tileWidth + this._tileGridXOffset;
    }

    private int _TileYtoY(int ty) {
        return ty * this._tileHeight + this._tileGridYOffset;
    }

    private int _maxInt(int a, int b) {
        return a > b ? a : b;
    }

    private int _minInt(int a, int b) {
        return a <= b ? a : b;
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        int componentWidth = this.getWidth();
        int componentHeight = this.getHeight();
        g2D.setComposite(AlphaComposite.Src);
        g2D.setColor(this.getBackground());
        g2D.fillRect(0, 0, componentWidth, componentHeight);
        if (this._displayImage == null || this._sampleModel == null) {
            return;
        }
        Rectangle clipBounds = g2D.getClipBounds();
        Rectangle2D region = this._displayImage.getBounds().createIntersection(clipBounds);
        g2D.setClip(region);
        int x = (int)region.getX();
        int y = (int)region.getY();
        int w = (int)region.getWidth();
        int h = (int)region.getHeight();
        int txmin = this._XtoTileX(x);
        txmin = this._maxInt(txmin, this._minTileX);
        txmin = this._minInt(txmin, this._maxTileX);
        int txmax = this._XtoTileX(x + w - 1);
        txmax = this._maxInt(txmax, this._minTileX);
        txmax = this._minInt(txmax, this._maxTileX);
        int tymin = this._YtoTileY(y);
        tymin = this._maxInt(tymin, this._minTileY);
        tymin = this._minInt(tymin, this._maxTileY);
        int tymax = this._YtoTileY(y + h - 1);
        tymax = this._maxInt(tymax, this._minTileY);
        tymax = this._minInt(tymax, this._maxTileY);
        Insets insets = this.getInsets();
        for (int tj = tymin; tj <= tymax; ++tj) {
            for (int ti = txmin; ti <= txmax; ++ti) {
                int tx = this._TileXtoX(ti);
                int ty = this._TileYtoY(tj);
                Raster tile = this._displayImage.getTile(ti, tj);
                if (tile == null) {
                    return;
                }
                DataBuffer dataBuffer = tile.getDataBuffer();
                if (dataBuffer == null) {
                    return;
                }
                WritableRaster wr = Raster.createWritableRaster(this._sampleModel, dataBuffer, null);
                BufferedImage bi = new BufferedImage(this._colorModel, wr, this._colorModel.isAlphaPremultiplied(), null);
                g2D.drawRenderedImage(bi, AffineTransform.getTranslateInstance(tx + insets.left, ty + insets.top));
            }
        }
        g2D.setClip(clipBounds);
        this._notifyGraphicsHandlers(g2D);
    }

    @Override
    public void addImageGraphicsHandler(ImageGraphicsHandler igh) {
        this._listenerList.add(ImageGraphicsHandler.class, igh);
    }

    @Override
    public void removeImageGraphicsHandler(ImageGraphicsHandler igh) {
        this._listenerList.remove(ImageGraphicsHandler.class, igh);
    }

    private void _notifyGraphicsHandlers(Graphics2D g) {
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ImageGraphicsHandler.class) continue;
            ((ImageGraphicsHandler)listeners[i + 1]).drawImageGraphics(this, g);
        }
    }

    @Override
    public void setOrigin(Point2D.Double origin) {
        this._origin = origin;
        this._centered = false;
    }

    @Override
    public Point2D.Double getOrigin() {
        return new Point2D.Double(this._origin.x, this._origin.y);
    }

    @Override
    public JComponent getCanvas() {
        return this;
    }

    @Override
    public void setScale(float scale) {
        this._coordinateConverter.canvasToUserCoords(this._origin, false);
        this._scale = this._actualScale = scale;
        this._coordinateConverter.userToCanvasCoords(this._origin, false);
    }

    public void setScale(float actualScale, float apparentScale) {
        this._coordinateConverter.canvasToUserCoords(this._origin, false);
        this._scale = apparentScale;
        this._actualScale = actualScale;
        this._coordinateConverter.userToCanvasCoords(this._origin, false);
    }

    @Override
    public float getScale() {
        return this._scale;
    }

    @Override
    public void setInterpolation(Interpolation i) {
        this._interpolation = i;
    }

    @Override
    public Interpolation getInterpolation() {
        return this._interpolation;
    }

    @Override
    public float getPixelValue(Point2D.Double p, int band) {
        PlanarImage im = this._imageProcessor.getRescaledSourceImage();
        if (im != null) {
            int ix = (int)p.getX();
            int iy = (int)p.getY();
            if (ix < 0 || ix > im.getWidth() || iy < 0 || iy > im.getHeight()) {
                return 0.0f;
            }
            int x = this._XtoTileX(ix);
            int y = this._YtoTileY(iy);
            if (x < 0 || y < 0) {
                return 0.0f;
            }
            Raster tile = im.getTile(x, y);
            return tile.getSampleFloat(ix, iy, band);
        }
        return 0.0f;
    }

    @Override
    public void setPrescaled(boolean b) {
        this._prescaled = b;
    }

    @Override
    public boolean isPrescaled() {
        return this._prescaled;
    }

    @Override
    public void setScaleHints(RenderingHints hints) {
        this._scaleHints = hints;
    }

    @Override
    public RenderingHints getScaleHints() {
        return this._scaleHints;
    }

    private PlanarImage _scale(PlanarImage im) {
        if (im != null) {
            float tx = (float)this._origin.getX();
            float ty = (float)this._origin.getY();
            if (this._actualScale == 1.0f || this._prescaled) {
                if (tx != 0.0f || ty != 0.0f) {
                    im = ImageOps.translate((PlanarImage)im, (float)(-tx), (float)(-ty), (Interpolation)this._interpolation);
                }
            } else {
                im = ImageOps.scale((PlanarImage)im, (float)this._actualScale, (float)this._actualScale, (float)(-tx), (float)(-ty), (Interpolation)this._interpolation, (RenderingHints)this._scaleHints);
            }
        }
        return im;
    }

    protected void scaleToFit(int width, int height) {
        float w = this.getImageWidth();
        float h = this.getImageHeight();
        if ((double)w != 0.0 && (double)h != 0.0) {
            float scale = Math.min((float)width / w, (float)height / h);
            scale = scale >= 1.0f ? (float)Math.round(scale) : 1.0f / (float)Math.round(1.0f / scale);
            this.setScale(scale);
        }
    }

    @Override
    public void scaleToFit() {
        int cw = this.getWidth();
        int ch = this.getHeight();
        if (cw != 0) {
            this.scaleToFit(cw, ch);
        }
    }

    @Override
    public Rectangle2D.Double getVisibleArea() {
        Rectangle2D.Double r = new Rectangle2D.Double();
        Point2D.Double p = new Point2D.Double(0.0, 0.0);
        this._coordinateConverter.screenToUserCoords(p, false);
        Point2D.Double size = new Point2D.Double(this.getWidth(), this.getHeight());
        this._coordinateConverter.screenToUserCoords(size, true);
        r.setRect(p.getX(), p.getY(), size.getX(), size.getY());
        return r;
    }

    @Override
    public boolean isInitialized() {
        return this._displayImage != null;
    }

    @Override
    public void setImmediateMode(boolean b) {
        this._immediateMode = b;
    }

    @Override
    public boolean isImmediateMode() {
        return this._immediateMode;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("ImageDisplay");
        ImageDisplay display = new ImageDisplay();
        if (args.length > 0) {
            try {
                display.setImage((PlanarImage)JAI.create((String)"fileload", (Object)args[0]));
            }
            catch (Exception e) {
                System.out.println("error: " + e.toString());
                System.exit(1);
            }
        }
        frame.getContentPane().add((Component)display, "Center");
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener((WindowListener)new BasicWindowMonitor());
    }
}

