/*
 * Decompiled with CFR 0.152.
 */
package alma.sourcecat.model;

import alma.sourcecat.model.Measurement;
import alma.sourcecat.model.NamesComparator;
import alma.sourcecat.model.SourceBand;
import alma.sourcecat.model.SourceName;
import alma.sourcecat.model.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class Source {
    public static final String XMLRPC_ID = "source_id";
    public static final String XMLRPC_NAMES = "names";
    public static final String XMLRPC_MEASUREMENTS = "measurements";
    public static final String XMLRPC_TYPES = "types";
    private final LinkedList<Measurement> measurements = new LinkedList();
    private final Set<SourceName> names = new TreeSet<SourceName>(new NamesComparator());
    private final LinkedList<Type> types = new LinkedList();
    private int id;
    private Double raDeg;
    private Double raDegUncertainty;
    private Double decDeg;
    private Double decDegUncertainty;
    private Date updateDate;
    private String updateUser;
    private String updateComment;
    private List<SourceBand> sourceBands = new ArrayList<SourceBand>(10);

    private Source(Map<?, ?> m) {
        Object id = m.get(XMLRPC_ID);
        if (id == null || !(id instanceof Integer)) {
            throw new IllegalArgumentException(XMLRPC_ID);
        }
        this.id = (Integer)id;
        Object[] names = this.convertToObjectArray(m.get(XMLRPC_NAMES));
        if (names != null) {
            for (SourceName sourceName : SourceName.convertResponse(names)) {
                this.names.add(sourceName);
            }
        } else {
            throw new IllegalArgumentException(XMLRPC_NAMES);
        }
        Object[] measurements = this.convertToObjectArray(m.get(XMLRPC_MEASUREMENTS));
        if (measurements != null) {
            for (Measurement measurement : Measurement.convertResponse(measurements)) {
                this.measurements.add(measurement);
            }
        } else {
            throw new IllegalArgumentException(XMLRPC_MEASUREMENTS);
        }
        Object[] objectArray = this.convertToObjectArray(m.get(XMLRPC_TYPES));
        if (objectArray != null) {
            for (Type t : Type.convertResponse(objectArray)) {
                this.types.add(t);
            }
        } else {
            throw new IllegalArgumentException(XMLRPC_TYPES);
        }
    }

    public Source() {
    }

    public Source(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public void addMeasurement(Measurement measurement) {
        this.measurements.add(measurement);
    }

    public List<Measurement> getMeasurements() {
        return this.measurements;
    }

    public void addName(SourceName name) {
        this.names.add(name);
    }

    public List<SourceName> getNames() {
        return new ArrayList<SourceName>(this.names);
    }

    public void addType(Type type) {
        this.types.add(type);
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Double getRaDeg() {
        return this.raDeg;
    }

    public void setRaDeg(Double raDeg) {
        this.raDeg = raDeg;
    }

    public Double getRaDegUncertainty() {
        return this.raDegUncertainty;
    }

    public void setRaDegUncertainty(Double raDegUncertainty) {
        this.raDegUncertainty = raDegUncertainty;
    }

    public Double getDecDeg() {
        return this.decDeg;
    }

    public void setDecDeg(Double decDeg) {
        this.decDeg = decDeg;
    }

    public Double getDecDegUncertainty() {
        return this.decDegUncertainty;
    }

    public void setDecDegUncertainty(Double decDegUncertainty) {
        this.decDegUncertainty = decDegUncertainty;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public String getUpdateUser() {
        return this.updateUser;
    }

    public void setUpdateUser(String updateUser) {
        this.updateUser = updateUser;
    }

    public String getUpdateComment() {
        return this.updateComment;
    }

    public void setUpdateComment(String updateComment) {
        this.updateComment = updateComment;
    }

    public String toString() {
        return "Source [measurements=" + String.valueOf(this.measurements) + ", names=" + String.valueOf(this.names) + ", types=" + String.valueOf(this.types) + ", id=" + this.id + ", raDeg=" + this.raDeg + ", raDegUncertainty=" + this.raDegUncertainty + ", decDeg=" + this.decDeg + ", decDegUncertainty=" + this.decDegUncertainty + ", updateDate=" + String.valueOf(this.updateDate) + ", updateUser=" + this.updateUser + ", updateComment=" + this.updateComment + ", sourceBands=" + String.valueOf(this.sourceBands) + "]";
    }

    public void addSourceBand(SourceBand sourceBand) {
        this.sourceBands.add(sourceBand);
    }

    public List<SourceBand> getSourceBands() {
        return this.sourceBands;
    }

    public static Source convertResponse(Object xmlrpcResponse) throws IllegalArgumentException {
        if (xmlrpcResponse instanceof Map) {
            return new Source((Map)xmlrpcResponse);
        }
        throw new IllegalArgumentException();
    }

    private Object[] convertToObjectArray(Object params) {
        Object[] arrayOfParams = null;
        if (params instanceof Object[]) {
            arrayOfParams = (Object[])params;
        }
        return arrayOfParams;
    }
}

