/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.vo;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.FieldDesc;
import jsky.catalog.FieldDescAdapter;
import jsky.catalog.QueryArgs;
import jsky.catalog.QueryResult;
import jsky.catalog.astrocat.AstroCatalog;
import jsky.catalog.vo.VoTable;
import jsky.coords.CoordinateRadius;
import jsky.util.Preferences;
import jsky.util.Resources;
import jsky.util.StringUtil;
import jsky.util.gui.ProgressException;
import jsky.util.gui.ProgressPanel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.util.DOMUtils;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.URLDataSource;
import uk.ac.starlink.votable.VOElement;
import uk.ac.starlink.votable.VOElementFactory;

public class SlapCatalog
implements Catalog {
    private static final Logger LOG = Logger.getLogger(SlapCatalog.class.getName());
    private URL _url;
    private String _name;
    private CatalogDirectory _parent;
    private FieldDescAdapter[] _fieldDesc;
    private transient ProgressPanel _progressPanel;

    public static Catalog getCatalog(AstroCatalog cat) {
        URL url;
        try {
            url = cat.getBaseURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        String name = cat.getName();
        if (name == null) {
            name = "unknown";
        }
        return new SlapCatalog(name, url);
    }

    public SlapCatalog(String name, URL url) {
        this._name = name;
        this._url = url;
        this._init();
    }

    private void _init() {
        this._fieldDesc = this._loadPersistent();
        if (this._fieldDesc == null) {
            try {
                URL url = this._makeURL(this._url, "FORMAT=METADATA");
                LOG.info("Reading SLAP server configuration from " + this._url);
                VOElement topEl = new VOElementFactory(StoragePolicy.getDefaultPolicy()).makeVOElement((DataSource)new URLDataSource(url));
                this._checkStatus(topEl);
                NodeList params = topEl.getElementsByTagName("PARAM");
                this._fieldDesc = new FieldDescAdapter[params.getLength()];
                for (int i = 0; i < this._fieldDesc.length; ++i) {
                    Element param = (Element)params.item(i);
                    this._fieldDesc[i] = new FieldDescAdapter(this._getName(param));
                    this._fieldDesc[i].setDisplayName(this._getDisplayName(param));
                    this._fieldDesc[i].setUCD(param.getAttribute("ucd"));
                    this._fieldDesc[i].setType(param.getAttribute("utype"));
                    NodeList nodeList = param.getElementsByTagName("DESCRIPTION");
                    if (nodeList == null || nodeList.getLength() != 1) continue;
                    this._fieldDesc[i].setDescription(nodeList.item(0).getTextContent());
                }
                this._savePersistent();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String _getName(Element param) {
        String name = param.getAttribute("name");
        if (name == null) {
            name = "unknown";
        }
        if (name.toLowerCase().startsWith("input:")) {
            name = name.substring(6).trim();
        }
        return name;
    }

    private String _getDisplayName(Element param) {
        String name = param.getAttribute("name").toLowerCase();
        if (name.startsWith("input:")) {
            name = name.substring(6).trim().replace('_', ' ');
        }
        return StringUtil.capitalize((String)name);
    }

    private URL _makeURL(URL url, String query) throws MalformedURLException {
        String urlStr = url.toString();
        if (urlStr.contains("?")) {
            return new URL(urlStr + "&" + query);
        }
        return new URL(urlStr + "?" + query);
    }

    @Override
    public Catalog reload() {
        this._removePersistent();
        this._init();
        return this;
    }

    private void _checkStatus(VOElement topEl) throws IOException {
        NodeList resources = topEl.getElementsByTagName("RESOURCE");
        Node results = null;
        for (int i = 0; i < resources.getLength(); ++i) {
            Element resource = (Element)resources.item(i);
            if (!resource.hasAttribute("type")) {
                results = resource;
                continue;
            }
            if (!"results".equals(resource.getAttribute("type")) && !"result".equals(resource.getAttribute("type"))) continue;
            results = resource;
            break;
        }
        if (results == null) {
            throw new IOException("No suitable RESOURCE found in returned VOTable");
        }
        String status = null;
        String message = null;
        for (Node node = results.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element el;
            if (!(node instanceof Element) || !"INFO".equals((el = (Element)node).getTagName()) || !"QUERY_STATUS".equals(el.getAttribute("name"))) continue;
            status = el.getAttribute("value");
            message = DOMUtils.getTextContent((Element)el);
            break;
        }
        if ("ERROR".equals(status)) {
            throw new IOException("SLAP query error: " + message);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public String getId() {
        return this._name;
    }

    @Override
    public String getTitle() {
        return this._name;
    }

    @Override
    public String getDescription() {
        return "<html><i>Syntax for range values: min1/max1,min2/max2,...</i></html>";
    }

    public String toString() {
        return this._name;
    }

    @Override
    public URL getDocURL() {
        return null;
    }

    @Override
    public int getNumParams() {
        return this._fieldDesc.length;
    }

    @Override
    public FieldDesc getParamDesc(int i) {
        return this._fieldDesc[i];
    }

    @Override
    public FieldDesc getParamDesc(String name) {
        for (FieldDescAdapter fd : this._fieldDesc) {
            if (!fd.getName().equals(name)) continue;
            return fd;
        }
        return null;
    }

    @Override
    public void setRegionArgs(QueryArgs queryArgs, CoordinateRadius region) {
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public boolean isImageServer() {
        return false;
    }

    @Override
    public String getType() {
        return "catalog";
    }

    @Override
    public void setParent(CatalogDirectory catDir) {
        this._parent = catDir;
    }

    @Override
    public CatalogDirectory getParent() {
        return this._parent;
    }

    @Override
    public Catalog[] getPath() {
        CatalogDirectory parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getPath(this);
    }

    protected ProgressPanel _getProgressPanel(String title) {
        if (this._progressPanel == null) {
            this._progressPanel = ProgressPanel.makeProgressPanel((String)title);
        } else {
            this._progressPanel.setTitle(title);
        }
        return this._progressPanel;
    }

    private URL _getQueryUrl(QueryArgs queryArgs) throws MalformedURLException {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        boolean first = true;
        for (FieldDescAdapter fd : this._fieldDesc) {
            String s;
            if ((s = (String)queryArgs.getParamValue(i++)) == null || s.length() == 0) continue;
            if (!first) {
                sb.append("&");
            }
            first = false;
            sb.append(fd.getName().toUpperCase());
            sb.append("=");
            sb.append(s);
        }
        return this._makeURL(this._url, sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryResult query(QueryArgs queryArgs) throws IOException {
        URL url = this._getQueryUrl(queryArgs);
        this._progressPanel = this._getProgressPanel("Downloading query results");
        this._progressPanel.start();
        this._progressPanel.setText("Performing SLAP query: " + url);
        try {
            VoTable result = VoTable.createVoTable(url, this.getId(), this.getName(), this);
            if (this._progressPanel.isInterrupted()) {
                throw new ProgressException("Interrupted");
            }
            VoTable voTable = result;
            return voTable;
        }
        finally {
            this._progressPanel.stop();
        }
    }

    private void _savePersistent() {
        try {
            String s = SlapCatalog._getPersistentName(this._url);
            Preferences.getPreferences().serialize(s, (Object)this._fieldDesc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private FieldDescAdapter[] _loadPersistent() {
        String name = SlapCatalog._getPersistentName(this._url);
        FieldDescAdapter[] result = null;
        try {
            result = (FieldDescAdapter[])Preferences.getPreferences().deserialize(name);
        }
        catch (Exception e) {
            try {
                String filename = name + ".ser";
                ObjectInputStream in = new ObjectInputStream(Resources.getResourceAsStream((String)filename));
                result = (FieldDescAdapter[])in.readObject();
                in.close();
                return result;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return result;
    }

    private void _removePersistent() {
        try {
            String s = SlapCatalog._getPersistentName(this._url);
            Preferences.getPreferences().removeSerializedFile(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String _getPersistentName(URL url) {
        String s = url.getHost() + url.getPath() + url.getQuery();
        return s.replaceAll("[^A-Za-z0-9_]", "-");
    }
}

