/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.jel;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.DVResolver;
import gnu.jel.Evaluator;
import gnu.jel.Library;
import gnu.jel.Parser;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Logger;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.func.Arithmetic;
import uk.ac.starlink.ttools.func.Arrays;
import uk.ac.starlink.ttools.func.Conversions;
import uk.ac.starlink.ttools.func.Coords;
import uk.ac.starlink.ttools.func.Distances;
import uk.ac.starlink.ttools.func.Fluxes;
import uk.ac.starlink.ttools.func.Formats;
import uk.ac.starlink.ttools.func.Maths;
import uk.ac.starlink.ttools.func.Strings;
import uk.ac.starlink.ttools.func.Tilings;
import uk.ac.starlink.ttools.func.Times;
import uk.ac.starlink.ttools.jel.CustomCompilationException;
import uk.ac.starlink.ttools.jel.JELRowReader;
import uk.ac.starlink.util.Loader;

public class JELUtils {
    private static List staticClasses_;
    private static Logger logger_;
    public static final String CLASSES_PROPERTY = "jel.classes";
    static /* synthetic */ Class class$uk$ac$starlink$ttools$jel$JELRowReader;

    public static Library getLibrary(JELRowReader reader) {
        Class[] staticLib = JELUtils.getStaticClasses().toArray(new Class[0]);
        Class[] dynamicLib = new Class[]{((Object)((Object)reader)).getClass()};
        Class[] dotClasses = new Class[]{};
        JELRowReader resolver = reader;
        Hashtable cnmap = null;
        return new Library(staticLib, dynamicLib, dotClasses, (DVResolver)resolver, cnmap);
    }

    public static List getStaticClasses() {
        if (staticClasses_ == null) {
            ArrayList<Class> classList = new ArrayList<Class>(java.util.Arrays.asList(Arithmetic.class, Arrays.class, Conversions.class, Coords.class, Distances.class, Fluxes.class, Formats.class, Maths.class, Strings.class, Tilings.class, Times.class));
            Loader.loadProperties();
            try {
                String auxClasses = System.getProperty(CLASSES_PROPERTY);
                if (auxClasses != null && auxClasses.trim().length() > 0) {
                    String[] cs = auxClasses.split(":");
                    for (int i = 0; i < cs.length; ++i) {
                        String className = cs[i].trim();
                        try {
                            Class clazz = class$uk$ac$starlink$ttools$jel$JELRowReader == null ? JELUtils.class$("uk.ac.starlink.ttools.jel.JELRowReader") : class$uk$ac$starlink$ttools$jel$JELRowReader;
                            Class<?> clazz2 = Class.forName(className);
                            if (classList.contains(clazz2)) continue;
                            classList.add(clazz2);
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            logger_.warning("Class not found: " + className);
                        }
                    }
                }
            }
            catch (SecurityException e) {
                logger_.info("Security manager prevents loading auxiliary JEL classes");
            }
            staticClasses_ = classList;
        }
        return staticClasses_;
    }

    public static Class getExpressionType(Library lib, StarTable table, String expr) throws CompilationException {
        return new Parser((String)JELUtils.tweakExpression((StarTable)table, (String)expr), (Library)lib).parse(null).resType;
    }

    public static void checkExpressionType(Library lib, StarTable table, String expr, Class clazz) throws CompilationException {
        new Parser(JELUtils.tweakExpression(table, expr), lib).parse(clazz);
    }

    public static CompiledExpression compile(Library lib, StarTable table, String expr, Class clazz) throws CompilationException {
        try {
            return Evaluator.compile((String)JELUtils.tweakExpression(table, expr), (Library)lib, (Class)clazz);
        }
        catch (CompilationException e) {
            try {
                Evaluator.compile((String)JELUtils.tweakExpression(table, expr), (Library)lib);
            }
            catch (CompilationException e2) {
                throw e;
            }
            throw new CustomCompilationException("Expression " + expr + " has wrong type" + " (not " + clazz.getName() + ")", e);
        }
    }

    public static CompiledExpression compile(Library lib, StarTable table, String expr) throws CompilationException {
        return Evaluator.compile((String)JELUtils.tweakExpression(table, expr), (Library)lib);
    }

    private static final String tweakExpression(StarTable table, String expr) {
        int ncol = table.getColumnCount();
        for (int icol = 0; icol < ncol; ++icol) {
            if (!table.getColumnInfo(icol).getName().equalsIgnoreCase(expr)) continue;
            return '$' + Integer.toString(icol + 1);
        }
        return expr;
    }

    public static Class getWrapperType(Class clazz) {
        if (clazz.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (clazz.equals(Character.TYPE)) {
            return Character.class;
        }
        if (clazz.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (clazz.equals(Short.TYPE)) {
            return Short.class;
        }
        if (clazz.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (clazz.equals(Long.TYPE)) {
            return Long.class;
        }
        if (clazz.equals(Float.TYPE)) {
            return Float.class;
        }
        if (clazz.equals(Double.TYPE)) {
            return Double.class;
        }
        return clazz;
    }

    static {
        logger_ = Logger.getLogger("uk.ac.starlink.ttools");
    }
}

