/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.jel;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.jel.Constant;
import uk.ac.starlink.ttools.jel.JELRowReader;

public abstract class StarTableJELRowReader
extends JELRowReader {
    private final StarTable table_;
    private final long HASH_LONG = System.identityHashCode((Object)this);
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.jel");
    public static final String PARAM_PREFIX = "param$";
    public static final String UCD_PREFIX = "ucd$";
    public static final String UTYPE_PREFIX = "utype$";
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;

    public StarTableJELRowReader(StarTable table) {
        this.table_ = table;
    }

    public StarTable getTable() {
        return this.table_;
    }

    protected abstract Object getCell(int var1) throws IOException;

    public abstract long getCurrentRow();

    protected boolean isBlank(int icol) {
        try {
            return Tables.isBlank((Object)this.getCell(icol));
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
    }

    protected Class getColumnClass(int icol) {
        return this.table_.getColumnInfo(icol).getContentClass();
    }

    protected int getColumnIndexByName(String name) {
        String utypeSpec;
        int icol;
        ColumnInfo[] colInfos = Tables.getColumnInfos((StarTable)this.table_);
        int ncol = colInfos.length;
        String ucdSpec = StarTableJELRowReader.stripPrefix(name, UCD_PREFIX);
        if (ucdSpec != null) {
            Pattern ucdRegex = StarTableJELRowReader.getUcdRegex(ucdSpec);
            for (icol = 0; icol < ncol; ++icol) {
                String ucd = colInfos[icol].getUCD();
                if (ucd == null || !ucdRegex.matcher(ucd).matches()) continue;
                return icol;
            }
        }
        if ((utypeSpec = StarTableJELRowReader.stripPrefix(name, UTYPE_PREFIX)) != null) {
            Pattern utypeRegex = StarTableJELRowReader.getUtypeRegex(utypeSpec);
            for (int icol2 = 0; icol2 < ncol; ++icol2) {
                String utype = Tables.getUtype((ValueInfo)colInfos[icol2]);
                if (utype == null || !utypeRegex.matcher(utype).matches()) continue;
                return icol2;
            }
        }
        for (icol = 0; icol < ncol; ++icol) {
            if (!colInfos[icol].getName().equalsIgnoreCase(name)) continue;
            return icol;
        }
        return -1;
    }

    protected Constant getConstantByName(String name) {
        List paramList = this.table_.getParameters();
        String ucdSpec = StarTableJELRowReader.stripPrefix(name, UCD_PREFIX);
        if (ucdSpec != null) {
            Pattern ucdRegex = StarTableJELRowReader.getUcdRegex(ucdSpec);
            Iterator it = paramList.iterator();
            while (it.hasNext()) {
                DescribedValue dval = (DescribedValue)it.next();
                String ucd = dval.getInfo().getUCD();
                if (ucd == null || !ucdRegex.matcher(ucd).matches()) continue;
                return new DescribedValueConstant(dval);
            }
            return null;
        }
        String utypeSpec = StarTableJELRowReader.stripPrefix(name, UTYPE_PREFIX);
        if (utypeSpec != null) {
            Pattern utypeRegex = StarTableJELRowReader.getUtypeRegex(utypeSpec);
            Iterator it = paramList.iterator();
            while (it.hasNext()) {
                DescribedValue dval = (DescribedValue)it.next();
                String utype = Tables.getUtype((ValueInfo)dval.getInfo());
                if (utype == null || !utypeRegex.matcher(utype).matches()) continue;
                return new DescribedValueConstant(dval);
            }
            return null;
        }
        String pname = StarTableJELRowReader.stripPrefix(name, PARAM_PREFIX);
        if (pname != null) {
            Iterator it = paramList.iterator();
            while (it.hasNext()) {
                DescribedValue dval = (DescribedValue)it.next();
                if (!pname.equalsIgnoreCase(dval.getInfo().getName())) continue;
                return new DescribedValueConstant(dval);
            }
            return null;
        }
        return null;
    }

    protected Constant getSpecialByName(String name) {
        if (name.equals("$0") || name.equalsIgnoreCase("Index")) {
            return new Constant(){

                public Class getContentClass() {
                    return class$java$lang$Long == null ? (class$java$lang$Long = StarTableJELRowReader.class$("java.lang.Long")) : class$java$lang$Long;
                }

                public Object getValue() {
                    return new Long(StarTableJELRowReader.this.getCurrentRow() + 1L);
                }
            };
        }
        if (name.equals("RANDOM")) {
            return new Constant(){

                public Class getContentClass() {
                    return class$java$lang$Double == null ? (class$java$lang$Double = StarTableJELRowReader.class$("java.lang.Double")) : class$java$lang$Double;
                }

                public Object getValue() {
                    long seed = StarTableJELRowReader.this.HASH_LONG + StarTableJELRowReader.this.getCurrentRow() * 2000000011L;
                    return new Double(new Random(seed).nextDouble());
                }
            };
        }
        return super.getSpecialByName(name);
    }

    protected boolean getBooleanColumnValue(int icol) {
        return this.getBooleanValue((Boolean)this.getCellValue(icol));
    }

    protected byte getByteColumnValue(int icol) {
        return this.getByteValue((Byte)this.getCellValue(icol));
    }

    protected char getCharColumnValue(int icol) {
        return this.getCharValue((Character)this.getCellValue(icol));
    }

    protected short getShortColumnValue(int icol) {
        return this.getShortValue((Short)this.getCellValue(icol));
    }

    protected int getIntColumnValue(int icol) {
        return this.getIntValue((Integer)this.getCellValue(icol));
    }

    protected long getLongColumnValue(int icol) {
        return this.getLongValue((Long)this.getCellValue(icol));
    }

    protected float getFloatColumnValue(int icol) {
        return this.getFloatValue((Float)this.getCellValue(icol));
    }

    protected double getDoubleColumnValue(int icol) {
        return this.getDoubleValue((Double)this.getCellValue(icol));
    }

    protected Object getObjectColumnValue(int icol) {
        return this.getCellValue(icol);
    }

    private Object getCellValue(int icol) {
        try {
            return this.getCell(icol);
        }
        catch (IOException e) {
            logger_.warning("Expression evaluation error: " + e);
            return null;
        }
    }

    public static Pattern getUcdRegex(String ucd) {
        String regex = ucd.replaceAll("[_\\W]", "\\[_\\\\W\\]");
        if (regex.endsWith("[_\\W]")) {
            regex = regex.substring(0, regex.length() - 5) + ".*";
        }
        return Pattern.compile(regex, 2);
    }

    public static Pattern getUtypeRegex(String utype) {
        String regex = utype.replaceAll("_", "\\\\W");
        return Pattern.compile(regex, 2);
    }

    private static class DescribedValueConstant
    implements Constant {
        private final Class clazz_;
        private final Object value_;

        DescribedValueConstant(DescribedValue dval) {
            this.clazz_ = dval.getInfo().getContentClass();
            Object val = dval.getValue();
            this.value_ = Tables.isBlank((Object)val) ? null : val;
        }

        public Class getContentClass() {
            return this.clazz_;
        }

        public Object getValue() {
            return this.value_;
        }
    }
}

