/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.util.Arrays;
import java.util.BitSet;
import java.util.logging.Logger;
import javax.swing.JComponent;
import uk.ac.starlink.ttools.plot.DataColorTweaker;
import uk.ac.starlink.ttools.plot.Drawing;
import uk.ac.starlink.ttools.plot.ErrorRenderer;
import uk.ac.starlink.ttools.plot.MarkStyle;
import uk.ac.starlink.ttools.plot.PixelMask;
import uk.ac.starlink.ttools.plot.Pixellator;
import uk.ac.starlink.ttools.plot.PlotData;
import uk.ac.starlink.ttools.plot.PlotDataPointIterator;
import uk.ac.starlink.ttools.plot.PlotState;
import uk.ac.starlink.ttools.plot.PlotSurface;
import uk.ac.starlink.ttools.plot.PointIterator;
import uk.ac.starlink.ttools.plot.PointPlacer;
import uk.ac.starlink.ttools.plot.PointSequence;
import uk.ac.starlink.ttools.plot.ScatterPlotEvent;
import uk.ac.starlink.ttools.plot.Shader;
import uk.ac.starlink.ttools.plot.ShaderTweaker;
import uk.ac.starlink.ttools.plot.Shaders;
import uk.ac.starlink.ttools.plot.SubsetSelectionPlotData;
import uk.ac.starlink.ttools.plot.SurfacePlot;
import uk.ac.starlink.ttools.plot.TablePlot;
import uk.ac.starlink.ttools.plot.TranslatedPixellator;
import uk.ac.starlink.ttools.plot.XYStats;
import uk.ac.starlink.util.IntList;

public class ScatterPlot
extends SurfacePlot {
    private PlotData lastData_;
    private PlotState lastState_;
    private PlotSurface lastSurface_;
    private int lastWidth_;
    private int lastHeight_;
    private Image image_;
    private static final Logger logger_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ScatterPlot(PlotSurface surface) {
        this.add(new ScatterDataPanel());
        this.setSurface(surface);
    }

    public void setState(PlotState state) {
        super.setState(state);
    }

    private void drawData(Graphics graphics, boolean pixels) {
        int yp;
        double[] coords;
        Point point;
        PlotState state = this.getState();
        PlotData data = state.getPlotData();
        PlotSurface surface = this.getSurface();
        if (data == null || state == null || surface == null || !state.getValid()) {
            return;
        }
        Graphics2D g = (Graphics2D)graphics.create();
        g.setClip(this.getSurface().getClip());
        int nset = data.getSetCount();
        IntList indexList = new IntList();
        for (int is = 0; is < nset; ++is) {
            MarkStyle style = (MarkStyle)data.getSetStyle(is);
            if (style.getHidePoints() && !MarkStyle.hasErrors(style, data)) continue;
            indexList.add(is);
        }
        int[] activeIsets = indexList.toIntArray();
        SubsetSelectionPlotData activeData = new SubsetSelectionPlotData(data, activeIsets);
        int[] pointCounts = new int[3];
        ShaderTweaker tweaker = ShaderTweaker.createTweaker(2, state);
        if (pixels) {
            if (tweaker == null) {
                ScatterPlot.plotPointsBitmap(g, activeData, surface, pointCounts);
            } else {
                ScatterPlot.plotPointsTweakedBitmap(g, activeData, surface, tweaker, pointCounts);
            }
        } else {
            ScatterPlot.plotPointsVector(g, activeData, surface, tweaker, pointCounts);
        }
        if (data.hasLabels()) {
            PixelMask mask = new PixelMask(surface.getClip().getBounds());
            PointSequence pseq = activeData.getPointSequence();
            while (pseq.next()) {
                double y;
                double[] coords2;
                double x;
                Point point2;
                String label = pseq.getLabel();
                if (label == null || label.trim().length() <= 0) continue;
                int iset = -1;
                for (int js = activeIsets.length - 1; iset < 0 && js >= 0; --js) {
                    if (!pseq.isIncluded(activeIsets[js])) continue;
                    iset = activeIsets[js];
                }
                if (iset < 0 || (point2 = surface.dataToGraphics(x = (coords2 = pseq.getPoint())[0], y = coords2[1], true)) == null || mask.get(point2)) continue;
                mask.set(point2);
                MarkStyle style = (MarkStyle)data.getSetStyle(iset);
                g.setColor(style.getLabelColor());
                style.drawLabel(g, point2.x, point2.y, label);
            }
            pseq.close();
        }
        int huge = Math.max(this.getWidth(), this.getHeight()) * 100;
        for (int is = 0; is < nset; ++is) {
            MarkStyle style = (MarkStyle)data.getSetStyle(is);
            if (style.getLine() != MarkStyle.DOT_TO_DOT) continue;
            Graphics2D lineGraphics = (Graphics2D)g.create();
            lineGraphics.setColor(style.getColor());
            lineGraphics.setStroke(style.getStroke(0, 0));
            lineGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, state.getAntialias() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            int lastxp = 0;
            int lastyp = 0;
            boolean notFirst = false;
            PointSequence pseq = data.getPointSequence();
            while (pseq.next()) {
                double y;
                double x;
                if (!pseq.isIncluded(is) || (point = surface.dataToGraphics(x = (coords = pseq.getPoint())[0], y = coords[1], false)) == null) continue;
                int xp = Math.max(-huge, Math.min(huge, point.x));
                yp = Math.max(-huge, Math.min(huge, point.y));
                if (notFirst) {
                    lineGraphics.drawLine(lastxp, lastyp, xp, yp);
                } else {
                    notFirst = true;
                }
                lastxp = xp;
                lastyp = yp;
            }
            pseq.close();
        }
        XYStats[] statSets = new XYStats[nset];
        for (int is = 0; is < nset; ++is) {
            XYStats stats;
            MarkStyle style = (MarkStyle)data.getSetStyle(is);
            if (style.getLine() != MarkStyle.LINEAR) continue;
            statSets[is] = stats = new XYStats(state.getLogFlags()[0], state.getLogFlags()[1]);
            int maxr = style.getMaximumRadius();
            int maxr2 = maxr * 2;
            PointSequence pseq = data.getPointSequence();
            while (pseq.next()) {
                int xp;
                double y;
                double x;
                if (!pseq.isIncluded(is) || (point = surface.dataToGraphics(x = (coords = pseq.getPoint())[0], y = coords[1], true)) == null || !g.hitClip((xp = point.x) - maxr, (yp = point.y) - maxr, maxr2, maxr2)) continue;
                stats.addPoint(x, y);
            }
            pseq.close();
            Graphics2D g2 = g;
            Object aaHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, state.getAntialias() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            Color color = g2.getColor();
            g2.setColor(style.getColor());
            Stroke stroke = g2.getStroke();
            g2.setStroke(style.getStroke(0, 0));
            double[] ends = stats.linearRegressionLine();
            if (ends != null) {
                Point p1 = surface.dataToGraphics(ends[0], ends[1], false);
                Point p2 = surface.dataToGraphics(ends[2], ends[3], false);
                if (p1 != null && p2 != null) {
                    g2.drawLine(p1.x, p1.y, p2.x, p2.y);
                }
            }
            g2.setStroke(stroke);
            g2.setColor(color);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aaHint);
        }
        this.firePlotChangedLater(new ScatterPlotEvent(this, state, pointCounts[0], pointCounts[1], pointCounts[2], statSets));
    }

    public PointIterator getPlottedPointIterator() {
        return new PlotDataPointIterator(this.getState().getPlotData(), this.getPointPlacer());
    }

    public PointPlacer getPointPlacer() {
        final PlotSurface surface = this.getSurface();
        return new PointPlacer(){

            public Point getXY(double[] coords) {
                return surface.dataToGraphics(coords[0], coords[1], true);
            }
        };
    }

    private static void plotPointsVector(Graphics2D g, PlotData data, PlotSurface surface, DataColorTweaker tweaker, int[] counts) {
        int nset = data.getSetCount();
        MarkStyle[] styles = ScatterPlot.getStyles(data);
        int noff = data.getNerror();
        int[] xoffs = new int[noff];
        int[] yoffs = new int[noff];
        BitSet includedMask = counts == null ? null : new BitSet();
        BitSet visibleMask = counts == null ? null : new BitSet();
        int nPotential = -1;
        for (int is = 0; is < nset; ++is) {
            MarkStyle style = styles[is];
            ErrorRenderer errorRenderer = style.getErrorRenderer();
            boolean showMarks = !style.getHidePoints();
            boolean showErrors = MarkStyle.hasErrors(style, data);
            if (!($assertionsDisabled || showMarks || showErrors)) {
                throw new AssertionError((Object)"Why bother?");
            }
            int maxr = style.getMaximumRadius();
            int maxr2 = maxr * 2;
            PointSequence pseq = data.getPointSequence();
            int ip = 0;
            while (pseq.next()) {
                if (pseq.isIncluded(is)) {
                    double y;
                    double[] coords;
                    double x;
                    Point point;
                    if (counts != null) {
                        includedMask.set(ip);
                    }
                    if ((point = surface.dataToGraphics(x = (coords = pseq.getPoint())[0], y = coords[1], true)) != null && (tweaker == null || tweaker.setCoords(coords))) {
                        double[][] errors;
                        if (counts != null) {
                            visibleMask.set(ip);
                        }
                        int xp = point.x;
                        int yp = point.y;
                        if (showMarks && g.hitClip(xp - maxr, yp - maxr, maxr2, maxr2)) {
                            style.drawMarker(g, xp, yp, tweaker);
                        }
                        if (showErrors && ScatterPlot.transformErrors(point, coords, errors = pseq.getErrors(), surface, xoffs, yoffs)) {
                            style.drawErrors(g, xp, yp, xoffs, yoffs, tweaker);
                        }
                    }
                }
                ++ip;
            }
            pseq.close();
            nPotential = ip;
        }
        if (counts != null) {
            counts[0] = nPotential;
            counts[1] = includedMask.cardinality();
            counts[2] = visibleMask.cardinality();
        }
    }

    private static void plotPointsBitmap(Graphics2D g, PlotData data, PlotSurface surface, int[] counts) {
        int nset = data.getSetCount();
        MarkStyle[] styles = ScatterPlot.getStyles(data);
        boolean[] showPoints = new boolean[nset];
        boolean[] showErrors = new boolean[nset];
        for (int is = 0; is < nset; ++is) {
            showPoints[is] = !styles[is].getHidePoints();
            showErrors[is] = MarkStyle.hasErrors(styles[is], data);
        }
        int maxr = 0;
        for (int is = 0; is < nset; ++is) {
            if (!showPoints[is]) continue;
            maxr = Math.max(styles[is].getMaximumRadius(), maxr);
        }
        int pad = maxr * 2 + 1;
        Rectangle clip = surface.getClip().getBounds();
        int xdim = clip.width + 2 * pad;
        int ydim = clip.height + 2 * pad;
        int xoff = clip.x - pad;
        int yoff = clip.y - pad;
        int npix = xdim * ydim;
        int[][] buffers = new int[nset][];
        int[][] pixoffs = new int[nset][];
        int[] npixoffs = new int[nset];
        for (int is = 0; is < nset; ++is) {
            buffers[is] = new int[npix];
            pixoffs[is] = styles[is].getFlattenedPixelOffsets(xdim);
            npixoffs[is] = pixoffs[is].length;
        }
        Rectangle bufClip = new Rectangle(surface.getClip().getBounds());
        bufClip.x = pad;
        bufClip.y = pad;
        BitSet mask = new BitSet(npix);
        int noff = data.getNerror();
        int[] xoffs = new int[noff];
        int[] yoffs = new int[noff];
        boolean[] showPointMarks = new boolean[nset];
        boolean[] showPointErrors = new boolean[nset];
        int nIncluded = 0;
        int nVisible = 0;
        PointSequence pseq = data.getPointSequence();
        int ip = 0;
        while (pseq.next()) {
            boolean use = false;
            for (int is = 0; is < nset; ++is) {
                boolean included = pseq.isIncluded(is);
                use = use || included;
                showPointMarks[is] = included && showPoints[is];
                showPointErrors[is] = included && showErrors[is];
            }
            if (use) {
                double y;
                ++nIncluded;
                double[] coords = pseq.getPoint();
                double x = coords[0];
                Point point = surface.dataToGraphics(x, y = coords[1], true);
                if (point != null) {
                    int xp = point.x;
                    int yp = point.y;
                    int xbase = xp - xoff;
                    int ybase = yp - yoff;
                    if (xbase > maxr && xbase < xdim - maxr && ybase > maxr && ybase < ydim - maxr) {
                        ++nVisible;
                        int base = xbase + xdim * ybase;
                        for (int is = 0; is < nset; ++is) {
                            double[][] errors;
                            boolean done = false;
                            if (showPointErrors[is] && ScatterPlot.transformErrors(point, coords, errors = pseq.getErrors(), surface, xoffs, yoffs)) {
                                Pixellator pixer;
                                Pixellator epixer = styles[is].getErrorRenderer().getPixels(bufClip, xbase, ybase, xoffs, yoffs);
                                if (showPointMarks[is]) {
                                    TranslatedPixellator mpixer = new TranslatedPixellator(styles[is].getPixelOffsets(), xbase, ybase);
                                    pixer = Drawing.combinePixellators(new Pixellator[]{mpixer, epixer});
                                } else {
                                    pixer = epixer;
                                }
                                pixer.start();
                                while (pixer.next()) {
                                    int ipix = pixer.getX() + pixer.getY() * xdim;
                                    int[] nArray = buffers[is];
                                    int n = ipix;
                                    nArray[n] = nArray[n] + 1;
                                    mask.set(ipix);
                                }
                                done = true;
                            }
                            if (!showPointMarks[is] || done) continue;
                            for (int ioff = 0; ioff < npixoffs[is]; ++ioff) {
                                int ipix = base + pixoffs[is][ioff];
                                int[] nArray = buffers[is];
                                int n = ipix;
                                nArray[n] = nArray[n] + 1;
                                mask.set(ipix);
                            }
                            done = true;
                        }
                    }
                }
            }
            ++ip;
        }
        int nPotential = ip;
        pseq.close();
        if (counts != null) {
            counts[0] = nPotential;
            counts[1] = nIncluded;
            counts[2] = nVisible;
        }
        float[] opacity = new float[nset];
        float[] rCols = new float[nset];
        float[] gCols = new float[nset];
        float[] bCols = new float[nset];
        for (int is = 0; is < nset; ++is) {
            MarkStyle style = styles[is];
            opacity[is] = 1.0f / (float)style.getOpaqueLimit();
            float[] rgb = style.getColor().getRGBColorComponents(null);
            rCols[is] = rgb[0];
            gCols[is] = rgb[1];
            bCols[is] = rgb[2];
        }
        BufferedImage im = new BufferedImage(xdim, ydim, 2);
        ColorModel colorModel = im.getColorModel();
        if (!$assertionsDisabled && !colorModel.equals(ColorModel.getRGBdefault())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && colorModel.isAlphaPremultiplied()) {
            throw new AssertionError();
        }
        int[] rgbBuf = new int[xdim * ydim];
        Arrays.fill(rgbBuf, 0xFFFFFF);
        int ipix = mask.nextSetBit(0);
        while (ipix >= 0) {
            float remain = 1.0f;
            float[] weights = new float[nset];
            for (int is = nset - 1; is >= 0; --is) {
                float weight;
                int count = buffers[is][ipix];
                if (!(remain > 0.0f)) continue;
                weights[is] = weight = Math.min(remain, opacity[is] * (float)count);
                remain -= weight;
            }
            if (remain < 1.0f) {
                float totWeight = 1.0f - remain;
                float[] argb = new float[4];
                argb[3] = totWeight;
                for (int is = 0; is < nset; ++is) {
                    float fw = weights[is] / totWeight;
                    if (!(fw > 0.0f)) continue;
                    argb[0] = argb[0] + fw * rCols[is];
                    argb[1] = argb[1] + fw * gCols[is];
                    argb[2] = argb[2] + fw * bCols[is];
                }
                rgbBuf[ipix] = colorModel.getDataElement(argb, 0);
            }
            ipix = mask.nextSetBit(ipix + 1);
        }
        im.setRGB(0, 0, xdim, ydim, rgbBuf, 0, xdim);
        g.drawImage((Image)im, xoff, yoff, null);
    }

    private static void plotPointsTweakedBitmap(Graphics2D g, PlotData data, PlotSurface surface, DataColorTweaker tweaker, int[] counts) {
        int nset = data.getSetCount();
        MarkStyle[] styles = ScatterPlot.getStyles(data);
        int maxr = 0;
        for (int is = 0; is < nset; ++is) {
            if (styles[is].getHidePoints()) continue;
            maxr = Math.max(styles[is].getMaximumRadius(), maxr);
        }
        int pad = maxr * 2 + 1;
        Rectangle clip = surface.getClip().getBounds();
        int xdim = clip.width + 2 * pad;
        int ydim = clip.height + 2 * pad;
        int xoff = clip.x - pad;
        int yoff = clip.y - pad;
        int npix = xdim * ydim;
        float[][] rgbaBuf = new float[4][npix];
        Rectangle bufClip = new Rectangle(surface.getClip().getBounds());
        bufClip.x = pad;
        bufClip.y = pad;
        BitSet includedMask = counts == null ? null : new BitSet();
        BitSet visibleMask = counts == null ? null : new BitSet();
        BitSet pixelMask = new BitSet();
        int noff = data.getNerror();
        int[] xoffs = new int[noff];
        int[] yoffs = new int[noff];
        float[] rgba = new float[4];
        int nPotential = -1;
        for (int is = nset - 1; is >= 0; --is) {
            MarkStyle style = styles[is];
            ErrorRenderer errorRenderer = style.getErrorRenderer();
            boolean showMarks = !style.getHidePoints();
            boolean showErrors = MarkStyle.hasErrors(style, data);
            Pixellator markPixer = style.getPixelOffsets();
            int[] pixoffs = style.getFlattenedPixelOffsets(xdim);
            int npixoff = pixoffs.length;
            float alpha = 1.0f / (float)style.getOpaqueLimit();
            float[] baseRgba = style.getColor().getRGBComponents(null);
            if (!($assertionsDisabled || showMarks || showErrors)) {
                throw new AssertionError((Object)"Why bother?");
            }
            PointSequence pseq = data.getPointSequence();
            int ip = 0;
            while (pseq.next()) {
                if (pseq.isIncluded(is)) {
                    double y;
                    double[] coords;
                    double x;
                    Point point;
                    if (counts != null) {
                        includedMask.set(ip);
                    }
                    if ((point = surface.dataToGraphics(x = (coords = pseq.getPoint())[0], y = coords[1], true)) != null && (tweaker == null || tweaker.setCoords(coords))) {
                        int xp = point.x;
                        int yp = point.y;
                        int xbase = xp - xoff;
                        int ybase = yp - yoff;
                        if (xbase > maxr && xbase < xdim - maxr && ybase > maxr && ybase < ydim - maxr) {
                            double[][] errors;
                            if (counts != null) {
                                visibleMask.set(ip);
                            }
                            rgba[0] = baseRgba[0];
                            rgba[1] = baseRgba[1];
                            rgba[2] = baseRgba[2];
                            rgba[3] = baseRgba[3];
                            tweaker.tweakColor(rgba);
                            rgba[3] = rgba[3] * alpha;
                            int base = xbase + xdim * ybase;
                            boolean done = false;
                            if (showErrors && ScatterPlot.transformErrors(point, coords, errors = pseq.getErrors(), surface, xoffs, yoffs)) {
                                Pixellator pixer;
                                Pixellator epixer = errorRenderer.getPixels(bufClip, xbase, ybase, xoffs, yoffs);
                                if (showMarks) {
                                    TranslatedPixellator mpixer = new TranslatedPixellator(markPixer, xbase, ybase);
                                    pixer = Drawing.combinePixellators(new Pixellator[]{mpixer, epixer});
                                } else {
                                    pixer = epixer;
                                }
                                pixer.start();
                                while (pixer.next()) {
                                    int ipix = pixer.getX() + pixer.getY() * xdim;
                                    ScatterPlot.paintPixel(rgbaBuf, pixelMask, ipix, rgba);
                                }
                                done = true;
                            }
                            if (showMarks && !done) {
                                for (int ioff = 0; ioff < npixoff; ++ioff) {
                                    int ipix = base + pixoffs[ioff];
                                    ScatterPlot.paintPixel(rgbaBuf, pixelMask, ipix, rgba);
                                }
                                done = true;
                            }
                        }
                    }
                }
                ++ip;
            }
            pseq.close();
            nPotential = ip;
        }
        if (counts != null) {
            counts[0] = nPotential;
            counts[1] = includedMask.cardinality();
            counts[2] = visibleMask.cardinality();
        }
        BufferedImage im = new BufferedImage(xdim, ydim, 2);
        ColorModel colorModel = im.getColorModel();
        if (!$assertionsDisabled && !colorModel.equals(ColorModel.getRGBdefault())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && colorModel.isAlphaPremultiplied()) {
            throw new AssertionError();
        }
        int[] rgbBuf = new int[xdim * ydim];
        Arrays.fill(rgbBuf, 0xFFFF0F);
        int ipix = pixelMask.nextSetBit(0);
        while (ipix >= 0) {
            float weight = rgbaBuf[3][ipix];
            float w1 = 1.0f / weight;
            rgba[0] = rgbaBuf[0][ipix] * w1;
            rgba[1] = rgbaBuf[1][ipix] * w1;
            rgba[2] = rgbaBuf[2][ipix] * w1;
            rgba[3] = weight;
            rgbBuf[ipix] = colorModel.getDataElement(rgba, 0);
            ipix = pixelMask.nextSetBit(ipix + 1);
        }
        im.setRGB(0, 0, xdim, ydim, rgbBuf, 0, xdim);
        g.drawImage((Image)im, xoff, yoff, null);
    }

    private static void paintPixel(float[][] rgbaBuf, BitSet mask, int ipix, float[] rgba) {
        float used = rgbaBuf[3][ipix];
        if (used < 1.0f) {
            mask.set(ipix);
            float weight = Math.min(1.0f - used, rgba[3]);
            float[] fArray = rgbaBuf[0];
            int n = ipix;
            fArray[n] = fArray[n] + weight * rgba[0];
            float[] fArray2 = rgbaBuf[1];
            int n2 = ipix;
            fArray2[n2] = fArray2[n2] + weight * rgba[1];
            float[] fArray3 = rgbaBuf[2];
            int n3 = ipix;
            fArray3[n3] = fArray3[n3] + weight * rgba[2];
            float[] fArray4 = rgbaBuf[3];
            int n4 = ipix;
            fArray4[n4] = fArray4[n4] + weight;
        }
    }

    public static boolean transformErrors(Point point, double[] centre, double[][] errors, PlotSurface surface, int[] xoffs, int[] yoffs) {
        int noff = xoffs.length;
        if (!$assertionsDisabled && noff != yoffs.length) {
            throw new AssertionError();
        }
        for (int ioff = 0; ioff < noff; ++ioff) {
            xoffs[ioff] = 0;
            yoffs[ioff] = 0;
        }
        boolean hasError = false;
        int px = point.x;
        int py = point.y;
        double cx = centre[0];
        double cy = centre[1];
        int ioff = 0;
        int nerrDim = errors.length / 2;
        for (int ied = 0; ied < nerrDim; ++ied) {
            Point phi;
            int yo;
            int xo;
            Point plo;
            double[] lo = errors[ied * 2 + 0];
            double[] hi = errors[ied * 2 + 1];
            if (lo != null && (plo = surface.dataToGraphics(lo[0], lo[1], false)) != null) {
                xo = plo.x - px;
                yo = plo.y - py;
                if (xo != 0 || yo != 0) {
                    xoffs[ioff] = xo;
                    yoffs[ioff] = yo;
                    hasError = true;
                }
            }
            ++ioff;
            if (hi != null && (phi = surface.dataToGraphics(hi[0], hi[1], false)) != null) {
                xo = phi.x - px;
                yo = phi.y - py;
                if (xo != 0 || yo != 0) {
                    xoffs[ioff] = xo;
                    yoffs[ioff] = yo;
                    hasError = true;
                }
            }
            ++ioff;
        }
        return hasError;
    }

    private static MarkStyle[] getStyles(PlotData data) {
        int nset = data.getSetCount();
        MarkStyle[] styles = new MarkStyle[nset];
        for (int is = 0; is < nset; ++is) {
            styles[is] = (MarkStyle)data.getSetStyle(is);
        }
        return styles;
    }

    static {
        $assertionsDisabled = !ScatterPlot.class.desiredAssertionStatus();
        logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot");
    }

    private class ScatterDataPanel
    extends JComponent {
        static final /* synthetic */ boolean $assertionsDisabled;

        ScatterDataPanel() {
            this.setOpaque(false);
        }

        protected void paintComponent(Graphics g) {
            if (this.isOpaque()) {
                Color color = g.getColor();
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(color);
            }
            int width = this.getBounds().width;
            int height = this.getBounds().height;
            if (ScatterPlot.this.getState() == ScatterPlot.this.lastState_ && ScatterPlot.this.getSurface() == ScatterPlot.this.lastSurface_ && width == ScatterPlot.this.lastWidth_ && height == ScatterPlot.this.lastHeight_) {
                if (!$assertionsDisabled && ScatterPlot.this.image_ == null) {
                    throw new AssertionError();
                }
            } else {
                long start = System.currentTimeMillis();
                ScatterPlot.this.image_ = this.createImage(width, height);
                Graphics ig = ScatterPlot.this.image_.getGraphics();
                ScatterPlot.this.getSurface().paintSurface(ig);
                ScatterPlot.this.drawData(ig, true);
                ScatterPlot.this.lastState_ = ScatterPlot.this.getState();
                ScatterPlot.this.lastSurface_ = ScatterPlot.this.getSurface();
                ScatterPlot.this.lastWidth_ = width;
                ScatterPlot.this.lastHeight_ = height;
                logger_.info("Repaint scatter plot: " + (System.currentTimeMillis() - start) + "ms");
            }
            boolean done = g.drawImage(ScatterPlot.this.image_, 0, 0, null);
            if (!$assertionsDisabled && !done) {
                throw new AssertionError();
            }
        }

        protected void printComponent(Graphics g) {
            PlotState state = ScatterPlot.this.getState();
            if (state != null && state.getPlotData() != null) {
                PlotData data = state.getPlotData();
                MarkStyle[] styles = ScatterPlot.getStyles(data);
                boolean isVector = TablePlot.isVectorContext(g);
                boolean hasTransparent = false;
                for (int is = 0; is < styles.length; ++is) {
                    if (styles[is].getOpaqueLimit() == 1) continue;
                    hasTransparent = true;
                }
                Shader[] shaders = state.getShaders();
                for (int iaux = 0; iaux < shaders.length; ++iaux) {
                    if (!Shaders.isTransparent(shaders[iaux])) continue;
                    hasTransparent = true;
                }
                if (hasTransparent || !isVector) {
                    if (isVector) {
                        logger_.warning("Using bitmapped postscript output, necessary to retain pixel transparency");
                    }
                    int w = this.getWidth();
                    int h = this.getHeight();
                    BufferedImage im = new BufferedImage(w, h, 2);
                    Graphics2D gim = im.createGraphics();
                    Color imColor = gim.getColor();
                    Composite imComposite = gim.getComposite();
                    gim.setColor(new Color(0xFFFFFF, true));
                    gim.setComposite(AlphaComposite.Src);
                    gim.fillRect(0, 0, w, h);
                    gim.setComposite(imComposite);
                    gim.setColor(imColor);
                    ScatterPlot.this.getSurface().paintSurface(gim);
                    ScatterPlot.this.drawData(gim, true);
                    gim.dispose();
                    Rectangle clip = ScatterPlot.this.getSurface().getClip().getBounds();
                    int cx = clip.x - 2;
                    int cy = clip.y - 2;
                    int cw = clip.width + 4;
                    int ch = clip.height + 4;
                    BufferedImage clipIm = im.getSubimage(cx, cy, cw, ch);
                    g.drawImage(clipIm, cx, cy, null);
                } else {
                    ScatterPlot.this.drawData(g, false);
                }
            }
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$ttools$plot$ScatterPlot == null ? (class$uk$ac$starlink$ttools$plot$ScatterPlot = ScatterPlot.class$("uk.ac.starlink.ttools.plot.ScatterPlot")) : class$uk$ac$starlink$ttools$plot$ScatterPlot).desiredAssertionStatus();
        }
    }
}

