/*
 * Decompiled with CFR 0.152.
 */
package jsky.science;

public class MrqFit {
    private static final int _MMA = 16;
    static float[] atry = new float[16];
    static double[] da = new double[16];
    static double[] oneda = new double[16];
    static double[] beta = new double[16];
    static double[] cv = new double[256];
    static double ochisq;

    public static int mrqmin(int ndata, float[] a, int ma, int[] lista, int mfit, double[] covar, double[] alpha, double[] chisq, MrqFunc funcs, double[] alamda) {
        int k;
        int j;
        if (alamda[0] < 0.0) {
            if (16 < ma || ma < mfit) {
                return -3;
            }
            int kk = mfit;
            for (j = 0; j < ma; ++j) {
                int ihit = 0;
                for (k = 0; k < mfit; ++k) {
                    if (lista[k] != j) continue;
                    ++ihit;
                }
                if (ihit == 0) {
                    lista[kk++] = j;
                    continue;
                }
                if (ihit <= true) continue;
                return -1;
            }
            if (kk != ma) {
                return -2;
            }
            alamda[0] = 0.001;
            MrqFit._mrqcof(ndata, a, ma, lista, mfit, alpha, beta, chisq, funcs);
            if (chisq[0] <= 0.0) {
                return -4;
            }
            ochisq = chisq[0];
        }
        for (j = 0; j < mfit; ++j) {
            for (k = 0; k < mfit; ++k) {
                double d = alpha[j + k * ma];
                MrqFit.cv[j + k * mfit] = d;
                covar[j + k * ma] = d;
            }
            double d = alpha[j + j * ma] * (1.0 + alamda[0]);
            MrqFit.cv[j + j * mfit] = d;
            covar[j + j * ma] = d;
            MrqFit.oneda[j] = beta[j];
        }
        if (MrqFit._gaussj(cv, mfit, oneda, 1) != 0) {
            return -5;
        }
        for (j = 0; j < mfit; ++j) {
            MrqFit.da[j] = oneda[j];
        }
        if (alamda[0] == 0.0) {
            for (j = 0; j < mfit; ++j) {
                for (k = 0; k < mfit; ++k) {
                    covar[j + k * ma] = cv[j + k * mfit];
                }
            }
            MrqFit._covsrt(covar, ma, lista, mfit);
            return 0;
        }
        for (j = 0; j < ma; ++j) {
            MrqFit.atry[j] = a[j];
        }
        for (j = 0; j < mfit; ++j) {
            MrqFit.atry[lista[j]] = (float)((double)a[lista[j]] + da[j]);
        }
        MrqFit._mrqcof(ndata, atry, ma, lista, mfit, covar, da, chisq, funcs);
        if (0.0 < chisq[0] && chisq[0] < ochisq) {
            alamda[0] = alamda[0] * 0.1;
            ochisq = chisq[0];
            for (j = 0; j < mfit; ++j) {
                for (k = 0; k < mfit; ++k) {
                    alpha[j + k * ma] = covar[j + k * ma];
                }
                MrqFit.beta[j] = da[j];
                a[lista[j]] = atry[lista[j]];
            }
        } else {
            alamda[0] = alamda[0] * 10.0;
            chisq[0] = ochisq;
        }
        return 0;
    }

    private static void _mrqcof(int ndata, float[] a, int ma, int[] lista, int mfit, double[] alpha, double[] veta, double[] chisq, MrqFunc funcs) {
        int k;
        int j;
        float[] y = new float[1];
        float[] ymod = new float[1];
        float[] sig2i = new float[1];
        float[] dyda = new float[16];
        for (j = 0; j < mfit; ++j) {
            for (k = 0; k <= j; ++k) {
                alpha[j + k * ma] = 0.0;
            }
            veta[j] = 0.0;
        }
        chisq[0] = 0.0;
        for (int i = 0; i < ndata; ++i) {
            if (funcs.mrqFunc(i, y, ymod, sig2i, a, dyda, ma) != 0) continue;
            float dy = y[0] - ymod[0];
            j = 0;
            while (j < mfit) {
                float wt = dyda[lista[j]] * sig2i[0];
                for (k = 0; k <= j; ++k) {
                    int n = j + k * ma;
                    alpha[n] = alpha[n] + (double)(wt * dyda[lista[k]]);
                }
                int n = j++;
                veta[n] = veta[n] + (double)(dy * wt);
            }
            chisq[0] = chisq[0] + (double)(dy * dy * sig2i[0]);
        }
        for (j = 1; j < mfit; ++j) {
            for (k = 0; k < j; ++k) {
                alpha[k + j * ma] = alpha[j + k * ma];
            }
        }
    }

    private static void _covsrt(double[] covar, int ma, int[] lista, int mfit) {
        int i;
        int j;
        for (j = 0; j < ma - 1; ++j) {
            for (i = j + 1; i < ma; ++i) {
                covar[i + j * ma] = 0.0;
            }
        }
        for (i = 0; i < mfit - 1; ++i) {
            for (j = i + 1; j < mfit; ++j) {
                if (lista[j] > lista[i]) {
                    covar[lista[j] + lista[i] * ma] = covar[i + j * ma];
                    continue;
                }
                covar[lista[i] + lista[j] * ma] = covar[i + j * ma];
            }
        }
        double swap = covar[0];
        for (j = 0; j < ma; ++j) {
            covar[j * ma] = covar[j + j * ma];
            covar[j + j * ma] = 0.0;
        }
        covar[lista[0] + lista[0] * ma] = swap;
        for (j = 1; j < mfit; ++j) {
            covar[lista[j] + lista[j] * ma] = covar[j * ma];
        }
        for (j = 1; j < ma; ++j) {
            for (i = 0; i < j; ++i) {
                covar[i + j * ma] = covar[j + i * ma];
            }
        }
    }

    private static void _swap(double[] ar, int a, int b) {
        double temp = ar[a];
        ar[a] = ar[b];
        ar[b] = temp;
    }

    private static int _gaussj(double[] a, int n, double[] b, int m) {
        int l;
        int k;
        int j;
        int icol = 0;
        int irow = 0;
        int[] indxc = new int[16];
        int[] indxr = new int[16];
        int[] ipiv = new int[16];
        if (16 < n) {
            return -3;
        }
        for (j = 0; j < n; ++j) {
            ipiv[j] = 0;
        }
        for (int i = 0; i < n; ++i) {
            double dum;
            double big = 0.0;
            for (j = 0; j < n; ++j) {
                if (ipiv[j] == 1) continue;
                for (k = 0; k < n; ++k) {
                    if (ipiv[k] == 0) {
                        dum = Math.abs(a[j + k * n]);
                        if (!(dum >= big)) continue;
                        big = dum;
                        irow = j;
                        icol = k;
                        continue;
                    }
                    if (ipiv[k] <= 1) continue;
                    return -1;
                }
            }
            int n2 = icol;
            ipiv[n2] = ipiv[n2] + 1;
            if (irow != icol) {
                for (l = 0; l < n; ++l) {
                    MrqFit._swap(a, irow + l * n, icol + l * n);
                }
                for (l = 0; l < m; ++l) {
                    MrqFit._swap(b, irow + l * n, icol + l * n);
                }
            }
            indxr[i] = irow;
            indxc[i] = icol;
            if (a[icol + icol * n] == 0.0) {
                return -2;
            }
            double pivinv = 1.0 / a[icol + icol * n];
            a[icol + icol * n] = 1.0;
            for (l = 0; l < n; ++l) {
                int n3 = icol + l * n;
                a[n3] = a[n3] * pivinv;
            }
            for (l = 0; l < m; ++l) {
                int n4 = icol + l * n;
                b[n4] = b[n4] * pivinv;
            }
            for (int ll = 0; ll < n; ++ll) {
                if (ll == icol) continue;
                dum = a[ll + icol * n];
                a[ll + icol * n] = 0.0;
                for (l = 0; l < n; ++l) {
                    int n5 = ll + l * n;
                    a[n5] = a[n5] - a[icol + l * n] * dum;
                }
                for (l = 0; l < m; ++l) {
                    int n6 = ll + l * n;
                    b[n6] = b[n6] - b[icol + l * n] * dum;
                }
            }
        }
        for (l = n - 1; l >= 0; --l) {
            if (indxr[l] == indxc[l]) continue;
            for (k = 0; k < n; ++k) {
                MrqFit._swap(a, k + indxr[l] * n, k + indxc[l] * n);
            }
        }
        return 0;
    }

    public static interface MrqFunc {
        public int mrqFunc(int var1, float[] var2, float[] var3, float[] var4, float[] var5, float[] var6, int var7);
    }
}

