/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.jdbc;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RandomStarTable;
import uk.ac.starlink.table.jdbc.StarResultSet;

public class RandomResultSetStarTable
extends RandomStarTable {
    private final StarResultSet srset_;

    public RandomResultSetStarTable(ResultSet rset) throws SQLException {
        this(new StarResultSet(rset));
    }

    RandomResultSetStarTable(StarResultSet srset) {
        if (!srset.isRandom()) {
            throw new IllegalArgumentException("ResultSet does not provide random access (wrong type)");
        }
        this.srset_ = srset;
    }

    public ResultSet getResultSet() {
        return this.srset_.getResultSet();
    }

    public int getColumnCount() {
        return this.srset_.getColumnInfos().length;
    }

    public ColumnInfo getColumnInfo(int icol) {
        return this.srset_.getColumnInfos()[icol];
    }

    public long getRowCount() {
        return this.srset_.getRowCount();
    }

    public List getColumnAuxDataInfos() {
        RandomResultSetStarTable randomResultSetStarTable = this;
        return randomResultSetStarTable.srset_.getColumnAuxDataInfos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCell(long lrow, int icol) throws IOException {
        StarResultSet starResultSet = this.srset_;
        synchronized (starResultSet) {
            this.srset_.setRowIndex(lrow);
            return this.srset_.getCell(icol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getRow(long lrow) throws IOException {
        StarResultSet starResultSet = this.srset_;
        synchronized (starResultSet) {
            this.srset_.setRowIndex(lrow);
            return this.srset_.getRow();
        }
    }
}

