/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry;

import skyview.Component;
import skyview.geometry.Rotater;
import skyview.geometry.SphereDistorter;
import skyview.geometry.csys.Besselian;
import skyview.geometry.csys.Ecliptic;
import skyview.geometry.csys.Galactic;
import skyview.geometry.csys.Helioecliptic;
import skyview.geometry.csys.ICRS;
import skyview.geometry.csys.Julian;

public abstract class CoordinateSystem
implements Component {
    public static final CoordinateSystem J2000 = new Julian(2000.0);
    public static final CoordinateSystem B1950 = new Besselian(1950.0);
    public static final CoordinateSystem Gal = new Galactic();
    public static final CoordinateSystem ICRS = new ICRS();

    public abstract Rotater getRotater();

    public SphereDistorter getSphereDistorter() {
        return null;
    }

    public static CoordinateSystem factory(String name) {
        return CoordinateSystem.factory(name, null);
    }

    public static CoordinateSystem factory(String name, String equinox) {
        if ((name = name.toUpperCase()).equals("ICRS")) {
            return ICRS;
        }
        char c = name.charAt(0);
        if (c == 'G') {
            return Gal;
        }
        String sepoch = name.substring(1);
        double epoch = -1.0;
        try {
            epoch = Double.parseDouble(name.substring(1));
        }
        catch (Exception e) {
            try {
                if (equinox != null) {
                    epoch = Double.parseDouble(equinox);
                }
            }
            catch (Exception f) {
                // empty catch block
            }
        }
        switch (c) {
            case 'J': {
                if (epoch < 0.0) {
                    epoch = 2000.0;
                }
                return new Julian(epoch);
            }
            case 'B': {
                if (epoch < 0.0) {
                    epoch = 1950.0;
                }
                return new Besselian(epoch);
            }
            case 'E': {
                return new Ecliptic(epoch);
            }
            case 'H': {
                return new Helioecliptic(epoch);
            }
        }
        return null;
    }
}

