/*
 * Decompiled with CFR 0.152.
 */
package skyview.process.deedger;

import java.util.Arrays;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import skyview.geometry.DepthSampler;
import skyview.geometry.Sampler;
import skyview.process.Processor;
import skyview.survey.Image;

public class BoundaryAverage
implements Processor {
    double[][] deltas;
    int[][] counts;
    int totalCount;
    int nImage;
    Image[] inputs;
    Image output;
    int[] source;
    int nx;
    int ny;
    double[] offsets;

    @Override
    public String getName() {
        return "Boundary Average Deedger:";
    }

    @Override
    public String getDescription() {
        return "Hide borders between input images by making the average shift across boundaries 0.";
    }

    @Override
    public void process(Image[] inputs, Image output, int[] source, Sampler samp, DepthSampler dsamp) {
        if (output == null) {
            return;
        }
        int nImage = inputs.length;
        this.deltas = new double[nImage][nImage];
        this.counts = new int[nImage][nImage];
        this.nImage = nImage;
        this.source = source;
        this.inputs = inputs;
        this.output = output;
        this.ny = output.getHeight();
        this.nx = output.getWidth();
        this.deedge();
    }

    private void deedge() {
        int i;
        int t1;
        int t0;
        int j;
        int i2;
        this.totalCount = 0;
        for (i2 = 0; i2 < this.ny - 1; ++i2) {
            for (j = 0; j < this.nx; ++j) {
                t0 = j + i2 * this.nx;
                t1 = t0 + this.nx;
                this.check(t0, t1);
            }
        }
        for (i2 = 0; i2 < this.ny; ++i2) {
            for (j = 0; j < this.nx - 1; ++j) {
                t0 = j + i2 * this.nx;
                t1 = t0 + 1;
                this.check(t0, t1);
            }
        }
        if (this.totalCount == 0) {
            return;
        }
        int[] tc = new int[this.nImage];
        for (int i3 = 0; i3 < this.source.length; ++i3) {
            if (this.source[i3] < 0) continue;
            int n = this.source[i3];
            tc[n] = tc[n] + 1;
        }
        int maxInd = 0;
        for (int i4 = 1; i4 < this.nImage; ++i4) {
            if (tc[i4] <= tc[maxInd]) continue;
            maxInd = i4;
        }
        this.offsets = new double[this.nImage];
        Arrays.fill(this.offsets, Double.NaN);
        this.offsets[maxInd] = 0.0;
        while (true) {
            int maxI = -1;
            int maxJ = -1;
            int cCount = 0;
            for (int i5 = 0; i5 < this.nImage; ++i5) {
                if (Double.isNaN(this.offsets[i5])) continue;
                for (int j2 = 0; j2 < this.nImage; ++j2) {
                    if (!Double.isNaN(this.offsets[j2]) || this.counts[i5][j2] <= cCount) continue;
                    cCount = this.counts[i5][j2];
                    maxI = i5;
                    maxJ = j2;
                }
            }
            if (maxI < 0 || cCount < 10) break;
            double xOffset = this.deltas[maxI][maxJ];
            this.offsets[maxJ] = this.offsets[maxI] - xOffset / (double)this.counts[maxI][maxJ];
        }
        int xccc = 0;
        for (i = 0; i < this.nImage; ++i) {
            if (!Double.isNaN(this.offsets[i])) continue;
            this.offsets[i] = 0.0;
        }
        for (i = 0; i < this.nx * this.ny; ++i) {
            double offset = this.offsets[this.source[i]];
            if (!(offset >= 0.0)) continue;
            this.output.setData(i, this.output.getData(i) + offset);
            ++xccc;
        }
    }

    private void check(int t0, int t1) {
        int s0 = this.source[t0];
        int s1 = this.source[t1];
        if (s0 >= 0 && s1 >= 0 && s0 != s1) {
            ++this.totalCount;
            double v0 = this.output.getData(t0);
            double v1 = this.output.getData(t1);
            double[] dArray = this.deltas[s0];
            int n = s1;
            dArray[n] = dArray[n] + (v1 - v0);
            double[] dArray2 = this.deltas[s1];
            int n2 = s0;
            dArray2[n2] = dArray2[n2] + (v0 - v1);
            int[] nArray = this.counts[s0];
            int n3 = s1;
            nArray[n3] = nArray[n3] + 1;
            int[] nArray2 = this.counts[s1];
            int n4 = s0;
            nArray2[n4] = nArray2[n4] + 1;
        }
    }

    @Override
    public void updateHeader(Header h) {
        try {
            boolean first = true;
            if (this.offsets == null) {
                return;
            }
            for (int i = 0; i < this.nImage; ++i) {
                String cfile;
                if (this.offsets[i] == 0.0) continue;
                if (first) {
                    h.insertHistory("");
                    h.insertHistory("Edge adjustments applied (skyview.geometry.Deedger");
                    h.insertHistory("");
                    first = false;
                }
                if ((cfile = this.inputs[i].getName()).lastIndexOf(47) > 0) {
                    cfile = cfile.substring(cfile.lastIndexOf(47) + 1);
                }
                h.insertHistory("     Image " + cfile + " offset by " + this.offsets[i]);
            }
            if (!first) {
                h.insertHistory("");
            }
        }
        catch (FitsException e) {
            System.err.println("Error updating header:" + e);
        }
    }
}

