/*
 * Decompiled with CFR 0.152.
 */
package skyview.request;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nom.tam.fits.Header;
import skyview.executive.Settings;
import skyview.geometry.DepthSampler;
import skyview.geometry.Sampler;
import skyview.process.Processor;
import skyview.request.SettingsMatcher;
import skyview.survey.Image;
import skyview.survey.Util;

public class HTMLWriter
implements Processor {
    @Override
    public void process(Image[] inputs, Image output, int[] sources, Sampler samp, DepthSampler dpSamp) {
        if (output == null) {
            System.out.println("<h2> Error processing survey: " + Settings.get("name") + "</h2><p>" + "Error: " + Settings.get("ErrorMsg") + "<p><p>");
        } else {
            this.updateSettings(output, samp);
            this.setSettings();
            this.printoutTemplate("SurveyTemplate");
            if (Settings.has("onlinetext")) {
                String text = Settings.get("onlinetext");
                if (text.length() > 0) {
                    text = SettingsMatcher.replaceSettings(text);
                }
                System.out.print(text);
            }
        }
    }

    @Override
    public void updateHeader(Header hdr) {
    }

    protected void setSettings() {
        int index = 0;
        try {
            index = Integer.parseInt(Settings.get("_surveycount"));
        }
        catch (Exception e) {
            // empty catch block
        }
        System.out.println("<script language='javascript'>");
        System.out.println("x = new Object()");
        System.out.println("surveySettings[" + index + "] = x");
        Object[] keys = Settings.getKeys();
        Arrays.sort(keys);
        for (Object key : keys) {
            String val = Settings.get((String)key);
            if (val == null) continue;
            val = val.replaceAll("'", "");
            val = val.replaceAll("\n", " ");
            System.out.println("x['" + (String)key + "']='" + val + "'");
        }
        System.out.println("</script>");
    }

    @Override
    public String getName() {
        return "HTMLWriter";
    }

    @Override
    public String getDescription() {
        return "Writes HTML wrappers for generated images.";
    }

    public void writeHeader() {
        System.out.println("Content-type: text/html\n");
        this.printoutTemplate("HeaderTemplate");
    }

    public void writeFooter() {
        this.printoutTemplate("FooterTemplate");
    }

    protected void printoutTemplate(String fileSetting) {
        String content;
        String file = Settings.get(fileSetting);
        if (file != null && (content = HTMLWriter.slurp(file)) != null && (content = SettingsMatcher.replaceSettings(content)) != null) {
            System.out.print(content);
        }
    }

    public static String slurp(String file) {
        try {
            String line;
            BufferedReader bf = new BufferedReader(new InputStreamReader(Util.getResourceOrFile(file)));
            StringWriter sw = new StringWriter();
            while ((line = bf.readLine()) != null) {
                sw.write(line);
                sw.write("\n");
            }
            sw.close();
            bf.close();
            return sw.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void updateSettings(Image output, Sampler samp) {
        String webpath;
        String fullpath;
        String format;
        double[] data = output.getDataArray();
        double min = data[0];
        double max = data[0];
        for (double d : data) {
            if (d < min) {
                min = d;
                continue;
            }
            if (!(d > max)) continue;
            max = d;
        }
        Settings.put("_ImageMin", "" + min);
        Settings.put("_ImageMax", "" + max);
        Settings.put("_ImageXPixel", "" + output.getWidth());
        Settings.put("_ImageYPixel", "" + output.getHeight());
        String[] sizes = Settings.getArray("size");
        Settings.put("_ImageXSize", sizes[0]);
        Settings.put("_ImageYSize", sizes[1]);
        if (Settings.get("position") == null) {
            Settings.put("position", Settings.get("lon") + "," + Settings.get("lat"));
        } else if (Settings.has("ReqXPos") && Settings.has("ReqYPos")) {
            Pattern pattern = Pattern.compile(Settings.get("ReqXPos") + "\\s*,?\\s*" + Settings.get("ReqYPos"));
            Matcher matcher = pattern.matcher(Settings.get("position"));
            boolean found = false;
            while (matcher.find()) {
                found = true;
            }
            if (!found) {
                Settings.put("requested_coords", Settings.get("ReqXPos") + ", " + Settings.get("ReqYPos"));
            }
        }
        if (Settings.get("scaling") == null) {
            Settings.put("scaling", "Log");
        }
        if ((format = Settings.get("quicklook").toLowerCase()).equals("jpeg")) {
            format = "jpg";
        }
        String imagepath = Settings.get("output") + "." + format;
        String fitspath = Settings.get("output");
        String catpath = Settings.get("catalogFile");
        if (Settings.has("_meta_copyright")) {
            String copyright = Settings.get("_meta_copyright");
            copyright = copyright.replace("\n", " ");
            copyright = copyright.replace("'", "\"");
            Settings.put("_meta_copyright", copyright);
        }
        if (Settings.has("_meta_provenance")) {
            String provenance = Settings.get("_meta_provenance");
            provenance = provenance.replace("\n", " ");
            provenance = provenance.replace("'", "\"");
            Settings.put("_meta_provenance", provenance);
        }
        if (Settings.has("webrootpath") && (fullpath = fitspath).startsWith(webpath = Settings.get("webrootpath"))) {
            fitspath = fullpath.substring(webpath.length(), fullpath.length());
            if (!fitspath.startsWith("/")) {
                fitspath = "/" + fitspath;
            }
            if (!(imagepath = fullpath.substring(webpath.length(), fullpath.length()) + "." + format).startsWith("/")) {
                imagepath = "/" + imagepath;
            }
            if (catpath != null && !(catpath = catpath.substring(webpath.length(), catpath.length())).startsWith("/")) {
                catpath = "/" + catpath;
            }
        }
        Settings.put("_output_ql", imagepath);
        Settings.put("_output", fitspath);
        Settings.put("_catalogFile", catpath);
        if (Settings.has("lutcbarpath") && Settings.has("lut")) {
            File fil = new File(Settings.get("lut"));
            String path = fil.getName();
            int off = path.indexOf(46);
            if (off < 0 && path.length() > 0) {
                off = path.length();
            }
            if (off >= 0) {
                path = path.substring(0, off);
                path = path.replace("-", "");
                path = path.replace(" ", "");
                if (Settings.has("invert") && Settings.get("invert").equals("on")) {
                    path = path + "_inv";
                }
                Settings.put("_ctnumb", Settings.get("lutcbarpath") + "/" + path.toLowerCase());
            }
        }
        Settings.put("_CoordinateSystem", output.getWCS().getCoordinateSystem().getName());
        Settings.put("_Projection", output.getWCS().getProjection().getProjecter().getName());
        Settings.put("_Sampler", samp.getName());
    }
}

