/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.component.client;

import alma.acs.component.client.ManagerClient;
import alma.acs.concurrent.DaemonThreadFactory;
import alma.acs.container.AcsManagerProxy;
import alma.acs.container.CleaningDaemonThreadFactory;
import alma.acs.container.ContainerServices;
import alma.acs.container.ContainerServicesBase;
import alma.acs.container.ContainerServicesImpl;
import alma.acs.container.corba.AcsCorba;
import alma.acs.logging.AcsLogger;
import alma.acs.logging.ClientLogManager;
import alma.acs.shutdown.ShutdownHookBase;
import alma.alarmsystem.source.ACSAlarmSystemInterfaceFactory;
import com.cosylab.CDB.DAL;
import com.cosylab.CDB.DALHelper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import si.ijs.maci.Client;

public class ComponentClient {
    private ContainerServicesImpl m_containerServices;
    private CleaningDaemonThreadFactory m_threadFactory;
    protected final AcsLogger m_logger;
    final String m_clientName;
    private Client m_managerClient;
    AcsManagerProxy m_acsManagerProxy;
    final AcsCorba acsCorba;
    final boolean ownAcsCorba;
    protected ShutdownHookBase m_shutdownHook;
    private final AtomicBoolean m_shuttingDown = new AtomicBoolean(false);

    public ComponentClient(Logger logger, String managerLoc, String clientName) throws Exception {
        this(logger, managerLoc, clientName, null);
    }

    protected ComponentClient(Logger logger, String managerLoc, String clientName, AcsCorba externalAcsCorba) throws Exception {
        this.m_logger = logger == null ? ClientLogManager.getAcsLogManager().getLoggerForApplication(clientName, true) : AcsLogger.fromJdkLogger((Logger)logger, null);
        this.m_clientName = clientName;
        POA myPOA = null;
        if (externalAcsCorba == null) {
            try {
                this.acsCorba = new AcsCorba(this.m_logger);
                myPOA = this.acsCorba.initCorbaForClient(false);
                this.ownAcsCorba = true;
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Class '" + ComponentClient.class.getName() + "' can only be used as a singleton and outside of ACS containers. " + e.getMessage());
            }
        } else {
            this.acsCorba = externalAcsCorba;
            myPOA = this.acsCorba.getRootPOA();
            this.ownAcsCorba = false;
        }
        this.initAcs(managerLoc, myPOA);
        if (this.ownAcsCorba) {
            this.initRemoteLogging();
        }
        this.registerShutdownHook();
        this.m_logger.fine("ready to talk with components!");
    }

    protected void registerShutdownHook() {
        this.m_shutdownHook = new ShutdownHookBase((Logger)this.m_logger, "ClientVM"){

            protected void interruptDetected() {
                try {
                    ComponentClient.this.m_logger.severe("*** process is exiting without releasing ACS client - will tearDown() it ***");
                    ComponentClient.this.tearDown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                System.err.println("*** emergency shutdown complete, will exit... ***");
            }

            protected void regularTermination() {
            }
        };
        Runtime.getRuntime().addShutdownHook((Thread)this.m_shutdownHook);
    }

    private void initAcs(String managerLoc, POA rootPOA) throws Exception {
        try {
            ManagerClient clImpl = new ManagerClient(this.m_clientName, (Logger)this.m_logger){

                @Override
                public void disconnect() {
                    ComponentClient.this.m_logger.info("disconnected from manager");
                    ComponentClient.this.m_acsManagerProxy.logoutFromManager();
                    ComponentClient.this.m_acsManagerProxy = null;
                    throw new RuntimeException("disconnected from the manager");
                }
            };
            this.m_managerClient = clImpl._this(this.acsCorba.getORB());
            this.m_acsManagerProxy = new AcsManagerProxy(managerLoc, this.acsCorba.getORB(), (Logger)this.m_logger);
            this.m_acsManagerProxy.loginToManager(this.m_managerClient, 1);
            DAL cdb = DALHelper.narrow((Object)this.m_acsManagerProxy.get_service("CDB", false));
            this.m_threadFactory = new CleaningDaemonThreadFactory(this.m_clientName, (Logger)this.m_logger);
            this.m_containerServices = new ContainerServicesImpl(this.m_acsManagerProxy, cdb, rootPOA, this.acsCorba, this.m_logger, 0, this.m_clientName, null, this.m_threadFactory);
            clImpl.setContainerServices(this.m_containerServices);
            this.initAlarmSystem();
        }
        catch (Exception ex) {
            if (this.acsCorba.getORB() != null) {
                this.acsCorba.getORB().destroy();
            }
            throw ex;
        }
    }

    protected void initAlarmSystem() throws Exception {
        try {
            ACSAlarmSystemInterfaceFactory.init((ContainerServicesBase)this.m_containerServices);
        }
        catch (Throwable thr) {
            throw new Exception("Error initializing the alarm system factory", thr);
        }
    }

    protected void tearDownAlarmSystem() {
        ACSAlarmSystemInterfaceFactory.done();
    }

    public void initRemoteLogging() {
        Runnable cmd = new Runnable(){

            @Override
            public void run() {
                boolean gotLogService = false;
                try {
                    gotLogService = ClientLogManager.getAcsLogManager().initRemoteLogging(ComponentClient.this.acsCorba.getORB(), ComponentClient.this.m_acsManagerProxy.getManager(), ComponentClient.this.m_acsManagerProxy.getManagerHandle(), true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!gotLogService) {
                    ComponentClient.this.m_logger.log(Level.WARNING, "ACS central logging not available!");
                    ClientLogManager.getAcsLogManager().suppressRemoteLogging();
                }
            }
        };
        ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)new DaemonThreadFactory("InitRemoteLogging"));
        executor.execute(cmd);
    }

    public ContainerServices getContainerServices() {
        return this.m_containerServices;
    }

    public void tearDown() throws Exception {
        if (this.m_shuttingDown.getAndSet(true)) {
            this.m_logger.fine("duplicate call to tearDown() will be ignored");
            return;
        }
        this.m_logger.fine("will disconnect ACS stuff...");
        try {
            this.m_acsManagerProxy.shutdownNotify();
            this.m_containerServices.releaseAllComponents();
            this.tearDownAlarmSystem();
            this.m_containerServices.cleanUp();
            this.m_acsManagerProxy.logoutFromManager();
            if (this.ownAcsCorba) {
                ClientLogManager.getAcsLogManager().shutdown(false);
                this.acsCorba.shutdownORB(true, false);
                this.acsCorba.doneCorba();
            }
            this.m_threadFactory.cleanUp();
        }
        catch (OBJECT_NOT_EXIST ex) {
            this.m_logger.warning("ORB#destroy caused an org.omg.CORBA.OBJECT_NOT_EXIST exception; ");
        }
        catch (Exception e) {
            System.err.println("Exception in " + this.m_clientName + "#tearDown: ");
            e.printStackTrace(System.err);
            throw e;
        }
        this.m_shutdownHook.setRegularShutdownExpected();
    }
}

