/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.entity.xmlbinding.schedblock.FieldPatternT;
import alma.obsprep.bo.annotations.FieldPatternI;
import alma.obsprep.bo.schedblock.CrossPattern;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.FillPattern;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.bo.schedblock.RectanglePattern;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.bo.schedblock.data.FieldPatternData;
import alma.valuetypes.SkyCoordinates;
import java.util.ArrayList;
import java.util.List;

public abstract class FieldPattern
extends FieldPatternData
implements FieldPatternI {
    public FieldPattern(FieldPatternT fieldPatternT) {
        super(fieldPatternT);
        if (this.getType() == null) {
            this.setType(TYPE_POINT);
        }
    }

    @Override
    public SkyCoordinates getOrigin() {
        FieldSource fieldSource = (FieldSource)this.getParent();
        return fieldSource == null ? null : fieldSource.getSourceCoordinates();
    }

    @Override
    public boolean isRectanglePattern() {
        return false;
    }

    @Override
    public boolean isCrossPattern() {
        return false;
    }

    @Override
    public boolean isFillPattern() {
        return false;
    }

    @Override
    public boolean isPointingPattern() {
        return false;
    }

    @Override
    public boolean isOffsetPointingPattern() {
        return false;
    }

    @Override
    public boolean isAbsolutePointingPattern() {
        return false;
    }

    @Override
    public boolean isMosaic() {
        return false;
    }

    public int getNumberOfPointings() {
        return 0;
    }

    public static FieldPattern createFieldPattern(FieldPatternType fieldPatternType) {
        switch (fieldPatternType.ordinal()) {
            case 0: {
                return PointingPattern.createPointingPattern();
            }
            case 1: {
                return FillPattern.createFillPattern();
            }
            case 2: {
                return RectanglePattern.createRectanglePattern();
            }
            case 3: {
                return CrossPattern.createCrossPattern();
            }
        }
        throw new IllegalArgumentException("Unknown field pattern type : " + String.valueOf((Object)fieldPatternType));
    }

    @Override
    public FieldPatternType getFieldPatternType() {
        return FieldPatternType.getFieldPatternType(this.getType());
    }

    public List<Target> getAssociatedTargets() {
        ArrayList<Target> arrayList = new ArrayList<Target>();
        SchedBlock schedBlock = null;
        if (this.getParent().getParent() instanceof SchedBlock) {
            schedBlock = (SchedBlock)this.getParent().getParent();
        }
        assert (schedBlock != null);
        for (Target target : schedBlock.getTarget()) {
            if (target.getFieldSource() == null || !this.equals(target.getFieldSource().getFieldPattern())) continue;
            arrayList.add(target);
        }
        return arrayList;
    }

    public static enum FieldPatternType {
        POINT(FieldPatternData.TYPE_POINT),
        FILL(FieldPatternData.TYPE_FILL),
        RECTANGLE(FieldPatternData.TYPE_RECTANGLE),
        CROSS(FieldPatternData.TYPE_CROSS);

        private String label;
        private static String[] knownLabels;

        public static FieldPatternType getFieldPatternType(String string) {
            for (FieldPatternType fieldPatternType : FieldPatternType.values()) {
                if (!fieldPatternType.getLabel().equals(string)) continue;
                return fieldPatternType;
            }
            return null;
        }

        public static synchronized String[] getKnownLabels() {
            if (knownLabels == null) {
                knownLabels = new String[FieldPatternType.values().length];
                for (int i = 0; i < knownLabels.length; ++i) {
                    FieldPatternType.knownLabels[i] = FieldPatternType.values()[i].label;
                }
            }
            return knownLabels;
        }

        private FieldPatternType(String string2) {
            this.label = string2;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

