/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc.examples;

import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.guiutil.mvc.examples.FieldScaleEditor;
import alma.obsprep.guiutil.mvc.examples.FieldScaleParameters;
import alma.obsprep.ot.models.valuetypes.UserUnitValueUnitPairModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;

public class FieldScaleModel
extends Model {
    private ValueUnitPairModel frequencyModel = new ValueUnitPairModel(null);
    private UserUnitValueUnitPairModel resolutionModel = new UserUnitValueUnitPairModel(null);
    private ValueUnitPairModel largestScaleModel = new ValueUnitPairModel(null);

    public FieldScaleModel(Object object) {
        super(object);
        this.registerSubModel(this.frequencyModel);
        this.registerSubModel(this.resolutionModel);
        this.registerSubModel(this.largestScaleModel);
        ModelChangeSubscriber modelChangeSubscriber = new ModelChangeSubscriber(){

            @Override
            public void modelChanged(Model model, FieldID fieldID, Object object) {
                if (model == FieldScaleModel.this && fieldID == FieldScaleEditor.ANTENNA_FID || model == FieldScaleModel.this.frequencyModel) {
                    FieldScaleModel.this.refreshBeamsize();
                }
            }
        };
        this.subscribe(modelChangeSubscriber);
        this.frequencyModel.subscribe(modelChangeSubscriber);
    }

    private FieldScaleParameters getParams() {
        return (FieldScaleParameters)this.getDocument();
    }

    public ValueUnitPairModel getFrequencyModel() {
        return this.frequencyModel;
    }

    public UserUnitValueUnitPairModel getResolutionModel() {
        return this.resolutionModel;
    }

    public ValueUnitPairModel getLargestScaleModel() {
        return this.largestScaleModel;
    }

    @Override
    public void publish() {
        if (this.document != null) {
            this.publish(FieldScaleEditor.ANTENNA_FID, this.getParams().getAntenna().getLabel());
        }
        this.frequencyModel.publish();
        this.resolutionModel.publish();
        this.largestScaleModel.publish();
    }

    private void refreshBeamsize() {
        this.publish(FieldScaleEditor.BEAMSIZE_FID, (Object)this.getParams().getAntenna().getBeamSize(this.getParams().getObservingFrequency()));
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (FieldScaleEditor.ANTENNA_FID.equals(fieldID)) {
            Antenna antenna = Antenna.getValue((String)object);
            this.getParams().setAntenna(antenna);
            return antenna.getLabel();
        }
        return null;
    }

    @Override
    public void setDocument(Object object) {
        this.document = object;
        FieldScaleParameters fieldScaleParameters = this.getParams();
        this.frequencyModel.setDocument((Object)fieldScaleParameters.getObservingFrequency());
        this.resolutionModel.setDocument(fieldScaleParameters.getResolution());
        this.largestScaleModel.setDocument((Object)fieldScaleParameters.getLargestScale());
        this.publish();
    }
}

