/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.workbooks.WorkbookPage;
import alma.obsprep.ot.actions.FindNode;
import alma.obsprep.ot.actions.FindNodeInteractor;
import alma.obsprep.ot.actions.Performer;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGuiProjectCompartment;
import alma.obsprep.ot.project.OTTree;
import alma.obsprep.ot.project.ProjectTreeNode;
import java.util.Enumeration;
import java.util.Optional;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import lombok.NonNull;

public class FindNodePerformer
extends Performer {
    public FindNodePerformer(FindNodeInteractor findNodeInteractor) {
        super(findNodeInteractor);
    }

    @Override
    public void perform() {
        FindNodeInteractor findNodeInteractor = (FindNodeInteractor)this.getGui();
        BusinessObject businessObject = findNodeInteractor.getSelectedBO();
        if (businessObject instanceof WorkbookPage) {
            this.findNodeWithWorkBookUserObject(findNodeInteractor);
        } else {
            this.findNodeWithBusinessObjectUserObject(findNodeInteractor);
        }
    }

    private void findNodeWithWorkBookUserObject(FindNodeInteractor findNodeInteractor) {
        ProjectTreeNode projectTreeNode = findNodeInteractor.getSelectedNode();
        FindNode.SearchDirection searchDirection = findNodeInteractor.getSearchDirection();
        Optional<ProjectTreeNode> optional = searchDirection.equals((Object)FindNode.SearchDirection.NEXT) ? this.findNextWorkBookObjectInProjectTree(projectTreeNode) : this.findPreviousWorkBookObjectInProjectTree(projectTreeNode);
        this.displaySpecifiedNodeInTree(findNodeInteractor, optional);
    }

    private Optional<ProjectTreeNode> findPreviousWorkBookObjectInProjectTree(ProjectTreeNode projectTreeNode) {
        if (!(projectTreeNode.getUserObject() instanceof WorkbookPage)) {
            throw new IllegalArgumentException("Illegal argument: selectedNode (" + String.valueOf(projectTreeNode) + ") did not pass the test: selectedNode instanceof WorkbookPage");
        }
        ProjectTreeNode projectTreeNode2 = (ProjectTreeNode)projectTreeNode.getRoot();
        Enumeration<TreeNode> enumeration = projectTreeNode2.breadthFirstEnumeration();
        Optional<ProjectTreeNode> optional = Optional.empty();
        WorkbookPage workbookPage = (WorkbookPage)projectTreeNode.getUserObject();
        while (enumeration.hasMoreElements()) {
            WorkbookPage workbookPage2;
            ProjectTreeNode projectTreeNode3 = (ProjectTreeNode)enumeration.nextElement();
            if (projectTreeNode3.equals(projectTreeNode)) {
                return optional;
            }
            if (!projectTreeNode3.getUserObject().getClass().equals(workbookPage.getClass()) || (workbookPage2 = (WorkbookPage)projectTreeNode3.getUserObject()).getIndex() != workbookPage.getIndex()) continue;
            optional = Optional.of(projectTreeNode3);
        }
        return optional;
    }

    private Optional<ProjectTreeNode> findNextWorkBookObjectInProjectTree(ProjectTreeNode projectTreeNode) {
        if (!(projectTreeNode.getUserObject() instanceof WorkbookPage)) {
            throw new IllegalArgumentException("Illegal argument: selectedNode (" + String.valueOf(projectTreeNode) + ") did not pass the test: selectedNode instanceof WorkbookPage");
        }
        WorkbookPage workbookPage = (WorkbookPage)projectTreeNode.getUserObject();
        ProjectTreeNode projectTreeNode2 = (ProjectTreeNode)projectTreeNode.getRoot();
        Enumeration<TreeNode> enumeration = projectTreeNode2.breadthFirstEnumeration();
        boolean bl = false;
        Object object = projectTreeNode.getUserObject();
        while (enumeration.hasMoreElements()) {
            WorkbookPage workbookPage2;
            ProjectTreeNode projectTreeNode3 = (ProjectTreeNode)enumeration.nextElement();
            if (projectTreeNode3.getUserObject().getClass().equals(object.getClass()) && bl && (workbookPage2 = (WorkbookPage)projectTreeNode3.getUserObject()).getIndex() == workbookPage.getIndex()) {
                return Optional.of(projectTreeNode3);
            }
            if (!projectTreeNode3.equals(projectTreeNode)) continue;
            bl = true;
        }
        return Optional.empty();
    }

    private void findNodeWithBusinessObjectUserObject(FindNodeInteractor findNodeInteractor) {
        ProjectTreeNode projectTreeNode = findNodeInteractor.getSelectedNode();
        FindNode.SearchDirection searchDirection = findNodeInteractor.getSearchDirection();
        Optional<ProjectTreeNode> optional = searchDirection.equals((Object)FindNode.SearchDirection.NEXT) ? this.findNextBOInProjectTree(projectTreeNode) : this.findPreviousBOInProjectTree(projectTreeNode);
        this.displaySpecifiedNodeInTree(findNodeInteractor, optional);
    }

    private void displaySpecifiedNodeInTree(@NonNull FindNodeInteractor findNodeInteractor, Optional<ProjectTreeNode> optional) {
        if (findNodeInteractor == null) {
            throw new NullPointerException("interactor is marked non-null but is null");
        }
        if (optional.isPresent()) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            ProjectTreeNode projectTreeNode = optional.get();
            DefaultMutableTreeNode defaultMutableTreeNode2 = projectTreeNode;
            int n = 0;
            do {
                if ((defaultMutableTreeNode = findNodeInteractor.getSearchDirection().equals((Object)FindNode.SearchDirection.NEXT) ? defaultMutableTreeNode2.getNextLeaf() : defaultMutableTreeNode2.getPreviousLeaf()) == null) continue;
                defaultMutableTreeNode2 = defaultMutableTreeNode;
            } while (++n < 3 && defaultMutableTreeNode != null);
            TreePath treePath = new TreePath(optional.get().getPath());
            TreePath treePath2 = new TreePath(defaultMutableTreeNode2.getPath());
            ObservingToolGuiProjectCompartment observingToolGuiProjectCompartment = ObservingToolController.getOTGui().activeProjectCompartment();
            OTTree oTTree = observingToolGuiProjectCompartment.getProjectTreePanels().getPhase1Tree().getTree();
            oTTree.setSelectionPath(treePath);
            oTTree.scrollPathToVisible(treePath);
            oTTree.expandPath(treePath);
            oTTree.setScrollsOnExpand(true);
            oTTree = observingToolGuiProjectCompartment.getProjectTreePanels().getPhase2Tree().getTree();
            oTTree.setSelectionPath(treePath);
            oTTree.expandPath(treePath);
            oTTree.scrollPathToVisible(treePath);
            oTTree.setScrollsOnExpand(true);
        }
    }

    private Optional<ProjectTreeNode> findNextBOInProjectTree(ProjectTreeNode projectTreeNode) {
        ProjectTreeNode projectTreeNode2 = (ProjectTreeNode)projectTreeNode.getRoot();
        Enumeration<TreeNode> enumeration = projectTreeNode2.breadthFirstEnumeration();
        boolean bl = false;
        Object object = projectTreeNode.getUserObject();
        while (enumeration.hasMoreElements()) {
            ProjectTreeNode projectTreeNode3 = (ProjectTreeNode)enumeration.nextElement();
            if (projectTreeNode3.getUserObject().getClass().equals(object.getClass()) && bl) {
                return Optional.of(projectTreeNode3);
            }
            if (!projectTreeNode3.equals(projectTreeNode)) continue;
            bl = true;
        }
        return Optional.empty();
    }

    private Optional<ProjectTreeNode> findPreviousBOInProjectTree(ProjectTreeNode projectTreeNode) {
        ProjectTreeNode projectTreeNode2 = (ProjectTreeNode)projectTreeNode.getRoot();
        Enumeration<TreeNode> enumeration = projectTreeNode2.breadthFirstEnumeration();
        Optional<ProjectTreeNode> optional = Optional.empty();
        Object object = projectTreeNode.getUserObject();
        while (enumeration.hasMoreElements()) {
            ProjectTreeNode projectTreeNode3 = (ProjectTreeNode)enumeration.nextElement();
            if (projectTreeNode3.equals(projectTreeNode)) {
                return optional;
            }
            if (!projectTreeNode3.getUserObject().getClass().equals(object.getClass())) continue;
            optional = Optional.of(projectTreeNode3);
        }
        return optional;
    }
}

