/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.ot.editors.schedblock.IndividualPointingsExportOptions;
import alma.obsprep.ot.editors.schedblock.PointingExportFileDetails;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.util.GUIUtilities;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import lombok.NonNull;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public abstract class FieldImportExporter {
    private static final DialogId DIALOG_OVERWRITE_FILE = new DialogId("PointingPatternEditor.OverwriteFile");

    protected PointingExportFileDetails getPointingFileNames(boolean bl, boolean bl2, @NonNull JComponent jComponent) throws AbortPointingExportException {
        String string;
        File file;
        if (jComponent == null) {
            throw new NullPointerException("parentComponent is marked non-null but is null");
        }
        PointingExportFileDetails.PointingExportFileDetailsBuilder pointingExportFileDetailsBuilder = PointingExportFileDetails.builder();
        JFileChooser jFileChooser = GuiFactory.getFactory().giveFileChooser("ExportPointings");
        IndividualPointingsExportOptions individualPointingsExportOptions = new IndividualPointingsExportOptions();
        jFileChooser.setAccessory(individualPointingsExportOptions);
        jFileChooser.setDialogTitle("Export Pointings");
        jFileChooser.setDialogType(1);
        int n = jFileChooser.showSaveDialog(jComponent);
        pointingExportFileDetailsBuilder.dialogueRetCode(n).expOpts(individualPointingsExportOptions);
        File file2 = jFileChooser.getSelectedFile();
        if (file2 == null || n == 1) {
            throw new AbortPointingExportException();
        }
        Object object = FilenameUtils.getExtension((String)file2.getAbsolutePath());
        object = StringUtils.isEmpty((String)object) ? ".txt" : "." + (String)object;
        String string2 = FilenameUtils.removeExtension((String)file2.getAbsolutePath()).replace("-12m", "").replace("-7m", "");
        if (bl) {
            file = new File(string2 + "-12m" + (String)object);
            if (file.exists()) {
                try {
                    string = "File " + file.getCanonicalPath() + " already exists.\nDo you want to replace it?";
                    if (!GUIUtilities.confirm(DIALOG_OVERWRITE_FILE, string)) {
                        throw new AbortPointingExportException();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            pointingExportFileDetailsBuilder.twelveMFile(Optional.of(file));
        }
        if (bl2) {
            file = new File(string2 + "-7m" + (String)object);
            if (file.exists()) {
                try {
                    string = "File " + file.getCanonicalPath() + " already exists.\nDo you want to replace it?";
                    if (!GUIUtilities.confirm(DIALOG_OVERWRITE_FILE, string)) {
                        throw new AbortPointingExportException();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            pointingExportFileDetailsBuilder.aca7MFile(Optional.of(file));
        }
        return pointingExportFileDetailsBuilder.build();
    }

    public static class AbortPointingExportException
    extends Exception {
    }
}

