/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.guiutil.mvc.widgets.OTTabbedPane;
import alma.obsprep.ot.editors.misc.UserEditRestrictionController;
import alma.obsprep.ot.editors.sciencegoals.TargetParametersEditor;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.EditorDisablerController;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.models.sciencegoals.FieldSetupModel;
import alma.obsprep.ot.models.sciencegoals.TargetParametersModel;
import alma.obsprep.services.sfi.ScienceGoalEditorViewEnum;
import alma.obsprep.services.sfi.SingleFieldScienceGoalModel;
import alma.obsprep.util.GUIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.stream.Stream;
import javax.help.CSH;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import lombok.NonNull;

public class FieldSetupEditor
extends Editor
implements ModelChangeSubscriber {
    private static DialogId DIALOG_OVERWRITE_FILE = new DialogId("ExportTargets.OverwriteFile", "Export to file. Overwrite existing file?");
    public static final FieldID FID_TABBEDPANE = new FieldID("FieldSetup.tabs");
    public static final FieldID FID_ADD_SOURCE_BUTTON = new FieldID("FieldSetup.addBtn");
    private static final FieldID FID_IMPORT_SOURCES_BUTTON = new FieldID("FieldSetup.loadBtn");
    public static final FieldID FID_EXPORT_SOURCES_BUTTON = new FieldID("FieldSetup.exportBtn");
    public static final FieldID FID_DELETE_SOURCE_BUTTON = new FieldID("FieldSetup.delBtn");
    public static final FieldID FID_CLONE_BUTTON = new FieldID("FieldSetup.cloneBtn");
    public static final FieldID FID_DELETE_ALL_BUTTON = new FieldID("FieldSetup.delAllBtn");
    public static final FieldID FID_DEBUGPRINT_BUTTON = new FieldID("FieldSetup.debugBtn");
    private Box buttonBox;
    private OTTabbedPane targetTabbedPane;
    private final TargetParametersEditor targetEditor;
    private final TargetParametersModel targetModel;
    private int selectedTabIndex = 0;
    private boolean tabSelectionListenerActivated = true;
    private final ChangeListener tabSelectionListener = changeEvent -> {
        if (this.tabSelectionListenerActivated) {
            this.setEditorAtSelectedTab();
        }
    };
    private ScienceGoalEditorViewEnum currentView = ScienceGoalEditorViewEnum.DEFAULTVIEW;

    public FieldSetupEditor(Model model) {
        this(model, false, false);
    }

    public FieldSetupEditor(Model model, boolean bl, boolean bl2) {
        this.targetModel = ((FieldSetupModel)model).getTargetParametersModel();
        this.targetModel.subscribe(this);
        this.targetEditor = new TargetParametersEditor(this.targetModel);
        this.registerSubView(this.targetEditor);
        CSH.setHelpIDString((Component)this.targetEditor, (String)"TOC-Phase 1 and Phase 2 Science Goals-Field Setup-Source");
        this.setModel(model);
        this.build();
        model.publish();
    }

    public TargetParametersEditor getTargetParametersEditor() {
        return this.targetEditor;
    }

    @Override
    public FieldSetupModel getModel() {
        return (FieldSetupModel)super.getModel();
    }

    @Override
    protected void build() {
        Dimension dimension = new Dimension(10, 3);
        this.setLayout(new BoxLayout(this, 3));
        this.targetTabbedPane = new OTTabbedPane();
        this.targetTabbedPane.setTabLayoutPolicy(0);
        this.targetTabbedPane.addChangeListener(this.tabSelectionListener);
        this.targetTabbedPane.putClientProperty("readonly-handler", EditorDisablerController.keepEnabledStateOnReadonly);
        this.initEvents(this.targetTabbedPane, FID_TABBEDPANE);
        this.add(this.targetTabbedPane);
        this.add(Box.createRigidArea(dimension));
        this.buttonBox = this.createButtonBox();
        this.add(this.buttonBox);
        this.add(Box.createRigidArea(dimension));
        UserEditRestrictionController.getInstance().registerUserChangeRestrictionAffectedComponents(this.targetEditor.getUserRestrictedEditableComponents());
    }

    private Box createButtonBox() {
        Box box = Box.createHorizontalBox();
        Dimension dimension = new Dimension(3, 3);
        JButton jButton = new JButton("Add Source");
        jButton.setToolTipText("Add another science source");
        this.initEvents(jButton, FID_ADD_SOURCE_BUTTON);
        box.add(jButton);
        box.add(Box.createRigidArea(dimension));
        jButton = new JButton("Load from File");
        jButton.setToolTipText("Load list of science sources from a file");
        jButton.addActionListener(actionEvent -> this.importTargetsFromFile());
        this.initEvents(jButton, FID_IMPORT_SOURCES_BUTTON);
        box.add(jButton);
        box.add(Box.createRigidArea(dimension));
        jButton = new JButton("Export to File");
        jButton.setToolTipText("Export list of science sources to a file");
        jButton.addActionListener(actionEvent -> this.exportTargetsToFile());
        jButton.putClientProperty("readonly-handler", EditorDisablerController.keepEnabledStateOnReadonly);
        this.initEvents(jButton, FID_EXPORT_SOURCES_BUTTON);
        box.add(jButton);
        box.add(Box.createRigidArea(dimension));
        jButton = new JButton("Clone Source");
        jButton.setToolTipText("Clone the source");
        jButton.setEnabled(true);
        this.initEvents(jButton, FID_CLONE_BUTTON);
        box.add(jButton);
        box.add(Box.createRigidArea(dimension));
        jButton = new JButton("Delete Source");
        jButton.setToolTipText("Delete selected source");
        jButton.setEnabled(false);
        this.initEvents(jButton, FID_DELETE_SOURCE_BUTTON);
        box.add(jButton);
        box.add(Box.createRigidArea(dimension));
        jButton = new JButton("Delete All Sources");
        jButton.setToolTipText("Delete all sources");
        jButton.setEnabled(false);
        this.initEvents(jButton, FID_DELETE_ALL_BUTTON);
        box.add(jButton);
        box.add(Box.createRigidArea(dimension));
        jButton = new JButton("Debug Print");
        jButton.setToolTipText("Debug Print");
        jButton.setEnabled(true);
        this.initEvents(jButton, FID_DEBUGPRINT_BUTTON);
        return box;
    }

    private void enableButtons(boolean bl) {
        this.getComponent(FID_ADD_SOURCE_BUTTON).setEnabled(bl);
        this.getComponent(FID_IMPORT_SOURCES_BUTTON).setEnabled(bl);
        this.getComponent(FID_EXPORT_SOURCES_BUTTON).setEnabled(bl);
        this.getComponent(FID_DELETE_SOURCE_BUTTON).setEnabled(bl);
        this.getComponent(FID_DELETE_ALL_BUTTON).setEnabled(bl);
        this.getComponent(FID_CLONE_BUTTON).setEnabled(bl);
    }

    private void updateButtons() {
        if (!this.isEnabled()) {
            return;
        }
        this.buttonBox.setVisible(true);
        this.enableButtons(true);
        ScienceGoal scienceGoal = this.getModel().getScienceGoal();
        if (scienceGoal == null || scienceGoal.getTargetParametersCount() <= 1) {
            ((JButton)this.getComponent(FID_DELETE_SOURCE_BUTTON)).setEnabled(false);
            ((JButton)this.getComponent(FID_DELETE_ALL_BUTTON)).setEnabled(false);
        }
        if (scienceGoal != null) {
            JButton jButton = (JButton)this.getComponent(FID_ADD_SOURCE_BUTTON);
            jButton.setEnabled(!this.currentView.equals((Object)ScienceGoalEditorViewEnum.VLBI));
            this.getComponent(FID_IMPORT_SOURCES_BUTTON).setEnabled(true);
            this.getComponent(FID_EXPORT_SOURCES_BUTTON).setEnabled(true);
        }
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        ScienceGoal scienceGoal = this.getModel().getScienceGoal();
        if (scienceGoal == null) {
            return;
        }
        if (fieldID == FID_TABBEDPANE) {
            if (object instanceof ScienceGoal) {
                this.resetTabEditor((ScienceGoal)object);
                this.updateTargetTypeButtons();
                this.updateButtons();
                this.setEditorAtSelectedTab();
            } else if (object instanceof Integer) {
                int n = (Integer)object;
                try {
                    if (n >= 0) {
                        this.targetTabbedPane.setSelectedIndex(n);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            return;
        }
        if (fieldID == FID_ADD_SOURCE_BUTTON || fieldID == FID_IMPORT_SOURCES_BUTTON || fieldID == FID_EXPORT_SOURCES_BUTTON) {
            int n = scienceGoal.getTargetParametersCount();
            this.targetTabbedPane.setSelectedIndex(n - 1);
            return;
        }
        if (fieldID == FID_DELETE_SOURCE_BUTTON) {
            return;
        }
        if (fieldID == FID_DELETE_ALL_BUTTON) {
            return;
        }
        if (fieldID == FID_DEBUGPRINT_BUTTON) {
            return;
        }
        super.update(fieldID, object);
    }

    public void updateTargetTypeButtons() {
        if (!this.isEnabled()) {
            return;
        }
        boolean bl = true;
        if (this.getTargetCountByType(TargetParameters.TYPE_F_MULTIPLEPOINTS) > 1 || this.getTargetCountByType(TargetParameters.TYPE_F_SINGLERECTANGLE) > 1) {
            bl = false;
        }
        this.targetEditor.getComponent(TargetParametersEditor.FID_TARGETTYPE).setEnabled(bl);
    }

    private void importTargetsFromFile() {
        File file;
        JFileChooser jFileChooser = GuiFactory.getFactory().giveFileChooser(this);
        AppendOrReplaceAccessory appendOrReplaceAccessory = new AppendOrReplaceAccessory();
        JComponent jComponent = jFileChooser.getAccessory();
        this.resetFileAccessoryPanel(jComponent);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jComponent);
        jPanel.add(appendOrReplaceAccessory);
        jFileChooser.setAccessory(jPanel);
        jFileChooser.setDialogTitle("Import Targets");
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0 && (file = jFileChooser.getSelectedFile()).exists()) {
            this.getModel().loadFromFile(file, appendOrReplaceAccessory.isAppendOperation());
        }
    }

    private void resetFileAccessoryPanel(@NonNull JComponent jComponent) {
        if (jComponent == null) {
            throw new NullPointerException("recentFileSelectorAccessory is marked non-null but is null");
        }
        Stream.of(jComponent.getComponents()).filter(component -> component instanceof ExportOptions || component instanceof AppendOrReplaceAccessory).forEach(component -> jComponent.remove((Component)component));
    }

    private void exportTargetsToFile() {
        JFileChooser jFileChooser = GuiFactory.getFactory().giveFileChooser(this);
        ExportOptions exportOptions = new ExportOptions();
        JComponent jComponent = jFileChooser.getAccessory();
        this.resetFileAccessoryPanel(jComponent);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jComponent);
        jPanel.add(exportOptions);
        jFileChooser.setAccessory(jPanel);
        jFileChooser.setDialogTitle("Export Targets");
        jFileChooser.setDialogType(1);
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            if (file.exists()) {
                String string = "";
                try {
                    string = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                String string2 = "File " + string + " already exists.\nDo you want to replace it?";
                boolean bl = GUIUtilities.confirm(DIALOG_OVERWRITE_FILE, string2);
                if (!bl) {
                    return;
                }
            }
            if (exportOptions.isExportTargets()) {
                this.getModel().exportTargetsToFile(file);
            } else if (exportOptions.isExportParameters()) {
                this.getModel().exportParametersToFile(file, exportOptions.isParametersIncludeTargetNames(), exportOptions.getParametersCoordsType());
            }
        }
    }

    private int getTargetCountByType(String string) {
        ScienceGoal scienceGoal = this.getModel().getScienceGoal();
        int n = 0;
        for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
            String string2 = targetParameters.getType();
            if (string2 == null) {
                throw new RuntimeException("Unexpected Target Parameters Type : " + string2);
            }
            if (!string2.equals(string)) continue;
            ++n;
        }
        return n;
    }

    private String tabTitle(TargetParameters targetParameters) {
        String string;
        if (targetParameters == null) {
            return null;
        }
        String string2 = targetParameters.getSourceName();
        if (string2 != null && string2.length() > 0) {
            string = string2;
        } else {
            try {
                string = targetParameters.getField(0).getClass().getSimpleName();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                string = "Field";
            }
        }
        return string;
    }

    private void updateTabTitle() {
        String string;
        int n = this.targetTabbedPane.getSelectedIndex();
        if (n == -1) {
            return;
        }
        ScienceGoal scienceGoal = (ScienceGoal)this.getModel().getDocument();
        if (scienceGoal == null) {
            string = "Field";
        } else {
            if (scienceGoal.getTargetParametersCount() <= n) {
                return;
            }
            TargetParameters targetParameters = scienceGoal.getTargetParameters(n);
            string = this.tabTitle(targetParameters);
        }
        this.targetTabbedPane.setTitleAt(n, string);
    }

    private void resetTabTitle(String string) {
        int n = this.targetTabbedPane.getSelectedIndex();
        if (n == -1) {
            return;
        }
        this.targetTabbedPane.setTitleAt(n, string);
    }

    public void resetTabEditor(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        this.targetTabbedPane.removeChangeListener(this.tabSelectionListener);
        this.targetTabbedPane.removeAll();
        for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
            this.targetTabbedPane.add(this.tabTitle(targetParameters), new JLabel("dummy"));
        }
        if (scienceGoal.getTargetParametersCount() <= this.selectedTabIndex) {
            this.selectedTabIndex = 0;
        }
        this.targetTabbedPane.setSelectedIndex(this.selectedTabIndex);
        this.targetTabbedPane.addChangeListener(this.tabSelectionListener);
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        if (fieldID.equals(TargetParametersEditor.FID_TARGETTYPE)) {
            this.updateTabTitle();
            this.updateTargetTypeButtons();
            this.updateButtons();
        } else if (fieldID.equals(TargetParametersEditor.FID_SOURCENAME)) {
            if (object == "") {
                this.resetTabTitle("Unspecified");
            } else {
                this.updateTabTitle();
            }
        } else if (fieldID.equals(SingleFieldScienceGoalModel.EDITOR_SUBVIEW_FID)) {
            this.configureEditorForView((ScienceGoalEditorViewEnum)((Object)object));
        }
        super.modelChanged(model, fieldID, object);
    }

    @Override
    public void configureEditorForView(@NonNull ScienceGoalEditorViewEnum scienceGoalEditorViewEnum) {
        if (scienceGoalEditorViewEnum == null) {
            throw new NullPointerException("view is marked non-null but is null");
        }
        this.currentView = scienceGoalEditorViewEnum;
        this.updateButtons();
        this.targetEditor.configureEditorForView(this.currentView);
    }

    private void setEditorAtSelectedTab() {
        int n = this.targetTabbedPane.getSelectedIndex();
        if (n == -1) {
            return;
        }
        this.getModel().setSelectedTargetParametersIndex(n);
        int n2 = this.targetTabbedPane.indexOfComponent(this.targetEditor);
        this.tabSelectionListenerActivated = false;
        try {
            this.targetTabbedPane.setComponentAt(n2, new JLabel("dummy"));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        SwingUtilities.updateComponentTreeUI(this.targetEditor);
        this.targetTabbedPane.setComponentAt(n, this.targetEditor);
        this.updateTabTitle();
        this.selectedTabIndex = n;
        this.tabSelectionListenerActivated = true;
    }

    public OTTabbedPane getTargetTabbedPane() {
        return this.targetTabbedPane;
    }

    class AppendOrReplaceAccessory
    extends JPanel {
        private final ButtonGroup group = new ButtonGroup();
        private final JRadioButton appendButton;
        private final JRadioButton replaceButton;

        public AppendOrReplaceAccessory() {
            this.setLayout(new GridLayout(2, 1));
            this.replaceButton = new JRadioButton("Replace Source List");
            this.replaceButton.setToolTipText("Create a new source list containing targets specified in the selected file");
            this.group.add(this.replaceButton);
            this.appendButton = new JRadioButton("Append to Source List");
            this.appendButton.setToolTipText("Append sources in the selected file to your source list");
            this.group.add(this.appendButton);
            this.appendButton.setSelected(true);
            this.add(this.appendButton);
            this.add(this.replaceButton);
        }

        public boolean isAppendOperation() {
            return this.appendButton.isSelected();
        }

        public boolean isReplaceOperation() {
            return this.replaceButton.isSelected();
        }
    }

    class ExportOptions
    extends JPanel {
        private static final long serialVersionUID = 5264761919008845165L;
        private static final String TARGETS_BTN_NAME = "ExportOptionsDialog.expTargetsBtn";
        private static final String PARAMETERS_BTN_NAME = "ExportOptionsDialog.expParametersBtn";
        private static final String POINTINGS_BTN_NAME = "ExportOptionsDialog.expPointingsBtn";
        private final ButtonGroup exportGroup = new ButtonGroup();
        private final JRadioButton targetsBtn;
        private final JRadioButton parametersBtn;
        private final JCheckBox paramIncTargetName;
        private final CoordsOptions parametersCoords;

        public ExportOptions() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.targetsBtn = new JRadioButton("Export full source information");
            this.targetsBtn.setName(TARGETS_BTN_NAME);
            this.targetsBtn.setToolTipText("Export in a format compatible with the science goal load from text file function");
            this.exportGroup.add(this.targetsBtn);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.add((Component)this.targetsBtn, gridBagConstraints);
            this.parametersBtn = new JRadioButton("Export source positions only");
            this.parametersBtn.setName(PARAMETERS_BTN_NAME);
            this.parametersBtn.setToolTipText("Export of target parameter positions only (RA, Dec)");
            this.exportGroup.add(this.parametersBtn);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            this.add((Component)this.parametersBtn, gridBagConstraints);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            this.add((Component)new JLabel("     "), gridBagConstraints);
            this.paramIncTargetName = new JCheckBox("Include target name");
            this.paramIncTargetName.setName("ExportOptionsDialog.expParamIncTargetName");
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            this.add((Component)this.paramIncTargetName, gridBagConstraints);
            this.parametersCoords = new CoordsOptions();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            this.add((Component)this.parametersCoords, gridBagConstraints);
            ActionListener actionListener = actionEvent -> {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                String string = abstractButton.getName();
                if (string.equals(TARGETS_BTN_NAME) || string.equals(POINTINGS_BTN_NAME)) {
                    this.setParametersIncludeTargetNamesEnabled(false);
                    this.setParametersCoordsEnabled(false);
                } else if (string.equals(PARAMETERS_BTN_NAME)) {
                    this.setParametersIncludeTargetNamesEnabled(true);
                    this.setParametersCoordsEnabled(true);
                }
            };
            this.targetsBtn.addActionListener(actionListener);
            this.parametersBtn.addActionListener(actionListener);
            this.setParametersIncludeTargetNamesEnabled(false);
            this.setParametersCoordsEnabled(false);
            this.targetsBtn.setSelected(true);
        }

        public boolean isExportTargets() {
            return this.targetsBtn.isSelected();
        }

        public boolean isExportParameters() {
            return this.parametersBtn.isSelected();
        }

        public exportFormat getExportFormat() {
            if (this.targetsBtn.isSelected()) {
                return exportFormat.TARGETS;
            }
            if (this.parametersBtn.isSelected()) {
                return exportFormat.PARAMETERS;
            }
            return null;
        }

        public boolean isParametersIncludeTargetNames() {
            return this.paramIncTargetName.isSelected();
        }

        public void setParametersIncludeTargetNamesEnabled(boolean bl) {
            this.paramIncTargetName.setEnabled(bl);
        }

        public coordsFormat getParametersCoordsType() {
            return this.parametersCoords.getCoordsType();
        }

        public void setParametersCoordsEnabled(boolean bl) {
            this.parametersCoords.setEnabled(bl);
        }

        class CoordsOptions
        extends JPanel {
            private final ButtonGroup coordsGroup = new ButtonGroup();
            private final JRadioButton sexagBtn;
            private final JRadioButton degreesBtn;
            private final JRadioButton radiansBtn;

            public CoordsOptions() {
                this.setLayout(new BoxLayout(this, 0));
                this.sexagBtn = new JRadioButton("Sexagesimal");
                this.sexagBtn.setName("ExportOptionsDialog.CoordsSexagesimal");
                this.coordsGroup.add(this.sexagBtn);
                this.degreesBtn = new JRadioButton("Degrees");
                this.degreesBtn.setName("ExportOptionsDialog.CoordsDegrees");
                this.coordsGroup.add(this.degreesBtn);
                this.radiansBtn = new JRadioButton("Radians");
                this.radiansBtn.setName("ExportOptionsDialog.CoordsRadians");
                this.coordsGroup.add(this.radiansBtn);
                this.add(this.sexagBtn);
                this.add(this.degreesBtn);
                this.add(this.radiansBtn);
                this.sexagBtn.setSelected(true);
            }

            public boolean isSexagesimal() {
                return this.sexagBtn.isSelected();
            }

            public boolean isDegrees() {
                return this.degreesBtn.isSelected();
            }

            public boolean isRadians() {
                return this.radiansBtn.isSelected();
            }

            public coordsFormat getCoordsType() {
                if (this.sexagBtn.isSelected()) {
                    return coordsFormat.SEXAGESIMAL;
                }
                if (this.degreesBtn.isSelected()) {
                    return coordsFormat.DEGREES;
                }
                if (this.radiansBtn.isSelected()) {
                    return coordsFormat.RADIANS;
                }
                return null;
            }

            @Override
            public void setEnabled(boolean bl) {
                this.sexagBtn.setEnabled(bl);
                this.degreesBtn.setEnabled(bl);
                this.radiansBtn.setEnabled(bl);
            }
        }
    }

    public static enum coordsFormat {
        SEXAGESIMAL,
        DEGREES,
        RADIANS;

    }

    public static enum exportFormat {
        TARGETS,
        PARAMETERS,
        POINTINGS;

    }
}

