/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.misc;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.BOCollection;
import alma.obsprep.bo.FieldSourceCollection;
import alma.obsprep.bo.InstrumentSpecCollection;
import alma.obsprep.bo.ObservingParametersCollection;
import alma.obsprep.bo.PhaseISciencePlanCollection;
import alma.obsprep.bo.TargetCollection;
import alma.obsprep.bo.annotations.SummaryTable;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.misc.ScienceGoalSummaryTableLoader;
import alma.obsprep.ot.editors.misc.SummaryTableEditor;
import alma.obsprep.ot.editors.misc.SummaryTableRowsLoader;
import alma.obsprep.ot.gui.toplevel.EditorManager;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.models.misc.SummaryTableRow;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import lombok.NonNull;

public class SummaryTableModel<E extends SummaryTableRow>
extends Model
implements TableModel {
    private final ObservingToolController otc;
    static HashMap<Class<?>, SummaryTableRowsLoader> summaryLoaders = new HashMap();
    private final List<E> rows;
    protected EventListenerList listenerList = new EventListenerList();
    private E sample = null;

    public SummaryTableModel(Object object, @NonNull ObservingToolController observingToolController) {
        super(object);
        if (observingToolController == null) {
            throw new NullPointerException("otc is marked non-null but is null");
        }
        this.otc = observingToolController;
        this.rows = new ArrayList();
    }

    private void clear() {
        this.rows.clear();
        this.fireTableDataChanged();
    }

    public boolean add(E e) {
        int n = this.rows.size();
        boolean bl = this.rows.add(e);
        if (bl) {
            this.fireTableRowsInserted(n, n);
        }
        return bl;
    }

    public void add(SummaryTable<E> summaryTable, boolean bl) {
        if (summaryTable instanceof SummaryTableRow) {
            this.add((SummaryTableRow)((Object)summaryTable));
            if (!bl) {
                return;
            }
        }
        for (SummaryTableRow summaryTableRow : summaryTable) {
            try {
                SummaryTable summaryTable2 = (SummaryTable)((Object)summaryTableRow);
                this.add(summaryTable2, bl);
            }
            catch (ClassCastException classCastException) {
                if (!bl) continue;
                this.add(summaryTableRow);
            }
        }
    }

    private void addSummaryRowElements(@NonNull SummaryTable<E> summaryTable, boolean bl) {
        if (summaryTable == null) {
            throw new NullPointerException("summaryTable is marked non-null but is null");
        }
        for (SummaryTableRow summaryTableRow : summaryTable) {
            try {
                SummaryTable summaryTable2 = (SummaryTable)((Object)summaryTableRow);
                this.add(summaryTable2, bl);
            }
            catch (ClassCastException classCastException) {
                if (!bl) continue;
                this.add(summaryTableRow);
            }
        }
    }

    public boolean remove(Object object) {
        boolean bl = this.rows.remove(object);
        if (bl) {
            this.fireTableDataChanged();
        }
        return bl;
    }

    public E get(int n) {
        return (E)((SummaryTableRow)this.rows.get(n));
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        if (this.getRowCount() > 0) {
            return ((SummaryTableRow)this.rows.get(0)).getSummaryTableColumns().getSummaryColumnCount();
        }
        if (this.sample != null) {
            return this.sample.getSummaryTableColumns().getSummaryColumnCount();
        }
        return 0;
    }

    @Override
    public String getColumnName(int n) {
        if (this.getRowCount() > 0) {
            return ((SummaryTableRow)this.rows.get(0)).getSummaryTableColumns().getSummaryColumnName(n);
        }
        if (this.sample != null) {
            return this.sample.getSummaryTableColumns().getSummaryColumnName(n);
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (this.getRowCount() > 0) {
            return ((SummaryTableRow)this.rows.get(0)).getSummaryTableColumns().getSummaryColumnClass(n);
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        try {
            SummaryTable summaryTable = (SummaryTable)this.getDocument();
            return summaryTable.isSummaryTableEditable() && ((SummaryTableRow)this.rows.get(n)).getSummaryTableColumns().isSummaryCellEditable(n2);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return ((SummaryTableRow)this.rows.get(n)).getSummaryTableColumns().getSummaryValueAt(n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        ((SummaryTableRow)this.rows.get(n)).getSummaryTableColumns().setSummaryValueAt(object, n2);
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listenerList.add(TableModelListener.class, tableModelListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listenerList.remove(TableModelListener.class, tableModelListener);
    }

    public void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void fireTableStructureChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    public void fireTableRowsInserted(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n2, -1, 1));
    }

    public void fireTableRowsUpdated(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n2, -1, 0));
    }

    public void fireTableRowsDeleted(int n, int n2) {
        this.fireTableChanged(new TableModelEvent(this, n, n2, -1, -1));
    }

    public void fireTableChanged(TableModelEvent tableModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TableModelListener.class) continue;
            ((TableModelListener)objectArray[i + 1]).tableChanged(tableModelEvent);
        }
    }

    public void addnew() {
        try {
            BOCollection bOCollection = (BOCollection)this.getDocument();
            bOCollection.addnew();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void addToParent(List<E> list) {
        try {
            BOCollection bOCollection = (BOCollection)this.getDocument();
            bOCollection.add(list);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void deleteSelected(int[] nArray) {
        try {
            BOCollection bOCollection = (BOCollection)this.getDocument();
            BusinessObject[] businessObjectArray = bOCollection.getCollection();
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n = nArray[i];
                bOCollection.remove(businessObjectArray[n]);
                this.remove(businessObjectArray[n]);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void loadFromFile(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        SummaryTableRowsLoader summaryTableRowsLoader = summaryLoaders.get(this.getDocument().getClass());
        if (summaryTableRowsLoader == null) {
            return;
        }
        try {
            summaryTableRowsLoader.loadList(file, ",");
        }
        catch (IOException iOException) {
            return;
        }
        this.addToParent(summaryTableRowsLoader.getList());
    }

    public Object[] getSummaryColumnItemList(int n) {
        if (this.getRowCount() == 0) {
            return null;
        }
        return ((SummaryTableRow)this.rows.get(0)).getSummaryTableColumns().getSummaryColumnKnownItemList(n);
    }

    public Object[] getLongValues() {
        return this.sample != null ? this.sample.getSummaryTableColumns().getLongValues() : new Object[]{};
    }

    public void updateRows() {
        if (!this.rows.isEmpty()) {
            this.fireTableRowsUpdated(0, this.rows.size() - 1);
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        return null;
    }

    @Override
    public void publish() {
        this.fireTableStructureChanged();
        this.publish(SummaryTableEditor.FID_TABLE, null);
    }

    @Override
    public void setDocument(Object object) {
        this.clear();
        this.setTableHeaderLabel(object);
        this.populateSummaryTable(object);
        super.setDocument(object);
    }

    private void populateSummaryTable(Object object) {
        try {
            SummaryTable summaryTable = (SummaryTable)object;
            if (object instanceof ScienceGoal) {
                this.addSummaryRowElements(summaryTable, summaryTable.expandsRow());
            } else if (object instanceof ObsProgram) {
                this.addSummaryRowElements(summaryTable, summaryTable.expandsRow());
            } else {
                this.add(summaryTable, summaryTable.expandsRow());
            }
            if (!this.rows.isEmpty()) {
                this.sample = (SummaryTableRow)this.rows.get(0);
            }
        }
        catch (ClassCastException classCastException) {
            try {
                SummaryTableRow summaryTableRow = (SummaryTableRow)object;
                this.clear();
                this.add(summaryTableRow);
            }
            catch (ClassCastException classCastException2) {
                // empty catch block
            }
        }
    }

    private void setTableHeaderLabel(Object object) {
        EditorManager editorManager = this.otc.getGui().getEditors();
        SummaryTableEditor summaryTableEditor = (SummaryTableEditor)editorManager.getSummaryFormEditor();
        if (object instanceof PhaseISciencePlanCollection) {
            summaryTableEditor.setMessage("Summary table of Science Goals. Double-clicking on a row will take you to that Science Goal");
        } else if (object instanceof ScienceGoal) {
            ScienceGoal scienceGoal = (ScienceGoal)object;
            if (scienceGoal.getTargetParametersCount() > 0) {
                String string = scienceGoal.getName();
                String string2 = scienceGoal.getRepresentativeFrequency().toString();
                summaryTableEditor.setMessage("<html>Table of the field sources for the <em>" + string + "</em> science goal. Representative frequency is " + string2 + "</html>");
            }
        } else if (object instanceof ObsProgram) {
            summaryTableEditor.setMessage("Summary table of Science Goals. Double-clicking on a row will take you to that Science Goal");
        } else if (object instanceof TargetCollection) {
            summaryTableEditor.setMessage("Table of the targets");
        } else if (object instanceof FieldSourceCollection) {
            summaryTableEditor.setMessage("Table of the field sources");
        } else if (object instanceof InstrumentSpecCollection) {
            summaryTableEditor.setMessage("Table of the instrument specifications");
        } else if (object instanceof ObservingParametersCollection) {
            summaryTableEditor.setMessage("Table of the observing parameters");
        }
    }

    static {
        summaryLoaders.put(PhaseISciencePlanCollection.class, new ScienceGoalSummaryTableLoader());
    }
}

