/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.obsproject;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;

public class ObsUnitSetValidator
extends AbstractValidator {
    static final AlmaPolicies apol = AlmaPolicies.getInstance();
    static final int MAX_TEXTAREA_CHARACTERS = apol.getMaxTextAreaCharacters();

    public ObsUnitSetValidator() {
        this.setValidatorThreadSafe(true);
    }

    @Override
    public void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        Problem problem;
        Object object;
        ObsUnitSet obsUnitSet = (ObsUnitSet)businessObject;
        String string = obsUnitSet.getNote();
        int n = string.length();
        if (n > MAX_TEXTAREA_CHARACTERS) {
            object = "Cycle0 staff note contains too many characters (" + n + ")";
            String string2 = "Select the project node and edit the Cycle0 staff note to reduce its size (max " + MAX_TEXTAREA_CHARACTERS + " characters)";
            if (obsUnitSet.getParent() instanceof ObsUnitSet) {
                object = "Description contains too many characters (" + n + ")";
                string2 = "Select the ObsUnitSet node in the Program tab and edit your description (max " + MAX_TEXTAREA_CHARACTERS + " characters)";
                problem = DefaultProblem.createError(object, string2, obsUnitSet);
            } else {
                try {
                    problem = DefaultProblem.createError(object, string2, obsUnitSet.getObsProject());
                }
                catch (UnknownEntityException unknownEntityException) {
                    problem = DefaultProblem.createError(object, string2, (IBusinessObject)businessObject);
                }
            }
            problemListModel.add(problem);
        }
        if (obsUnitSet.getSchedBlockCount() > 0 && obsUnitSet.getObsUnitSetCount() > 0) {
            problem = DefaultProblem.createError("ObsUnitSet contains both ObsUnitSets and SchedBlocks", "This should not happen! Please report this.", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if ((object = obsUnitSet.getObsUnitControl()).getEstimatedExecutionTime().isZero()) {
            object.setEstimatedExecutionTime(obsUnitSet.calcEstimatedTime());
        }
        if (object.getMaximumTime().isZero()) {
            object.setMaximumTime(obsUnitSet.calcMaxTime());
        }
        if (object.getAggregatedExecutionCount() == 0) {
            object.setAggregatedExecutionCount(obsUnitSet.calcAggregatedExecutionCount());
        }
        this.verifyOnlySingleSBPerOUS(obsUnitSet, businessObject, problemListModel);
    }

    private void verifyOnlySingleSBPerOUS(ObsUnitSet obsUnitSet, BusinessObject businessObject, ProblemListModel problemListModel) {
        if (!this.isCommissioningProject(businessObject) && obsUnitSet.getSchedBlockCount() > 1) {
            problemListModel.add(DefaultProblem.createError("More than one SB in a Member OUS is not allowed", "Additional SBs should be placed in a separate Member OUS", (IBusinessObject)businessObject));
        }
    }

    private boolean isCommissioningProject(BusinessObject businessObject) {
        BusinessObject businessObject2;
        for (businessObject2 = businessObject; businessObject2 != null && !(businessObject2 instanceof ObsProject); businessObject2 = businessObject2.getParent()) {
        }
        boolean bl = false;
        if (businessObject2 instanceof ObsProject) {
            ObsProject obsProject = (ObsProject)businessObject2;
            bl = obsProject.getIsCommissioning();
        }
        return bl;
    }
}

