/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.calibration;

import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.calibration.CalObs;
import alma.obsprep.services.calibration.CalType;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.valuetypes.Angle;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;
import alma.valuetypes.Temperature;
import alma.valuetypes.Time;

public class PointingCalObs
extends CalObs {
    public static final double POINTINGCAL_FREQUENCY_GHZ = 100.0;
    private final Angle offsetPointingSpec = PointingCalObs.getCalObsProperties().getPointingSpec();

    public PointingCalObs() {
        this.setCalType(CalType.Pointing);
    }

    public PointingCalObs(ScienceGoal scienceGoal) {
        this();
        this.scienceGoal = scienceGoal;
        this.configure();
    }

    @Override
    public boolean atmCalRequired(SchedBlock schedBlock) {
        return false;
    }

    @Override
    public double getDefaultSNR() {
        return 1.0;
    }

    @Override
    public Frequency getDefaultChannelWidth() {
        return (Frequency)ScienceSpectralWindow.getSingleContinuumBandwidth().multiply(4.0);
    }

    @Override
    public Flux getDefaultFlux() {
        return PointingCalObs.getCalObsProperties().getPointingFlux();
    }

    @Override
    public Frequency getCalFrequency() {
        return Frequency.createFrequencyGHZ(100.0);
    }

    @Override
    public Time rawCalTime() throws InvalidFrequencyException, SourceNeverVisibleException {
        double d = ScienceSpectralWindow.getSingleContinuumBandwidth().getContentInUnits(Frequency.UNIT_HZ);
        Frequency frequency = this.getCalFrequency();
        double d2 = this.getAntenna().getBeamSize(frequency).getContentInUnits(Angle.UNIT_ARCSEC);
        double d3 = this.offsetPointingSpec.getContentInUnits(Angle.UNIT_ARCSEC);
        double d4 = this.getTsys().getContentInUnits(Temperature.UNIT_K);
        double d5 = this.getCalibratorFlux().getContentInUnits(Flux.UNIT_JY);
        double d6 = d5 * 1.0E-26;
        double d7 = 1.38E-23 * d4;
        d7 /= this.getCorrelatorEfficiency() * this.getEffectiveApertureArea() * d6;
        d7 *= d2 / d3;
        d7 *= d7;
        return Time.createTime((double)(d7 *= 2.0 / d / (double)this.getNoOfAntennas()), (String)Time.UNIT_S);
    }

    @Override
    public Time calTime(Time time) throws InvalidFrequencyException, SourceNeverVisibleException {
        if (this.SBSuggestedCalibrationDefaultIntegrationTime != null) {
            return this.SBSuggestedCalibrationDefaultIntegrationTime;
        }
        double d = time.getContentInUnits(Time.UNIT_S);
        double d2 = Math.max(d, 2.0);
        return Time.createTimeSec(d2 *= 6.0);
    }

    @Override
    public Time rawCycleTime() {
        if (this.SBSuggestedCalibrationCycleTime != null) {
            return this.SBSuggestedCalibrationCycleTime;
        }
        return PointingCalObs.getCalObsProperties().getPointingCycleTime();
    }
}

